/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef GUITABSWITCHBEHAVIOUR__H_
#define GUITABSWITCHBEHAVIOUR__H_

#include "GUIBehaviourDecorator.h"
#include "GUIObjectHandleResource.h"

/**
@brief Behaviour to switch between the children of a tab-container
*/
class CGUITabSwitchBehaviour : public CGUIBehaviourDecorator
{
public:
    /** Constructor
        @param eContainerID the id of the container whose children are switched
        @param eChildID the id the of child which should be set to visible
    */
    CGUITabSwitchBehaviour(const ObjectHandle_t& eContainerID, const ObjectHandle_t& eChildID);

    ///Default constructor
    CGUITabSwitchBehaviour();

#if defined(GUILIANI_STREAM_GUI)
    /** Reads all attributes from streaming file.
        This method is called by CGUIFactoryManager after one of the registered
        factories has created an instance of this class.
    */
    virtual void ReadFromStream();
#endif

#if defined(GUILIANI_WRITE_GUI)
    /** Writes all attributes to the streaming file. A CGUIStreamWriter
        has to be initialized first.
        @param bWriteClassID This flag is used to select if writing of command
               class ID, leading and trailing tags is performed.
    */
    virtual void WriteToStream(const eC_Bool bWriteClassID=false);
#endif

protected:
    virtual eC_Bool DoClick(
        const eC_Value &vAbsX,
        const eC_Value &vAbsY);

private:
    void Init();

private:
    ObjectHandle_t m_eContainer;
    ObjectHandle_t m_eTargetObject;
};

#endif
