/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef GUIOBJECTVISUALSBEHAVIOUR__H_
#define GUIOBJECTVISUALSBEHAVIOUR__H_

#include "GUIBehaviourDecorator.h"
#include "GUIObjectHandleResource.h"

/// @brief Behaviour for processing object visual changes
class CGUIObjectVisualsBehaviour : public CGUIBehaviourDecorator
{
public:
    /** Constructor
        @param eTargetObject The ID of the object to be modified by this command.
        @param bChangePosition If true, the position will be changed
        @param vTargetX Target value of the x-position
        @param vTargetY Target value of the y-position
        @param bChangeSize If true, the size will be changed
        @param vTargetWidth Target value of the width
        @param vTargetHeight Target value of the height
        @param bChangeAlpha If true, the alpha-value will be changed
        @param ubTargetAlpha Target value of the alpha
    */
    CGUIObjectVisualsBehaviour(
        ObjectHandle_t eTargetObject,
        eC_Bool bChangePosition,
        eC_Value vTargetX,
        eC_Value vTargetY,
        eC_Bool bChangeSize,
        eC_Value vTargetWidth,
        eC_Value vTargetHeight,
        eC_Bool bChangeAlpha,
        eC_UByte ubTargetAlpha);

    ///Default constructor
    CGUIObjectVisualsBehaviour();

#if defined(GUILIANI_STREAM_GUI)
    /** Reads all attributes from streaming file.
        This method is called by CGUIFactoryManager after one of the registered
        factories has created an instance of this class.
    */
    virtual void ReadFromStream();
#endif

#if defined(GUILIANI_WRITE_GUI)
    /** Writes all attributes to the streaming file. A CGUIStreamWriter
        has to be initialized first.
        @param bWriteClassID This flag is used to select if writing of command
               class ID, leading and trailing tags is performed.
    */
    virtual void WriteToStream(const eC_Bool bWriteClassID=false);
#endif

protected:
    virtual eC_Bool DoClick(
        const eC_Value &vAbsX,
        const eC_Value &vAbsY);

private:
    /// Target object ID.
    ObjectHandle_t m_eTargetObject;

    eC_Bool m_bChangePosition;
    eC_Value m_vTargetX;
    eC_Value m_vTargetY;

    eC_Bool m_bChangeSize;
    eC_Value m_vTargetWidth;
    eC_Value m_vTargetHeight;

    eC_Bool m_bChangeAlpha;
    eC_UByte m_ubTargetAlpha;
};

#endif
