/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef GUIKEYBOARDBEHAVIOUR__H_
#define GUIKEYBOARDBEHAVIOUR__H_

#include "GUIBehaviourDecorator.h"
#include "GUIObjectHandleResource.h"

/** Behaviour for use within an OnScreen-Keyboard / Virtual Keyboard.
@brief This behaviour sends a UTF16 keycode to the Keyboard in reaction to a ButtonUp-Event.
*/
class CGUIKeyboardBehaviour : public CGUIBehaviourDecorator
{
public:
    /** Constructor.
    @param uiKeyCode UTF16 KeyCode (e.g 0x0041 for 'A') which will be sent when this behaviour gets triggered.
    @param eTargetObject target-object to receive key
    */
    CGUIKeyboardBehaviour(const eC_UInt uiKeyCode = 0, ObjectHandle_t eTargetObject = NO_HANDLE);

    virtual eC_Bool DoButtonUp(const eC_Value &vAbsX, const eC_Value &vAbsY);

    virtual eC_Bool DoClick(const eC_Value &vAbsX, const eC_Value &vAbsY);

    /** Handle the given key and pass it to the target-object
    @param uiKeyCode key-code to handle
    */
    void HandleKey(const eC_UInt uiKeyCode);

#ifdef GUILIANI_STREAM_GUI
    virtual void ReadFromStream();
#endif
#ifdef GUILIANI_WRITE_GUI
    virtual void WriteToStream(const eC_Bool bWriteClassID = false);
#endif

protected:
    /// ID of CGUIEdit which shall receive the keyboard's output
    ObjectHandle_t m_eTargetObject;

    /// Unicode of key which shall be sent to the keyboard (e.g 0x0041 for 'A')
    eC_UInt m_uiKeyCode;
};

#endif
