/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#if !defined GUIANIMATION_TRIGGER__H_
#define GUIANIMATION_TRIGGER__H_

#include "GUIAnimation.h"

#include "GUICommand.h"

/**
    @brief This animation triggers a command

    @ingroup GUILIANI_ANIMATIONS

*/
class CGUIAnimationTrigger : public CGUIAnimation
{
public:
    /**
        Constructor
        @param pkCommand the command which will be executed
    */
    CGUIAnimationTrigger(CGUICommandPtr pkCommand);

#if defined(GUILIANI_STREAM_GUI)
    /**
        Default constructor for streaming.
    */
    CGUIAnimationTrigger();
#endif

   /**
    This function contains the animation logic. It typically accesses the animation's
    CGUIEasing functions to get the current values and sets these values in the animated object.
    This function is called by DoAnimate()
    @param uiElapsedTime Time elapsed (in ms) since start of animation.
    */
    void ApplyAnimation(eC_UInt uiElapsedTime);

    /**
        Makes sure that the object is visible when the animation is stopped or deleted.
        @param eStatus The new status of the animation.
    */
    void OnStatusChanged(AnimationStatus_t eStatus);

#if defined(GUILIANI_STREAM_GUI) || defined(GUILIANI_WRITE_GUI)
    /// The class version of the implementation.
    static const eC_UInt TRIGGER_ANIMATION_CLASS_VERSION;
#endif

#ifdef GUILIANI_STREAM_GUI
    void ReadFromStream();
#endif

#ifdef GUILIANI_WRITE_GUI
    void WriteToStream(const eC_Bool bWriteClassID = false);
#endif

private:
    void Init();

private:
    CGUICommandPtr m_pkCommand;
};

#endif
