/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef GUI_ANIMATED_ATTRIBUTE__H_
#define GUI_ANIMATED_ATTRIBUTE__H_

#include "eC_Math.h"
#include "GUIEasing.h"

/**
@brief This class defines a generic interface for attribute which are modified by animations
*/
class CGUIAnimatedAttribute
{
public:
    /** different types of attributes
    */
    enum AnimatedAttribute_t
    {
        ATTR_NONE = -1, ///< none
        ATTR_FIRST, ///< first in list
        ATTR_XPOS = ATTR_FIRST, ///< x-position
        ATTR_YPOS, ///< y-position
        ATTR_WIDTH, ///< width
        ATTR_HEIGHT, ///< height
        ATTR_ALPHA, ///< alpha-value
        ATTR_COUNT ///< number of enums
    };

public:
    /** Create a new AnimatedAttribute
    @param eAttributeType type of attribute
    @param eEasingType used easing
    @param vStartValue starting-value
    @param vTargetValue target value
    */
    CGUIAnimatedAttribute(
        const AnimatedAttribute_t& eAttributeType,
        const CGUIEasing::EasingType_t& eEasingType,
        const eC_Value& vStartValue,
        const eC_Value& vTargetValue);

    /** default-constructor
    */
    CGUIAnimatedAttribute();

    /** get attribute-type
    @return attribute-type
    */
    AnimatedAttribute_t GetAttributeType() const;

    /** set the easing-type
    @param eEasingType new easing-type
    */
    void SetEasingType(const CGUIEasing::EasingType_t& eEasingType);

    /** get easing-type
    @return easing-type
    */
    CGUIEasing::EasingType_t GetEasingType() const;

    /** set the start-value
    @param vValue new start-value
    */
    void SetStartValue(const eC_Value& vValue);

    /** get start-value
    @return start-value
    */
    eC_Value GetStartValue() const;

    /** set the target-value
    @param vValue new target-value
    */
    void SetTargetValue(const eC_Value& vValue);

    /** get target-value
    @return target-value
    */
    eC_Value GetTargetValue() const;

private:
    CGUIAnimatedAttribute::AnimatedAttribute_t m_eAttributeType; ///< attribute-type
    CGUIEasing::EasingType_t m_eEasingType; ///< Easing-type
    eC_Value m_vStartValue; ///< start-value
    eC_Value m_vTargetValue; ///< target-value
};

#endif
