
#
# Windows-cl-AMD64 settings file
#

# set output dirs

SET_TARGET_PROPERTIES(${PROJECT_NAME} PROPERTIES LIBRARY_OUTPUT_DIRECTORY "${PROJECT_SOURCE_DIR}/Libraries/${CMAKE_SYSTEM_NAME}-${CMAKE_SYSTEM_ARCH}/${CMAKE_CXX_COMPILER_ID}")
SET_TARGET_PROPERTIES(${PROJECT_NAME} PROPERTIES ARCHIVE_OUTPUT_DIRECTORY "${PROJECT_SOURCE_DIR}/Libraries/${CMAKE_SYSTEM_NAME}-${CMAKE_SYSTEM_ARCH}/${CMAKE_CXX_COMPILER_ID}")

FILE(GLOB GUILIANI_PLATFORM_WIN_CPP "${PROJECT_SOURCE_DIR}/Source/Platform/win/*.cpp" )
SOURCE_GROUP("Source Files\\Platform\\Windows" FILES ${GUILIANI_PLATFORM_WIN_CPP})
FILE(GLOB GUILIANI_PLATFORM_WIN_H "${PROJECT_SOURCE_DIR}/Include/Platform/win/*.h" )
SOURCE_GROUP("Header Files\\Platform\\Windows" FILES ${GUILIANI_PLATFORM_WIN_H})

# add dc-wrap
IF(GUILIANI_ADD_DCWRAP_PLATFORM)
  SET(GUILIANI_PLATFORM_WIN_CPP
    ${GUILIANI_PLATFORM_WIN_CPP}
    "${PROJECT_SOURCE_DIR}/Source/Platform/DAVE/DCWrapDAVE.cpp"
  )
ENDIF(GUILIANI_ADD_DCWRAP_PLATFORM)

IF(GUILIANI_ADD_EGML_PLATFORM)
  FILE(GLOB GUILIANI_PLATFORM_EGML_WIN_CPP "${PROJECT_SOURCE_DIR}/Source/Platform/eGML/win/*.cpp" )
  SOURCE_GROUP("Source Files\\Platform\\eGML\\win" FILES ${GUILIANI_PLATFORM_EGML_WIN_CPP})
  FILE(GLOB GUILIANI_PLATFORM_EGML_WIN_H "${PROJECT_SOURCE_DIR}/Include/Platform/eGML/win/*.h" )
  SOURCE_GROUP("Header Files\\Platform\\eGML\\win" FILES ${GUILIANI_PLATFORM_EGML_WIN_H})

  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_GUILIANI}/Include/Platform/eGML/win"
  )
ENDIF(GUILIANI_ADD_EGML_PLATFORM)

IF("${GUILIANI_OGL_PLATFORM}" STREQUAL "OpenGL")
  FILE(GLOB GUILIANI_PLATFORM_GL_OGL_WIN_CPP "${PROJECT_SOURCE_DIR}/Source/Platform/GL/OGL/win/*.cpp" )
  SOURCE_GROUP("Source Files\\Platform\\GL\\OGL\\win" FILES ${GUILIANI_PLATFORM_GL_OGL_WIN_CPP})
  FILE(GLOB GUILIANI_PLATFORM_GL_OGL_WIN_H "${PROJECT_SOURCE_DIR}/Include/Platform/GL/OGL/win/*.h" )
  SOURCE_GROUP("Header Files\\Platform\\GL\\OGL\\win" FILES ${GUILIANI_PLATFORM_GL_OGL_WIN_H})
  
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_GUILIANI}/Include/Platform/GL/OGL/win"
    PRIVATE "${PATH_LIBS}/opengl/include"
  )
ENDIF("${GUILIANI_OGL_PLATFORM}" STREQUAL "OpenGL")

IF(GUILIANI_ADD_DAVE_PLATFORM)
  FILE(GLOB GUILIANI_PLATFORM_DAVE_WIN_CPP "${PROJECT_SOURCE_DIR}/Source/Platform/DAVE/win/*.cpp" )
  SOURCE_GROUP("Source Files\\Platform\\DAVE\\win" FILES ${GUILIANI_PLATFORM_DAVE_WIN_CPP})
  FILE(GLOB GUILIANI_PLATFORM_DAVE_WIN_H "${PROJECT_SOURCE_DIR}/Include/Platform/DAVE/win/*.h" )
  SOURCE_GROUP("Header Files\\Platform\\DAVE\\win" FILES ${GUILIANI_PLATFORM_DAVE_WIN_H})

  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_GUILIANI}/Include/Platform/DAVE/win"
  )
ENDIF(GUILIANI_ADD_DAVE_PLATFORM)

IF(GUILIANI_ADD_BLU_PLATFORM)
  FILE(GLOB GUILIANI_PLATFORM_BLU_WIN_CPP "${PROJECT_SOURCE_DIR}/Source/Platform/BLU/win/*.cpp" )
  SOURCE_GROUP("Source Files\\Platform\\BLU\\win" FILES ${GUILIANI_PLATFORM_BLU_WIN_CPP})
  FILE(GLOB GUILIANI_PLATFORM_BLU_WIN_H "${PROJECT_SOURCE_DIR}/Include/Platform/BLU/win/*.h" )
  SOURCE_GROUP("Header Files\\Platform\\BLU\\win" FILES ${GUILIANI_PLATFORM_BLU_WIN_H})

  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_GUILIANI}/Include/Platform/BLU"
    PRIVATE "${PATH_GUILIANI}/Include/Platform/BLU/win"
    PRIVATE "${PATH_BLU}/Include"
  )
ENDIF(GUILIANI_ADD_BLU_PLATFORM)

SET(GUILIANI_PLATFORM_FILES 
  ${GUILIANI_PLATFORM_WIN_CPP}
  ${GUILIANI_PLATFORM_WIN_H}
  ${GUILIANI_PLATFORM_WIN_PC_CPP}
  ${GUILIANI_PLATFORM_WIN_PC_H}
  ${GUILIANI_PLATFORM_EGML_WIN_CPP}
  ${GUILIANI_PLATFORM_EGML_WIN_H}
  ${GUILIANI_PLATFORM_GL_OGL_WIN_CPP}
  ${GUILIANI_PLATFORM_GL_OGL_WIN_H}
  ${GUILIANI_PLATFORM_DAVE_WIN_CPP}
  ${GUILIANI_PLATFORM_DAVE_WIN_H}
  ${GUILIANI_PLATFORM_BLU_WIN_CPP}
  ${GUILIANI_PLATFORM_BLU_WIN_H}
)

TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
  PRIVATE "${PATH_GUILIANI}/Include/Platform/win"
)

# platform-dependencies
IF(GUILIANI_ADD_IMAGE_DECODER)
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_LIBS}/gif"
    PRIVATE "${PATH_LIBS}/nanosvg/include"
  )
ENDIF(GUILIANI_ADD_IMAGE_DECODER)

IF(EGAC_BUILD_IMAGELIBS)
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_EGAC}/intfs/ImageLibs/Gif"
    PRIVATE "${PATH_EGAC}/intfs/ImageLibs/Jpeg"
    PRIVATE "${PATH_EGAC}/intfs/ImageLibs/Jpeg/decompression"
    PRIVATE "${PATH_EGAC}/intfs/ImageLibs/png"
    PRIVATE "${PATH_EGAC}/intfs/ImageLibs/zlib"
  )
ELSE(EGAC_BUILD_IMAGELIBS)

    IF(LIBS_BUILD_LIBJPEG)
      TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
        PRIVATE "${PATH_LIBJPEG}"
      )
    ELSE(LIBS_BUILD_LIBJPEG)
      TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
        PRIVATE "${PATH_LIBS}/jpeg"
      )
    ENDIF(LIBS_BUILD_LIBJPEG)

    IF(LIBS_BUILD_LIBPNG)
      TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
        PRIVATE "${PATH_LIBPNG}"
      )
    ELSE(LIBS_BUILD_LIBPNG)
      TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
        PRIVATE "${PATH_LIBS}/png/lpng1636"
      )
    ENDIF(LIBS_BUILD_LIBPNG)

    # if zlib if built include-file is located in build-folder
    IF(NOT LIBS_BUILD_ZLIB)
      TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
        PRIVATE "${PATH_LIBS}/zlib/include"
      )
    ENDIF(NOT LIBS_BUILD_ZLIB)

ENDIF(EGAC_BUILD_IMAGELIBS)

IF(LIBS_BUILD_FREETYPE)
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_FREETYPE}/include" 
  )
ELSE(LIBS_BUILD_FREETYPE)
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_LIBS}/freetype/include" 
    PRIVATE "${PATH_LIBS}/freetype/include/freetype" 
  )
ENDIF(LIBS_BUILD_FREETYPE)
