/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifdef GUILIANI_STREAM_GUI

#ifndef CUSTOMSTANDARDFACTORY__H_
#define CUSTOMSTANDARDFACTORY__H_

#include "GUIFactory.h"

/**This define tells the StreamRuntime application that a custom standard factory exists.
   It will then be instantiated instead of the full Guiliani Standard Factory, thus allowing the linker
   to strip unused classes from the resulting binary. */
#define STREAMRUNTIME_CUSTOM_STANDARD_FACTORY_EXISTS

/// The following defines contain all classes which will be supported by this factory
/*<*STRIPPED_RESOURCES_DEFINES_BLK_BEGIN*/
/*<*STRIPPED_RESOURCES_DEFINES_BLK_END*/

#define STRIPPED_ANIMATION_TYPE_TABLE \
 ENTRY(ANIMATION_TRIGGER, CGUIAnimationTrigger) \
 ENTRY(ANIMATION_ATTRIBUTE, CGUIAnimationAttribute) \
 ENTRY(ANIMATION_STDGUIOBJECT, CGUIAnimationStdGUIObject) \
 ENTRY(ANIMATION_BLINKING, CGUIAnimationBlinking) \
 ENTRY(ANIMATION_MOVE_IN_OUT, CGUIAnimationMoveInOut) \
 ENTRY(ANIMATION_SIZE, CGUIAnimationSize) \
 ENTRY(ANIMATION_MOVE, CGUIAnimationMove)

/// Factory implementation for Guiliani standard classes. 

/** This factory was generated by the GSE CustomStandardFactory-Generator to contain only those classes 
    that are required by a specific StreamRuntime application.

    This implementation creates Guiliani standard controls, commands, texts,
    layouters, behaviour decorators and animations.
*/
class CustomStandardFactory : public CGUIFactory
{
public:
    /// Constructor.
    CustomStandardFactory();

    /// Destructor.
    virtual ~CustomStandardFactory();

protected:
    /// The factory manager keeps an object of this class.
    friend class CGUIFactoryManager;

    virtual CGUIObject* CreateControl(ControlClassID_t eControlID);

    virtual CGUILayouter* CreateLayouter(LayouterClassID_t eLayouterID);

    virtual CGUIBehaviourDecorator* CreateBehaviour(BehaviourClassID_t eBehaviourID);

    virtual CGUICommand* CreateCommand(CommandClassID_t eCommandID);

    virtual CGUIText* CreateText(TextTypeID_t eTextType);

#ifdef GUILIANI_ANIMATION_ACTIVE
    virtual CGUIAnimation* CreateAnimation(AnimationType_t eAnimation);
#endif

private:
    /** Copy-constructor.
        Dummy implementation to avoid unintended use of compiler-generated default    */
    CustomStandardFactory(const CustomStandardFactory& kSource);

    /** Assignment operator.
        Dummy implementation to avoid unintended use of compiler-generated default    */
    CustomStandardFactory& operator=(const CustomStandardFactory& kSource);
};
#endif
#endif
