#ifdef GUILIANI_STREAM_GUI

#include "CustomStandardFactory.h"

#include "GUI.h"
#include "GUITrace.h"
#include "GUIStreamingException.h"
#include "GUIStreamReader.h"
#include "GUIResourceFileHandler.h"

// behaviours
#include "GUIAutoRepeatBehaviour.h"
#include "GUIBehaviourDecorator.h"
#include "GUICompositeBehaviour.h"
#include "GUIHotkeysBehaviour.h"
#include "GUIKeyboardBehaviour.h"
#include "GUIMultiCmdBehaviour.h"
#include "GUIObjectStateBehaviour.h"
#include "GUIObjectVisualsBehaviour.h"
#include "GUISingleCmdBehaviour.h"
#include "GUITabSwitchBehaviour.h"

// layouters
#include "GUILayouter.h"
#include "GUILayouterAlignToParent.h"
#include "GUILayouterAnchor.h"
#include "GUILayouterGrid.h"
#include "GUILayouterList.h"
#include "GUILayouterPercentage.h"
#include "GUILayouterReposition.h"

// animations
#include "GUIAnimationAttribute.h"
#include "GUIAnimationBlinking.h"
#include "GUIAnimationMove.h"
#include "GUIAnimationMoveInOut.h"
#include "GUIAnimationSize.h"
#include "GUIAnimationStdGUIObject.h"
#include "GUIAnimationTrigger.h"

// commands
#include "GUICommand.h"
#include "GUICallAPICmd.h"
#include "GUIDelayCmd.h"
#include "GUILoadAnimationsCmd.h"
#include "GUILoadDialogCmd.h"
#include "GUIPlaybackSoundCmd.h"
#include "GUIQuitCmd.h"
#include "GUISetDataPoolCmd.h"
#include "GUISetObjectStateCmd.h"
#include "GUISetObjectVisualsCmd.h"
#include "GUIStartAnimationChainCmd.h"
#include "GUIStopAnimationChainCmd.h"
#include "GUISwitchResourceSetsCmd.h"
#include "GUITransitionCmd.h"

// controls
#include "GUIAnimatedImage.h"
#include "GUIBaseButton.h"
#include "GUIBaseCheckBox.h"
#include "GUIBaseInputField.h"
#include "GUIBaseMessageBox.h"
#include "GUIBaseRadioButton.h"
#include "GUIBaseSlider.h"
#include "GUIBaseTextField.h"
#include "GUIBlendButton.h"
#include "GUIButton.h"
#include "GUICalendar.h"
#include "GUICarousel.h"
#include "GUICenterFocusContainer.h"
#include "GUIChart.h"
#include "GUICheckBox.h"
#include "GUICircularSlider.h"
#include "GUIClock.h"
#include "GUIComboBox.h"
#include "GUIComboBoxHeader.h"
#include "GUICompositeObject.h"
#include "GUIEdit.h"
#include "GUIEditableText.h"
#include "GUIExpandingComposite.h"
#include "GUIFragmentContainer.h"
#include "GUIGauge.h"
#include "GUIGeometryObject.h"
#include "GUIGraph.h"
#include "GUIGroupContainer.h"
#include "GUIIconButton.h"
#include "GUIImage.h"
#include "GUIImageStack.h"
#include "GUIInputField.h"
#include "GUIKeyboard.h"
#include "GUIKnob.h"
#include "GUILayerContainer.h"
#include "GUIListBox.h"
#include "GUIListItem.h"
#include "GUIMenu.h"
#include "GUIMenuAndItem.h"
#include "GUIMenuBar.h"
#include "GUIMenuItem.h"
#include "GUIMenuItemSeparator.h"
#include "GUIMultiLineEdit.h"
#include "GUIObject.h"
#include "GUIPageContainer.h"
#include "GUIPlot.h"
#include "GUIPrimitiveButton.h"
#include "GUIProgressBar.h"
#include "GUIRadialBar.h"
#include "GUIRadialProgressBar.h"
#include "GUIRadialSlider.h"
#include "GUIRadioButton.h"
#include "GUIRadioButtonGroup.h"
#include "GUIRangeSlider.h"
#include "GUIRepositionCompositeObject.h"
#include "GUIRichText.h"
#include "GUIScrollBar.h"
#include "GUIScrollingText.h"
#include "GUIScrollingTextField.h"
#include "GUIScrollView.h"
#include "GUISegmentBar.h"
#include "GUISlider.h"
#include "GUISplitContainer.h"
#include "GUITabContainer.h"
#include "GUITableView.h"
#include "GUIText.h"
#include "GUITextField.h"
#include "GUITouchScrollView.h"
#include "GUIVideo.h"
#include "GUIWheel.h"
#include "GUIWheelContainer.h"

#include "GUIMemLeakWatcher.h"
#include "WindowsLeakWatcher.h"

CustomStandardFactory::CustomStandardFactory(void)
{
}

CustomStandardFactory::~CustomStandardFactory(void)
{
}

CGUIObject* CustomStandardFactory::CreateControl(ControlClassID_t eControlID)
{
    CGUIObject* pkNewObject=NULL;

    switch (eControlID)
    {
#define ENTRY(a, b) case a: pkNewObject = new b();           break;
    STRIPPED_CONTROL_TABLE
#undef ENTRY
    case DUMMY_CONTROL:
    default:
        break;
    }

    return pkNewObject;
}

CGUILayouter* CustomStandardFactory::CreateLayouter(LayouterClassID_t eLayouterID)
{
    CGUILayouter* pkNewLayouter=NULL;

    switch (eLayouterID)
    {
#define ENTRY(a, b) case a: pkNewLayouter = new b();           break;
    STRIPPED_LAYOUTER_TABLE
#undef ENTRY
    case DUMMY_LAYOUTER:
    default:
        break;
    }

    return pkNewLayouter;
}

CGUIBehaviourDecorator* CustomStandardFactory::CreateBehaviour(BehaviourClassID_t eBehaviourID)
{
    CGUIBehaviourDecorator* pkNewBehaviour=NULL;

    switch (eBehaviourID)
    {
#define ENTRY(a, b) case a: pkNewBehaviour = new b();           break;
    STRIPPED_BEHAVIOUR_TABLE
#undef ENTRY
    case DUMMY_BEHAVIOUR:
    default:
        break;
    }

    return pkNewBehaviour;
}

CGUICommand* CustomStandardFactory::CreateCommand(CommandClassID_t eCommandID)
{
    CGUICommand* pkNewCommand=NULL;

    switch (eCommandID)
    {
#define ENTRY(a, b) case a: pkNewCommand = new b();           break;
    STRIPPED_COMMAND_TABLE
#undef ENTRY
    case DUMMY_COMMAND:
    default:
        break;
    }

    return pkNewCommand;
}

CGUIText* CustomStandardFactory::CreateText(TextTypeID_t eTextType)
{
    CGUIText* pkNewText = NULL;

    switch (eTextType)
    {
#define ENTRY(a, b) case a: pkNewText = new b(NULL, DUMMY_TEXT);           break;
    STRIPPED_TEXTTYPE_TABLE
#undef ENTRY
    case TT_DUMMY_TEXT:
    default:
        break;
    }

    return pkNewText;
}

#ifdef GUILIANI_ANIMATION_ACTIVE
CGUIAnimation* CustomStandardFactory::CreateAnimation(AnimationType_t eAnimation)
{
    CGUIAnimation* pkNewAnimation = NULL;

    switch (eAnimation)
    {
#define ENTRY(a, b) case a: pkNewAnimation = new b();           break;
        STRIPPED_ANIMATION_TYPE_TABLE
#undef ENTRY
        case DUMMY_ANIMATION:
        default:
            break;
    }

    return pkNewAnimation;
}
#endif

#endif
