/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef __USERSETTINGSWIN_H__
#define __USERSETTINGSWIN_H__

#include "UserSettings.h"
#include "windows.h"

namespace gse
{

/// Platform-specific settings implementation for Win32.
class UserSettingsWin : public UserSettings
{
public:
    /** Creates the singleton instance.
        @param hWnd Handle of GSE's main window.
        @see UserSettings::DeleteInstance()
      */
    static void CreateInstance(HWND hWnd);

protected:
    /// Hidden singleton constructor.
    UserSettingsWin(HWND hWnd)
        : m_hWnd(hWnd)
    {}

    virtual eC_String GetPlatformSettingsDirectory();

    virtual eC_String GetPlatformSettingsSubDirectory();

    virtual eC_Bool WritePlatformWindowSettings();

    virtual void ReadPlatformWindowSettings();

    virtual void DefaultPlatformWindowSettings();

    virtual void UpdateWindowCaptionPlatformSpecific(const eC_String& kText);

    virtual eC_Bool IsWindowCreated();
    
    HWND m_hWnd;

private:
    /// Do not allow default construction.
    UserSettingsWin();
};

} // namespace gse
#endif //__USERSETTINGSWIN_H__
