/**
User-defined Text-Resources.
Each of these IDs maps to a text-string within the GUI.
ENTRY(TXT_USERTEXT01)
*/

#define USER_TEXT_TABLE \
/* 1 */ \
ENTRY(TXT_QUIT) \
ENTRY(TXT_SELECT) \
ENTRY(TXT_CANCEL) \
ENTRY(TXT_ADD_IMAGE) \
ENTRY(TXT_REMOVE_IMAGE) \
ENTRY(TXT_OK) \
ENTRY(TXT_CLOSE) \
ENTRY(TXT_YES) \
ENTRY(TXT_NO) \
ENTRY(TXT_NEWIMG_ID) \
ENTRY(TXT_NEWIMG_FILE) \
/* First text resources test. */ \
/* DO NOT REMOVE THE FOLLOWING TEXT ID !!! */ \
ENTRY(TXT_TEXT_RES_TEST_1) \
/* Top menu items */ \
ENTRY(TXT_MENU_FILE) \
ENTRY(TXT_MENU_EDIT) \
ENTRY(TXT_MENU_VIEW) \
ENTRY(TXT_MENU_LAYOUT) \
ENTRY(TXT_MENU_RESOURCES) \
ENTRY(TXT_MENU_CUSTOM_EXTENSIONS) \
ENTRY(TXT_MENU_WINDOW) \
ENTRY(TXT_MENU_HELP) \
/* Menus */ \
/* File menu */ \
ENTRY(TXT_MENU_FILE_NEW_PROJECT) \
ENTRY(TXT_MENU_FILE_NEW_FORM) \
ENTRY(TXT_MENU_FILE_OPEN_PROJECT) \
ENTRY(TXT_MENU_FILE_RECENT_PROJECTS) \
ENTRY(TXT_MENU_FILE_OPEN_FORM) \
ENTRY(TXT_MENU_FILE_IMPORT_FILE) \
ENTRY(TXT_MENU_FILE_SAVE_PROJECT) \
ENTRY(TXT_MENU_FILE_SAVE_PROJECT_AS) \
ENTRY(TXT_MENU_FILE_SETTINGS) \
ENTRY(TXT_MENU_FILE_RUN_SIMULATION) \
ENTRY(TXT_MENU_FILE_QUIT) \
ENTRY(TXT_MENU_FILE_CLOSE_PROJECT) \
ENTRY(TXT_MENU_FILE_CLOSE_FORM) \
/* Edit menu */ \
ENTRY(TXT_MENU_EDIT_UNDO) \
ENTRY(TXT_MENU_EDIT_REDO) \
ENTRY(TXT_MENU_EDIT_COPY) \
ENTRY(TXT_MENU_EDIT_CUT) \
ENTRY(TXT_MENU_EDIT_PASTE) \
ENTRY(TXT_MENU_EDIT_DELETE) \
ENTRY(TXT_MENU_EDIT_SELECT_ALL) \
ENTRY(TXT_MENU_EDIT_FIND) \
/* View menu */ \
ENTRY(TXT_MENU_VIEW_ZOOM_IN) \
ENTRY(TXT_MENU_VIEW_ZOOM_OUT) \
ENTRY(TXT_MENU_VIEW_SHOW_HELP_LINES) \
ENTRY(TXT_MENU_VIEW_HIDE_HELP_LINES) \
ENTRY(TXT_MENU_VIEW_TOGGLE_GRID) \
/* Layout menu */ \
ENTRY(TXT_MENU_LAYOUT_ARRANGE_OBJECTS) \
ENTRY(TXT_MENU_LAYOUT_ALIGN_OBJECTS) \
ENTRY(TXT_MENU_LAYOUT_GROUP_OBJECTS) \
ENTRY(TXT_MENU_LAYOUT_UNGROUP_OBJECTS) \
ENTRY(TXT_MENU_LAYOUT_SCALE_OBJECTS_SAME_SIZE) \
ENTRY(TXT_MENU_LAYOUT_FLIP_HORIZONTALLY) \
ENTRY(TXT_MENU_LAYOUT_FLIP_VERTICALLY) \
ENTRY(TXT_MENU_LAYOUT_ROTATE_CLOCKWISE) \
ENTRY(TXT_MENU_LAYOUT_ROTATE_COUNTERCLOCKWISE) \
/* Layout - arrange objects sub-menu */ \
ENTRY(TXT_MENU_LAYOUT_ARRANGE_OBJECTS_RAISE_OBJECT) \
ENTRY(TXT_MENU_LAYOUT_ARRANGE_OBJECTS_LOWER_OBJECT) \
ENTRY(TXT_MENU_LAYOUT_ARRANGE_OBJECTS_OBJECT_FRONT) \
ENTRY(TXT_MENU_LAYOUT_ARRANGE_OBJECTS_OBJECT_BACK) \
/* Layout - align objects sub-menu */ \
ENTRY(TXT_MENU_LAYOUT_ALIGN_OBJECTS_LEFT) \
ENTRY(TXT_MENU_LAYOUT_ALIGN_OBJECTS_RIGHT) \
ENTRY(TXT_MENU_LAYOUT_ALIGN_OBJECTS_TOP) \
ENTRY(TXT_MENU_LAYOUT_ALIGN_OBJECTS_BOTTOM) \
ENTRY(TXT_MENU_LAYOUT_ALIGN_OBJECTS_VERTICALLY) \
ENTRY(TXT_MENU_LAYOUT_ALIGN_OBJECTS_HORIZONTALLY) \
ENTRY(TXT_MENU_LAYOUT_ALIGN_OBJECTS_SIZE) \
ENTRY(TXT_MENU_LAYOUT_ALIGN_OBJECTS_RESIZE_TO_IMAGE) \
ENTRY(TXT_MENU_LAYOUT_DISTRIBUTE_OBJECTS_VERTICALLY) \
ENTRY(TXT_MENU_LAYOUT_DISTRIBUTE_OBJECTS_HORIZONTALLY) \
/* Resources menu */ \
ENTRY(TXT_MENU_RESOURCES_MANAGE) \
ENTRY(TXT_MENU_RESOURCES_IMAGES) \
ENTRY(TXT_MENU_RESOURCES_TEXTS) \
ENTRY(TXT_MENU_RESOURCES_FONTS) \
ENTRY(TXT_MENU_RESOURCES_SOUNDS) \
ENTRY(TXT_MENU_RESOURCES_GENRES) \
ENTRY(TXT_MENU_RESOURCES_DATAPOOL) \
ENTRY(TXT_MENU_RESOURCES_PROPERTIES) \
ENTRY(TXT_MENU_RESOURCES_REQUIREMENTS) \
ENTRY(TXT_MENU_RESOURCES_EXPORT) \
ENTRY(TXT_MENU_RESOURCES_IMPORT) \
ENTRY(TXT_MENU_RESOURCES_IMPORT_PSD) \
ENTRY(TXT_MENU_RESOURCES_FIND_UNUSED) \
/* Custom extension menu */ \
ENTRY(TXT_MENU_CUSTOM_EXTENSION_MANAGER) \
ENTRY(TXT_MENU_GENERATE_CUSTOM_STANDARDFACTORY) \
/* Window menu */ \
ENTRY(TXT_MENU_WINDOW_SHOW_CONTROLS) \
ENTRY(TXT_MENU_WINDOW_SHOW_WORKSPACE) \
ENTRY(TXT_MENU_WINDOW_SHOW_OBJ_HIERARCHY) \
ENTRY(TXT_MENU_WINDOW_SHOW_ATTRIBUTES) \
ENTRY(TXT_MENU_WINDOW_SHOW_DIALOG) \
ENTRY(TXT_MENU_WINDOW_SHOW_CONSOLE) \
ENTRY(TXT_MENU_WINDOW_ARRANGE) \
ENTRY(TXT_MENU_WINDOW_SHOW_ANIMATIONS) \
ENTRY(TXT_MENU_WINDOW_SHOW_WELCOME_SCREEN) \
/* Dialog window */ \
ENTRY(TXT_RESIZE_TO_IMAGE_TOOLTIP) \
ENTRY(TXT_DUPLICATE_TOOLTIP) \
ENTRY(TXT_TOGGLE_GUIDELINES_TOOLTIP) \
ENTRY(TXT_TOGGLE_GRIDLINES_TOOLTIP) \
ENTRY(TXT_TOGGLE_SNAPTOGUIDES_TOOLTIP) \
ENTRY(TXT_TOGGLE_COORDINATES_TOOLTIP) \
/* Help menu */ \
ENTRY(TXT_MENU_HELP_ABOUT) \
/* new dialog window */ \
ENTRY(TXT_NEW_DIALOG_CREATE) \
ENTRY(TXT_NEW_DIALOG_NAME) \
ENTRY(TXT_NEW_DIALOG_USE_RECENT_FORMAT) \
ENTRY(TXT_NEW_DIALOG_TEMPLATE) \
ENTRY(TXT_NEW_DIALOG_WIDTH) \
ENTRY(TXT_NEW_DIALOG_HEIGHT) \
ENTRY(TXT_NEW_DIALOG_SAVE_AS_TEMPLATE) \
ENTRY(TXT_NEW_DIALOG_REMOVE_TEMPLATE) \
ENTRY(TXT_NEW_DIALOG_PIXEL) \
/* search in dialog window */ \
ENTRY(TXT_SEARCH_DIALOG_TITLE) \
ENTRY(TXT_SEARCH_DIALOG_COL_DIALOG) \
ENTRY(TXT_SEARCH_DIALOG_COL_OBJECT) \
ENTRY(TXT_SEARCH_DIALOG_COL_ATTRIBUTE) \
ENTRY(TXT_SEARCH_FOR_ATTRIBUTE_TYPE_LBL) \
ENTRY(TXT_SEARCH_FOR_VALUE_LBL) \
ENTRY(TXT_SEARCH_IN_LBL) \
ENTRY(TXT_SEARCH_CURRENT_DIALOG) \
ENTRY(TXT_SEARCH_ALL_DIALOGS) \
ENTRY(TXT_SEARCH) \
ENTRY(TXT_SEARCH_FOR_ATTRIBUTE_NAME_LBL) \
/* search objectID window*/ \
ENTRY(TXT_SEARCH_OBJECT_DIALOG_TITLE) \
ENTRY(TXT_SEARCH_OBJECT_FOR_VALUE_LBL) \
ENTRY(TXT_SEARCH_OBJECT_SCOPE) \
ENTRY(TXT_SEARCH_OBJECT_SCOPE_GLOBAL) \
ENTRY(TXT_SEARCH_OBJECT_SCOPE_CURRENT_DIALOG) \
ENTRY(TXT_SEARCH_OBJECT_SCOPE_CHILDREN) \
ENTRY(TXT_SEARCH_OBJECT_HEADER_ID) \
ENTRY(TXT_SEARCH_OBJECT_HEADER_DIALOG) \
ENTRY(TXT_SEARCH_OBJECT_HEADER_CHILD) \
/* search error message box */ \
ENTRY(TXT_SEARCH_ERROR_RESULT_INVALID_TITLE) \
ENTRY(TXT_SEARCH_ERROR_RESULT_INVALID_DIALOG_MODIFIED) \
ENTRY(TXT_SEARCH_ERROR_RESULT_INVALID_SAVE) \
ENTRY(TXT_SEARCH_NO_RESULT_FOUND_TITLE) \
ENTRY(TXT_SEARCH_NO_RESULT_FOUND) \
ENTRY(TXT_SEARCH_MISSING_ATTRIBUTE_NAME_TITLE) \
ENTRY(TXT_SEARCH_MISSING_ATTRIBUTE_NAME) \
ENTRY(TXT_SEARCH_INVALID_SEARCH_VALUE_TITLE) \
ENTRY(TXT_SEARCH_INVALID_SEARCH_VALUE) \
/* find unused resources window */ \
ENTRY(TXT_FIND_UNUSED_RESOURCES_TITLE) \
ENTRY(TXT_FIND_UNUSED_RESOURCE_TYPE_LBL) \
ENTRY(TXT_FIND_UNUSED_RESOURCE_DELETE_ALL) \
ENTRY(TXT_FIND_UNUSED_RESOURCE_DELETE_SELECTED) \
/* import language window */ \
ENTRY(TXT_IMPORT_LANG_ADD) \
ENTRY(TXT_IMPORT_LANG_ONE) \
ENTRY(TXT_IMPORT_LANG_SET) \
ENTRY(TXT_IMPORT_LANG_INTO_SET) \
ENTRY(TXT_IMPORT_LANG_REMARK) \
ENTRY(TXT_IMPORT_LANG_LOAD) \
ENTRY(TXT_IMPORT_LANG_FILE_TYPE) \
ENTRY(TXT_IMPORT_LANGUAGE_EXISTS) \
ENTRY(TXT_IMPORT_LANGUAGE_OVERWRITE1) \
ENTRY(TXT_IMPORT_LANGUAGE_OVERWRITE2) \
ENTRY(TXT_IMPORT_LANG_FILE_NAME_EMPTY) \
/* export language window */ \
ENTRY(TXT_EXPORT_LANG_WINDOW_NAME) \
ENTRY(TXT_EXPORT_LANG_ONE) \
ENTRY(TXT_EXPORT_LANG_SET) \
ENTRY(TXT_EXPORT_LANG_FILE) \
ENTRY(TXT_EXPORT_LANG_SEPERATOR) \
ENTRY(TXT_EXPORT_LANG_FILE_TYPE) \
ENTRY(TXT_EXPORT_LANG_FILE_NAME_EMPTY) \
ENTRY(TXT_EXPORT_LANG_FOLDER_NAME_EMPTY) \
ENTRY(TXT_EXPORT_LANG_TEXT_ID) \
/* languages */ \
ENTRY(TXT_LANG_GERMAN) \
ENTRY(TXT_LANG_ENGLISH) \
ENTRY(TXT_LANG_FRENCH) \
/* manage sets (CreateRemoveRenameSet) */ \
ENTRY(TXT_CRRS_MANAGESETS) \
ENTRY(TXT_CRRS_MANAGEIMAGESETS) \
ENTRY(TXT_CRRS_MANAGEFONTSETS) \
ENTRY(TXT_CRRS_MANAGESOUNDSETS) \
ENTRY(TXT_CRRS_MANAGEGENRESSETS) \
ENTRY(TXT_CRRS_MANAGELANGUAGESETS) \
ENTRY(TXT_CRRS_MANAGEPROPERTYSETS) \
ENTRY(TXT_CRRS_VISIBLECREATE) \
ENTRY(TXT_CRRS_VISIBLEREMOVE) \
ENTRY(TXT_CRRS_VISIBLERENAME) \
ENTRY(TXT_CRRS_CREATE) \
ENTRY(TXT_CRRS_REMOVE) \
ENTRY(TXT_CRRS_RENAME) \
ENTRY(TXT_CRRS_COPYOLDSET) \
ENTRY(TXT_CRRS_NAMEOFSETCREATE) \
ENTRY(TXT_CRRS_NAMEOFSETRENAME) \
ENTRY(TXT_CRRS_NAMEOFCHOSENSETCREATE) \
ENTRY(TXT_CRRS_NAMEOFCHOSENSETREMOVE) \
ENTRY(TXT_CRRS_NAMEOFCHOSENSETRENAME) \
/* manage export-configurations */ \
ENTRY(TXT_MANAGE_EXPORTCONFIG_MANAGE) \
ENTRY(TXT_MANAGE_EXPORTCONFIG_VISIBLECREATE) \
ENTRY(TXT_MANAGE_EXPORTCONFIG_VISIBLEREMOVE) \
ENTRY(TXT_MANAGE_EXPORTCONFIG_VISIBLERENAME) \
ENTRY(TXT_MANAGE_EXPORTCONFIG_CREATE) \
ENTRY(TXT_MANAGE_EXPORTCONFIG_REMOVE) \
ENTRY(TXT_MANAGE_EXPORTCONFIG_RENAME) \
ENTRY(TXT_MANAGE_EXPORTCONFIG_CONFIG_COPY) \
ENTRY(TXT_MANAGE_EXPORTCONFIG_CONFIG_CREATE) \
ENTRY(TXT_MANAGE_EXPORTCONFIG_CONFIG_RENAME) \
ENTRY(TXT_MANAGE_EXPORTCONFIG_SELECTED_CONFIG_CREATE) \
ENTRY(TXT_MANAGE_EXPORTCONFIG_SELECTED_CONFIG_REMOVE) \
ENTRY(TXT_MANAGE_EXPORTCONFIG_SELECTED_CONFIG_RENAME) \
/* new font id window */ \
ENTRY(TXT_NEW_FNTID_NEW) \
ENTRY(TXT_NEW_FNTID_FILENAME) \
ENTRY(TXT_NEW_FNTID_NEWFNTID) \
ENTRY(TXT_NEW_FNTID_SIZE) \
/*HierarchyView */ \
ENTRY(TXT_HIERARCHYVIEW_WINDOW_TITLE) \
ENTRY(TXT_HIERARCHY_HEADER_OBJECT_ID) \
ENTRY(TXT_HIERARCHY_HEADER_VISIBLE) \
ENTRY(TXT_HIERARCHYVIEW_DRAG_INDICATOR) \
ENTRY(TXT_HIERARCHYVIEW_TOOLTIP_SHOW_FULL_DIALOG) \
ENTRY(TXT_HIERARCHYVIEW_TOOLTIP_SHOW_ZOOMED_DIALOG) \
ENTRY(TXT_HIERARCHYVIEW_TOOLTIP_EXPAND) \
ENTRY(TXT_HIERARCHYVIEW_TOOLTIP_COLLAPSE) \
ENTRY(TXT_HIERARCHYVIEW_TOOLTIP_TOGGLE_SIDEBAR) \
ENTRY(TXT_HIERARCHYVIEW_TOOLTIP_VISIBILITY) \
ENTRY(TXT_HIERARCHYVIEW_TOOLTIP_COMMAND) \
ENTRY(TXT_HIERARCHYVIEW_TOOLTIP_BEHAVIOUR) \
ENTRY(TXT_HIERARCHYVIEW_TOOLTIP_LAYOUTER) \
/*Attributes */ \
ENTRY(TXT_ATTRIBUTES_WINDOW_TITLE) \
ENTRY(TXT_ATTRIBUTES_COLUMN_ATTRIBUTE) \
ENTRY(TXT_ATTRIBUTES_COLUMN_VALUE) \
ENTRY(TXT_ATTRIBUTES_WINDOW_ADD_MORE) \
ENTRY(TXT_ATTRIBUTES_MSG_ERROR_ATTRIBUTE_FLOAT_VALUE) \
ENTRY(TXT_ATTRIBUTES_MSG_ERROR_ATTRIBUTE_INT_VALUE) \
ENTRY(TXT_ATTRIBUTES_MSG_ERROR_ATTRIBUTE_UNSIGNED_VALUE) \
ENTRY(TXT_BTN_ATTRIBUTE_VALUE_TOOLTIP) \
ENTRY(TXT_BTN_ATTRIBUTE_PROPERTY_TOOLTIP) \
/*AnimationsView */ \
ENTRY(TXT_ANIMATIONS_WINDOW_TITLE) \
ENTRY(TXT_ANIMATIONS_PLAY_TOOLTIP) \
ENTRY(TXT_ANIMATIONS_JUMP_BACK_TOOLTIP) \
ENTRY(TXT_ANIMATIONS_PAUSE_TOOLTIP) \
ENTRY(TXT_ANIMATIONS_RECORD_TOOLTIP) \
ENTRY(TXT_ANIMATIONS_STOP_TOOLTIP) \
ENTRY(TXT_ANIMATIONS_DISCONNECT_TOOLTIP) \
ENTRY(TXT_ANIMATIONS_CONNECT_TOOLTIP) \
ENTRY(TXT_ANIMATIONS_APPLY_START_TOOLTIP) \
ENTRY(TXT_ANIMATIONS_APPLY_TARGET_TOOLTIP) \
ENTRY(TXT_ANIMATIONS_TOGGLE_SNAP_TOOLTIP) \
ENTRY(TXT_ANIMATIONS_GRAB_LEFT_ATTRIBUTE_TOOLTIP) \
ENTRY(TXT_ANIMATIONS_TIMER_ON_OFF_TOOLTIP) \
ENTRY(TXT_ANIMATIONS_GRAB_RIGHT_ATTRIBUTE_TOOLTIP) \
ENTRY(TXT_ANIMATIONS_ADD_ANICHAIN_TOOLTIP) \
ENTRY(TXT_ANIMATIONS_REMOVE_ANI_TOOLTIP) \
ENTRY(TXT_ANIMATIONS_FIND_OBJECT_TOOLTIP) \
ENTRY(TXT_ANIMATIONS_PREVIEW) \
ENTRY(TXT_ANIMATIONS_ADD_ANIMATION_TOOLTIP) \
ENTRY(TXT_ANIMATIONS_ZOOM_IN_TOOLTIP) \
ENTRY(TXT_ANIMATIONS_ZOOM_OUT_TOOLTIP) \
ENTRY(TXT_ANIMATIONS_REMOVE_ANI_CHAIN_TOOLTIP) \
ENTRY(TXT_ANIMATIONS_COPY_ANI_CHAIN_TOOLTIP) \
ENTRY(TXT_ANIMATIONS_COPY_ANI_TOOLTIP) \
ENTRY(TXT_ANIMATIONS_REPEAT_ANI_CHAIN_TOOLTIP) \
/*Selection Pane*/ \
ENTRY(TXT_SELECTION_PANE_SELECTION_START) \
ENTRY(TXT_SELECTION_PANE_SELECTION_END) \
ENTRY(TXT_SELECTION_PANE_MOUSE_POSITION) \
ENTRY(TXT_SELECTION_PANE_MODE_ANIMATION) \
ENTRY(TXT_SELECTION_PANE_MODE_RECORDING) \
/*Control Templates */ \
ENTRY(TXT_CONTROL_TEMPLATES_WINDOW_TITLE) \
/* settings window */ \
ENTRY(TXT_GLOBAL_SETTINGS) \
ENTRY(TXT_PROJECT_SETTINGS) \
ENTRY(TXT_EXPORT_SETTINGS) \
ENTRY(TXT_SETTINGS_GLOBAL_PROJ_DIR) \
ENTRY(TXT_SETTINGS_GLOBAL_PROJ_DIR_TOOLTIP) \
ENTRY(TXT_SETTINGS_GLOBAL_LANG_FILE) \
ENTRY(TXT_SETTINGS_GLOBAL_LANG_FILE_ERROR_TITLE) \
ENTRY(TXT_SETTINGS_GLOBAL_LANG_FILE_ERROR_MSG) \
ENTRY(TXT_SETTINGS_GLOBAL_IMAGESET) \
ENTRY(TXT_SETTINGS_GLOBAL_AUTO_OPEN_CONSOLE) \
ENTRY(TXT_SETTINGS_GLOBAL_KEEP_TEMP_DIRECTORY) \
ENTRY(TXT_SETTINGS_GLOBAL_SHOW_TOOLTIPS) \
ENTRY(TXT_SETTINGS_GLOBAL_AUTOOPEN_LASTPROJECT) \
ENTRY(TXT_SETTINGS_GLOBAL_SKIP_CORRUPTED_DATA) \
ENTRY(TXT_SETTINGS_GLOBAL_COLOR_HEADLINE) \
ENTRY(TXT_SETTINGS_GLOBAL_COLOR_GUIDELINES) \
ENTRY(TXT_SETTINGS_GLOBAL_COLOR_GUIDELINES_TOOLTIP) \
ENTRY(TXT_SETTINGS_GLOBAL_COLOR_WORKSPACEBACKGROUND) \
ENTRY(TXT_SETTINGS_GLOBAL_COLOR_WORKSPACEBACKGROUND_TOOLTIP) \
ENTRY(TXT_SETTINGS_GLOBAL_COLOR_DROPHIGHLIGHT) \
ENTRY(TXT_SETTINGS_GLOBAL_COLOR_DROPHIGHLIGHT_TOOLTIP) \
ENTRY(TXT_SETTINGS_GLOBAL_RECORDING_INTERVAL_HEADER) \
ENTRY(TXT_SETTINGS_GLOBAL_RECORDING_INTERVAL) \
ENTRY(TXT_SETTINGS_GLOBAL_CLEAR_RECENT_PROJECTS) \
ENTRY(TXT_SETTINGS_GLOBAL_CLEAR_RECENT_PROJECTS_TOOLTIP) \
ENTRY(TXT_SETTINGS_GLOBAL_RESET_SETTINGS) \
ENTRY(TXT_SETTINGS_GLOBAL_RESET_SETTINGS_TOOLTIP) \
ENTRY(TXT_SETTINGS_PROJECT_IMP_DIR) \
ENTRY(TXT_SETTINGS_PROJECT_IMP_DIR_TOOLTIP) \
ENTRY(TXT_SETTINGS_PROJECT_SIMULATOR_HEADER) \
ENTRY(TXT_SETTINGS_PROJECT_CUSTOMEXTENSION_DIR) \
ENTRY(TXT_SETTINGS_PROJECT_CUSTOMEXTENSION_DIR_TOOLTIP) \
ENTRY(TXT_SETTINGS_PROJECT_CUSTOMEXTENSION_DIR_NOT_EXISTS) \
ENTRY(TXT_SETTINGS_PROJECT_SIMULATOR_DIR) \
ENTRY(TXT_SETTINGS_PROJECT_SIMULATOR_DIR_TOOLTIP) \
ENTRY(TXT_SETTINGS_PROJECT_SIMULATOR_DIR_NOT_EXISTS) \
ENTRY(TXT_SETTINGS_PROJECT_LANG_HEADER) \
ENTRY(TXT_SETTINGS_PROJECT_LANG_SEPARATOR) \
ENTRY(TXT_SETTINGS_PROJECT_LANG_OVERWRITE) \
ENTRY(TXT_SETTINGS_PROJECT_IMP_DIR_NOTEMPTY) \
ENTRY(TXT_SETTINGS_PROJECT_DETECT_CORRUPTEDDIALOGS) \
ENTRY(TXT_SETTINGS_PROJECT_DETECT_CORRUPTEDDIALOGS_TOOLTIP) \
ENTRY(TXT_SETTINGS_PROJECT_GRIDSIZE_HEADER) \
ENTRY(TXT_SETTINGS_PROJECT_GRIDSIZE_X) \
ENTRY(TXT_SETTINGS_PROJECT_GRIDSIZE_Y) \
ENTRY(TXT_SETTINGS_PROJECT_COPY_IDENTICAL_FILES) \
ENTRY(TXT_SETTINGS_PROJECT_ENDIANESS_ALIGNMENT_HEADER) \
ENTRY(TXT_SETTINGS_PROJECT_DEFAULT_EXPORT_FORMAT_HEADER) \
ENTRY(TXT_SETTINGS_PROJECT_DEFAULT_IMAGE_FORMAT_HEADER) \
ENTRY(TXT_SETTINGS_PROJECT_DEFAULT_FONT_FORMAT_HEADER) \
ENTRY(TXT_SETTINGS_PROJECT_FONT_EXPORTCOUNT) \
ENTRY(TXT_SETTINGS_PROJECT_RESET_EXPORTFORMAT) \
ENTRY(TXT_SETTINGS_PROJECT_RESET_IMAGES_TOOLTIP) \
ENTRY(TXT_SETTINGS_PROJECT_RESET_FONTS_TOOLTIP) \
ENTRY(TXT_SETTINGS_PROJECT_OBJECTID_GENERATION_HEADER) \
ENTRY(TXT_SETTINGS_PROJECT_OBJECTID_GENERATION_DUPLICATES) \
ENTRY(TXT_SETTINGS_PROJECT_OBJECTID_GENERATION_ALLOW) \
ENTRY(TXT_SETTINGS_PROJECT_OBJECTID_GENERATION_RENAME) \
ENTRY(TXT_SETTINGS_PROJECT_OBJECTID_GENERATION_NOHANDLE) \
ENTRY(TXT_SETTINGS_PROJECT_OBJECTID_GENERATION_TOOLTIP) \
ENTRY(TXT_SETTINGS_PROJECT_OBJECTID_GENERATION_RULE) \
ENTRY(TXT_SETTINGS_PROJECT_OBJECTID_GENERATION_RULE_TOOLTIP) \
ENTRY(TXT_SETTINGS_PROJECT_OBJECTID_GENERATION_RULE_ERROR) \
/* Requirements view */ \
ENTRY(TXT_REQVIEW_REQNUMBER) \
ENTRY(TXT_REQVIEW_REQID) \
ENTRY(TXT_REQVIEW_REQTEXT) \
ENTRY(TXT_REQVIEW_DIALOGID) \
ENTRY(TXT_REQVIEW_OBJECTID) \
ENTRY(TXT_REQVIEW_AFFECTEDREQS) \
/* Requirements window */ \
ENTRY(TXT_REQUIREMENTS_HEADER) \
ENTRY(TXT_REQUIREMENTS_NEW) \
ENTRY(TXT_REQUIREMENTS_EDIT) \
ENTRY(TXT_REQUIREMENTS_DELETE) \
ENTRY(TXT_REQUIREMENTS_SHOW) \
ENTRY(TXT_REQUIREMENTS_EXPORT) \
ENTRY(TXT_REQUIREMENTS_EXPORT_MESSAGE_HEADER) \
ENTRY(TXT_REQUIREMENTS_EXPORT_ASK_TEXT) \
ENTRY(TXT_REQUIREMENTS_EXPORT_OK) \
ENTRY(TXT_REQUIREMENTS_ERROR_DIALOG_UNSAVED) \
ENTRY(TXT_REQUIREMENTS_ERROR_WANT_TO_SAVE) \
/* Edit requirements window */ \
ENTRY(TXT_EDITREQS_HEADER) \
ENTRY(TXT_EDITREQS_REQ_NUMBER) \
ENTRY(TXT_EDITREQS_REQ_NUMBER_TOOLTIP) \
ENTRY(TXT_EDITREQS_REQ_ID) \
ENTRY(TXT_EDITREQS_REQ_ID_TOOLTIP) \
ENTRY(TXT_EDITREQS_DIALOG_ID) \
ENTRY(TXT_EDITREQS_OBJECT_ID) \
ENTRY(TXT_EDITREQS_AFFECTED_REQS) \
ENTRY(TXT_EDITREQS_AFFECTED_REQS_TOOLTIP) \
ENTRY(TXT_EDITREQS_BUTTON_ADD) \
ENTRY(TXT_EDITREQS_BUTTON_REMOVE) \
ENTRY(TXT_EDITREQS_NO_DIALOG) \
ENTRY(TXT_EDITREQS_NO_OBJECT) \
ENTRY(TXT_EDITREQS_REQID_NOT_EMPTY) \
ENTRY(TXT_EDITREQS_REQID_NOT_UNIQUE) \
ENTRY(TXT_EDITREQS_REQTEXT_NOT_EMPTY) \
ENTRY(TXT_EDITREQS_DELETE_REQS) \
ENTRY(TXT_EDITREQS_WANT_TO_DELETE_1) \
ENTRY(TXT_EDITREQS_WANT_TO_DELETE_2) \
ENTRY(TXT_EDITREQS_CREATE) \
/* export window */ \
ENTRY(TXT_EXPORT_DIRECTORY) \
ENTRY(TXT_ELLIPSIS) \
ENTRY(TXT_EXPORTCONFIG_CONFIGNAME) \
ENTRY(TXT_EXPORTCONFIG_MANAGE_CONFIG) \
ENTRY(TXT_EXPORTCONFIG_SIZE) \
ENTRY(TXT_EXPORTCONFIG_ACTIVATE_BKGCOLOR) \
ENTRY(TXT_EXPORTCONFIG_BACKGROUND_COLOR) \
ENTRY(TXT_EXPORTCONFIG_RESFILEHEAD_TOOLTIP) \
ENTRY(TXT_EXPORTCONFIG_RESFILEHEAD1) \
ENTRY(TXT_EXPORTCONFIG_RESFILEHEAD2) \
ENTRY(TXT_EXPORTCONFIG_RESFILE_TOOLTIP) \
ENTRY(TXT_EXPORTCONFIG_RESFILE1) \
ENTRY(TXT_EXPORTCONFIG_RESFILE2) \
ENTRY(TXT_EXPORTCONFIG_RESFILEHEAD2SIMU) \
ENTRY(TXT_EXPORTCONFIG_RESFILE2SIMU) \
ENTRY(TXT_EXPORTCONFIG_START_DIALOG) \
ENTRY(TXT_EXPORTCONFIG_IMAGESET) \
ENTRY(TXT_EXPORTCONFIG_FONTSET) \
ENTRY(TXT_EXPORTCONFIG_SOUNDSET) \
ENTRY(TXT_EXPORTCONFIG_GENRESSET) \
ENTRY(TXT_EXPORTCONFIG_LANGUAGE) \
ENTRY(TXT_EXPORTCONFIG_PROPERTYSET) \
ENTRY(TXT_EXPORTCONFIG_RESOURCEDIR) \
ENTRY(TXT_EXPORTCONFIG_RESOURCEDIR_TOOLTIP) \
ENTRY(TXT_EXPORT_SIMULATOR_APPLICATION) \
ENTRY(TXT_EXPORT_DEFAULT_SIMULATOR) \
ENTRY(TXT_EXPORT_CUSTOM_SIMULATOR) \
ENTRY(TXT_EXPORTCONFIG_STREAMING_MODE) \
ENTRY(TXT_EXPORTCONFIG_XML_LABEL) \
ENTRY(TXT_EXPORTCONFIG_BINARY_LABEL) \
ENTRY(TXT_EXPORTCONFIG_SELECT_IMAGESETS) \
ENTRY(TXT_EXPORTCONFIG_SELECT_FONTSETS) \
ENTRY(TXT_EXPORTCONFIG_SELECT_SOUNDSETS) \
ENTRY(TXT_EXPORTCONFIG_SELECT_GENRESSETS) \
ENTRY(TXT_EXPORTCONFIG_SELECT_LANGUAGES) \
ENTRY(TXT_EXPORTCONFIG_SELECT_PROPERTYSETS) \
ENTRY(TXT_EXPORTCONFIG_STRD_RESOURCES) \
ENTRY(TXT_EXPORT_OVERWRITE_STREAMRUNTIME_HEADERS) \
ENTRY(TXT_EXPORT_OVERWRITE_STREAMRUNTIME_HEADERS_TOOLTIP) \
ENTRY(TXT_EXPORT_COPY_SIMULATOR) \
ENTRY(TXT_EXPORT_COPY_SIMULATOR_TOOLTIP) \
ENTRY(TXT_EXPORT_SHOW_STATISTICS) \
ENTRY(TXT_EXPORT_SHOW_STATISTICS_TOOLTIP) \
ENTRY(TXT_EXPORT_REPLACE_DUPLICATES) \
ENTRY(TXT_EXPORT_REPLACE_DUPLICATES_TOOLTIP) \
ENTRY(TXT_EXPORTCONFIG_SCRIPTS_HEADLINE) \
ENTRY(TXT_EXPORTCONFIG_PREPROCESSING_SCRIPT) \
ENTRY(TXT_EXPORTCONFIG_POSTPROCESSING_SCRIPT) \
ENTRY(TXT_EXPORTCONFIG_FLASHING_SCRIPT) \
ENTRY(TXT_EXPORTCONFIG_SCRIPT_TOOLTIP) \
/* export set selection window */ \
ENTRY(TXT_EXPORT_SETSELECTION_WINDOWTITLE) \
ENTRY(TXT_EXPORT_SETSELECTION_HELPTEXT) \
ENTRY(TXT_EXPORT_SETSELECTION_COLUMN_EXPORT) \
ENTRY(TXT_EXPORT_SETSELECTION_COLUMN_NAME) \
ENTRY(TXT_EXPORT_SETSELECTION_MSG_SELECT_ONE) /* error message box 'select at least one set' */ \
/* export progress window */ \
ENTRY(TXT_EXPORTING) \
ENTRY(TXT_EXPORTING_PLEASE_WAIT) \
ENTRY(TXT_EXPORTING_REMOVE_TEMP_FOLDER) \
ENTRY(TXT_EXPORTING_COPY_STREAMRUNTIME) \
ENTRY(TXT_EXPORTING_PREPROCESSING_SCRIPT) \
ENTRY(TXT_EXPORTING_ID_HEADERS) \
ENTRY(TXT_EXPORTING_RESOURCE_DEFINITIONS) \
ENTRY(TXT_EXPORTING_LANGUAGES) \
ENTRY(TXT_EXPORTING_DIALOG) \
ENTRY(TXT_EXPORTING_IMAGES) \
ENTRY(TXT_EXPORTING_FONTS) \
ENTRY(TXT_EXPORTING_SOUNDS) \
ENTRY(TXT_EXPORTING_GEN_RESOURCES) \
ENTRY(TXT_EXPORTING_POSTPROCESSING_SCRIPT) \
ENTRY(TXT_EXPORTING_RESOURCE_HEADER) \
ENTRY(TXT_EXPORTING_RESOURCE_FILE) \
ENTRY(TXT_EXPORTING_FLASHING_SCRIPT) \
ENTRY(TXT_EXPORTING_DONE) \
/* "Export of headers and recompilation of StreamRuntime recommended"-MessageBox */ \
ENTRY(TXT_EXPORT_HEADERS_RECOMMENDED_TITLE) \
ENTRY(TXT_EXPORT_HEADERS_RECOMMENDED_EXPLANATION) \
/* error message during export */ \
ENTRY(TXT_EXPORTING_ERROR_TITLE) \
ENTRY(TXT_EXPORTING_ERROR_TEXT) \
ENTRY(TXT_EXPORTING_ERROR_NO_STARTDIALOG) \
ENTRY(TXT_EXPORTING_ERROR_INVALID_SIZE) \
ENTRY(TXT_EXPORTING_ERROR_SIMULATOR_NOT_FOUND) \
/* import window */ \
ENTRY(TXT_IMPORT_FILE) \
ENTRY(TXT_IMPORT_ADD_DIALOG) \
ENTRY(TXT_IMPORT_REMOVE_DIALOG) \
/* import resources window */ \
ENTRY(TXT_IMPORT_RES_PREPARERES) \
ENTRY(TXT_IMPORT_RES_ROOT) \
ENTRY(TXT_IMPORT_RES_IMGCONF) \
ENTRY(TXT_IMPORT_RES_FONTCONF) \
ENTRY(TXT_IMPORT_RES_SOUNDCONF) \
ENTRY(TXT_IMPORT_RES_GENRESCONF) \
ENTRY(TXT_IMPORT_RES_LANGCONF) \
ENTRY(TXT_IMPORT_RES_AUTORES_OK) \
ENTRY(TXT_IMPORT_RES_AUTORES_FAILED) \
/* import touchgfx-project */ \
ENTRY(TXT_IMPORT_TOUCHGFX_OK) \
ENTRY(TXT_IMPORT_TOUCHGFX_FAILED) \
/* import psd-file */ \
ENTRY(TXT_IMPORT_PSDFILE_ERROR_IMPORT) \
ENTRY(TXT_IMPORT_PSDFILE_MSG_ERROR_FILENAME_EMPTY) \
ENTRY(TXT_IMPORT_PSDFILE_MSG_ERROR_READ_PSD) \
/* process psd-file */ \
ENTRY(TXT_PROCESS_PSDFILE_IMPORTIMAGES) \
ENTRY(TXT_PROCESS_PSDFILE_OVERWRITEIMAGES) \
ENTRY(TXT_PROCESS_PSDFILE_IMPORTLAYER) \
ENTRY(TXT_PROCESS_PSDFILE_APPLY_TEXT_CORRECTION) \
ENTRY(TXT_PROCESS_PSDFILE_CREATE_TEXTRESOURCES) \
ENTRY(TXT_PROCESS_PSDFILE_CREATECONTROLS) \
ENTRY(TXT_PROCESS_PSDFILE_OVERWRITE_DIALOGS) \
ENTRY(TXT_PROCESS_PSDFILE_COLUMN_IMPORT) \
ENTRY(TXT_PROCESS_PSDFILE_COLUMN_NAME) \
ENTRY(TXT_PROCESS_PSDFILE_DIALOGS_SETALL) \
ENTRY(TXT_PROCESS_PSDFILE_DIALOGS_CLEARALL) \
ENTRY(TXT_PROCESS_PSDFILE_MSG_HEADLINE) \
ENTRY(TXT_PROCESS_PSDFILE_MSG_SUCCESSFUL) \
ENTRY(TXT_PROCESS_PSDFILE_MSG_WARNINGS) \
/* TextID window */ \
ENTRY(TXT_TXTID_TRANSLATE_LANG) \
ENTRY(TXT_TXTID_COMPARE_LANG) \
ENTRY(TXT_TXTID_PREVIEW_FONT) \
ENTRY(TXT_TXTID_PREVIEW_FONT_REF) \
ENTRY(TXT_TXTID_FILTER) \
ENTRY(TXT_TXTID_IMPORT_LANG) \
ENTRY(TXT_TXTID_EXPORT_LANG) \
ENTRY(TXT_TXTID_ACTIONS) \
ENTRY(TXT_TXTID_REMOVE) \
ENTRY(TXT_TXTID_NEW) \
ENTRY(TXT_TXTID_COMPARATIVE_TEXT) \
ENTRY(TXT_TXTID_TRANSLATION) \
ENTRY(TXT_TXTID_CHECK_TEXT_TRUNC) \
/* Text truncation window */ \
ENTRY(TXT_TXTTRUNC_HEADER) \
ENTRY(TXT_TXTTRUNC_ERROR_DIALOG_UNSAVED) \
ENTRY(TXT_TXTTRUNC_ERROR_WANT_TO_SAVE) \
/* Font ID window */ \
ENTRY(TXT_FNTID_VIEW) \
ENTRY(TXT_FNTID_APPLY) \
ENTRY(TXT_FNTID_CHANGE) \
ENTRY(TXT_FNTID_INSERT) \
ENTRY(TXT_FNTID_ACTIONS) \
ENTRY(TXT_FNTID_REMOVE) \
ENTRY(TXT_FNTID_NEW) \
ENTRY(TXT_FNTID_FILTER) \
/* Property ID window */ \
ENTRY(TXT_PROPID_VIEW) \
ENTRY(TXT_PROPID_APPLY) \
ENTRY(TXT_PROPID_CHANGE) \
ENTRY(TXT_PROPID_INSERT) \
ENTRY(TXT_PROPID_ACTIONS) \
ENTRY(TXT_PROPID_REMOVE) \
ENTRY(TXT_PROPID_NEW) \
ENTRY(TXT_PROPID_FILTER) \
ENTRY(TXT_PROPID_COLORPICKER) \
/* new object id window */ \
ENTRY(TXT_NEW_OBJID_NEW) \
ENTRY(TXT_NEW_OBJID_ENTER_NAME) \
ENTRY(TXT_NEW_OBJID_NEWOBJID) \
/* combo-box in attribute view */ \
ENTRY(TXT_COMBO_NEW_OBJECTID) \
ENTRY(TXT_COMBO_RENAME_OBJECTID) \
ENTRY(TXT_COMBO_FIND_OBJECTID) \
ENTRY(TXT_INVALID_OBJECTID_TITLE) \
ENTRY(TXT_OBJECTID_EXISTS) \
/* new text id window */ \
ENTRY(TXT_NEW_TXTID_NEW) \
ENTRY(TXT_NEW_TXTID_ENTER_NAME) \
ENTRY(TXT_NEW_TXTID_NEWTXTID) \
/* message box 'text ID already exists' */ \
ENTRY(TXT_MSG_INVALID_TEXT_ID_TITLE) \
ENTRY(TXT_MSG_TEXT_ID_EXISTS) \
/* new property id window */ \
ENTRY(TXT_NEW_PROPID_NEW) \
ENTRY(TXT_NEW_PROPID_ENTER_NAME) \
ENTRY(TXT_NEW_PROPID_ENTER_VALUE) \
ENTRY(TXT_NEW_PROPID_ENTER_TYPE) \
/* message box 'property ID already exists' */ \
ENTRY(TXT_MSG_INVALID_PROPERTY_ID_TITLE) \
ENTRY(TXT_MSG_PROPERTY_ID_EXISTS) \
/* new project window */ \
ENTRY(TXT_NEW_PROJ_SAVEDIR) \
ENTRY(TXT_NEW_PROJ_BROWSE) \
ENTRY(TXT_NEW_PROJ_NAME) \
ENTRY(TXT_NEW_PROJ_NAME_TOOLTIP) \
/* image management window */ \
ENTRY(TXT_IMGID_VIEW) \
ENTRY(TXT_IMGID_APPLY) \
ENTRY(TXT_IMGID_CHANGE) \
ENTRY(TXT_IMGID_INSERT) \
ENTRY(TXT_IMGID_ACTIONS) \
ENTRY(TXT_IMGID_REMOVE) \
ENTRY(TXT_IMGID_FILTER) \
/* quit message box */ \
ENTRY(TXT_MSG_QUIT_TITLE) \
ENTRY(TXT_MSG_QUIT_MESSAGE) \
/* Second text resources test. */ \
/* DO NOT REMOVE THE FOLLOWING TEXT ID !!! */ \
ENTRY(TXT_TEXT_RES_TEST_2) \
/* delete dialog message box */ \
ENTRY(TXT_MSG_DELETE_DLG_TITLE) \
ENTRY(TXT_MSG_DELETE_DLG_MESSAGE) \
/* delete resource message box */ \
ENTRY(TXT_MSG_REMOVE_IMAGE_TITLE) \
ENTRY(TXT_MSG_REMOVE_IMAGE_MESSAGE) \
/* delete control message box */ \
ENTRY(TXT_MSG_DELETE_CTRL_TITLE) \
ENTRY(TXT_MSG_DELETE_CTRL_MESSAGE) \
/* limitations when switching to RLE */ \
ENTRY(TXT_MSG_WARNING_RLE_LIMITATIONS) \
/* new image id window */ \
ENTRY(TXT_NEW_IMGID_NEW) \
ENTRY(TXT_NEW_IMGID_FILENAME) \
ENTRY(TXT_NEW_IMGID_NEWIMGID) \
/* id already exists message box */ \
ENTRY(TXT_MSG_ALREADY_EXISTS) \
ENTRY(TXT_MSG_ALREADY_EXISTS_MESSAGE) \
/* not enough input message box */ \
ENTRY(TXT_MSG_CHECK_INPUT) \
ENTRY(TXT_MSG_CHECK_INPUT_MESSAGE) \
/* image is not supported */ \
ENTRY(TXT_MSG_IMAGE_NOT_SUPPORTED) \
ENTRY(TXT_MSG_IMAGE_NOT_SUPPORTED_MESSAGE) \
/* reset export-formats? */ \
ENTRY(TXT_MSG_RESET_EXPORT_FORMAT) \
ENTRY(TXT_MSG_RESET_EXPORT_FORMAT_MESSAGE) \
/* reset export-formats? */ \
ENTRY(TXT_MSG_RESET_HEADLINE) \
ENTRY(TXT_MSG_RESET_COUNT) \
/* clear recent projects list */ \
ENTRY(TXT_MSG_CLEAR_RECENT_PROJECTS) \
ENTRY(TXT_MSG_CLEAR_RECENT_PROJECTS_MESSAGE) \
/* reset settings to default */ \
ENTRY(TXT_MSG_RESET_SETTINGS) \
ENTRY(TXT_MSG_RESET_SETTINGS_MESSAGE) \
/* rename object-id window */ \
ENTRY(TXT_RENAME_OBJID_RENAME) \
ENTRY(TXT_RENAME_OBJID_OLDOBJID) \
ENTRY(TXT_RENAME_OBJID_NEWOBJID) \
/* change image id window */ \
ENTRY(TXT_CHANGE_IMGID_CHANGE) \
ENTRY(TXT_CHANGE_IMGID_FILENAME) \
ENTRY(TXT_CHANGE_IMGID_CHANGEOLDIMGID) \
/* change property id window */ \
ENTRY(TXT_CHANGE_PROPID_CHANGE) \
ENTRY(TXT_CHANGE_PROPID_VALUE) \
ENTRY(TXT_CHANGE_PROPID_TYPE) \
ENTRY(TXT_CHANGE_PROPID_OLDPROPID) \
ENTRY(TXT_CHANGE_PROPID_NEWPROPID) \
/* custom extension dialog */ \
ENTRY(TXT_WINDOW_CUSTOM_EXTENSION_MANAGER) \
ENTRY(TXT_CUSTOM_EXTENSION_ADD_CMD) \
ENTRY(TXT_CUSTOM_EXTENSION_CMD_CLASS_NAME) \
ENTRY(TXT_CUSTOM_EXTENSION_CMD_ID) \
ENTRY(TXT_CUSTOM_EXTENSION_ADD_LAYOUTER) \
ENTRY(TXT_CUSTOM_EXTENSION_LAYOUTER_CLASS_NAME) \
ENTRY(TXT_CUSTOM_EXTENSION_LAYOUTER_ID) \
ENTRY(TXT_CUSTOM_EXTENSION_ADD_BEHAVIOUR) \
ENTRY(TXT_CUSTOM_EXTENSION_BEHAVIOUR_CLASS_NAME) \
ENTRY(TXT_CUSTOM_EXTENSION_BEHAVIOUR_ID) \
ENTRY(TXT_CUSTOM_EXTENSION_ADD_CONTROL) \
ENTRY(TXT_CUSTOM_EXTENSION_CONTROL_CLASS_NAME) \
ENTRY(TXT_CUSTOM_EXTENSION_CONTROL_ID) \
ENTRY(TXT_CUSTOM_EXTENSION_ADD_TEXTTYPE) \
ENTRY(TXT_CUSTOM_EXTENSION_TEXTTYPE_CLASS_NAME) \
ENTRY(TXT_CUSTOM_EXTENSION_TEXTTYPE_ID) \
ENTRY(TXT_CUSTOM_EXTENSION_SOURCE_FOLDER) \
ENTRY(TXT_MSG_CUSTOM_EXTENSION_INVALID_C_ID) \
ENTRY(TXT_MSG_CUSTOM_EXTENSION_ALREADY_EXISTING_FAIL) \
ENTRY(TXT_MSG_CUSTOM_EXTENSION_EVAL_EXCEEDED) \
ENTRY(TXT_MSG_CUSTOM_EXTENSION_CREATION_OK) \
ENTRY(TXT_MSG_CUSTOM_EXTENSION_CREATION_FAIL) \
/* Switch controls pack */ \
/* 1) in Manage Images window */ \
ENTRY(TXT_SWITCH_CONTROLS_TEXT) \
/* 2) Error message in MyGUI::TryToRegisterStandardImage */ \
ENTRY(TXT_SWITCH_CONTROLS_PACK_LOADING_ERROR_HEADER) \
ENTRY(TXT_SWITCH_CONTROLS_PACK_LOADING_ERROR_TEXT1) \
ENTRY(TXT_SWITCH_CONTROLS_PACK_LOADING_ERROR_TEXT2) \
/* All resources windows */ \
ENTRY(TXT_RESOURCES_PERMANENT) \
ENTRY(TXT_RESOURCES_PERMANENT_TOOLTIP) \
ENTRY(TXT_RESOURCES_EXPORT_FORMAT) \
ENTRY(TXT_RESOURCES_EXPORT_FORMAT_TOOLTIP) \
/* workspace text */ \
ENTRY(TXT_WINDOW_WORKSPACE) \
/* simulation dialog */ \
ENTRY(TXT_WINDOW_RUN_SIMULATION_RUN) \
ENTRY(TXT_WINDOW_RUN_SIMULATION_SETTINGS) \
/* new project message */ \
ENTRY(TXT_MSG_NEW_PROJECT_TITLE) \
ENTRY(TXT_MSG_NEW_PROJECT) \
/* open project message */ \
ENTRY(TXT_MSG_OPEN_PROJECT_TITLE) \
ENTRY(TXT_MSG_OPEN_PROJECT) \
/* quit project message */ \
ENTRY(TXT_MSG_QUIT_PROJECT_TITLE) \
ENTRY(TXT_MSG_QUIT_PROJECT) \
/* change font id window */ \
ENTRY(TXT_CHANGE_FNTID_CHANGE) \
ENTRY(TXT_CHANGE_FNTID_FILENAME) \
ENTRY(TXT_CHANGE_FNTID_CHANGEFNTID) \
ENTRY(TXT_CHANGE_FNTID_SIZE) \
/* delete font message box */ \
ENTRY(TXT_MSG_REMOVE_FONT_TITLE) \
ENTRY(TXT_MSG_REMOVE_FONT_MESSAGE) \
/* change guiliani resource message box */ \
ENTRY(TXT_MSG_CHANGE_GUILIANI_RESOURCE_TITLE) \
ENTRY(TXT_MSG_CHANGE_GUILIANI_RESOURCE_MESSAGE) \
/* delete guiliani resource message box */ \
ENTRY(TXT_MSG_REMOVE_GUILIANI_RESOURCE_TITLE) \
ENTRY(TXT_MSG_REMOVE_GUILIANI_RESOURCE_MESSAGE) \
/* set already exists */ \
ENTRY(TXT_MSG_SET_ALREADY_EXISTS_MESSAGE) \
/* new set error */ \
ENTRY(TXT_MSG_SET_NEW_SET_ERROR_MESSAGE) \
ENTRY(TXT_MSG_SET_REMOVE_SET_ERROR_MESSAGE) \
ENTRY(TXT_MSG_SET_NEW_SET_ERROR_FILE_LOAD_TITLE) \
ENTRY(TXT_MSG_SET_NEW_SET_ERROR_FILE_LOAD_MESSAGE1) \
ENTRY(TXT_MSG_SET_NEW_SET_ERROR_FILE_LOAD_MESSAGE2) \
/* sound ID window */ \
ENTRY(TXT_SNDID_APPLY) \
ENTRY(TXT_SNDID_CHANGE) \
ENTRY(TXT_SNDID_INSERT) \
ENTRY(TXT_SNDID_ACTIONS) \
ENTRY(TXT_SNDID_REMOVE) \
ENTRY(TXT_SNDID_NEW) \
ENTRY(TXT_SNDID_FILTER) \
/* general resource ID window */ \
ENTRY(TXT_RESID_CHANGE) \
ENTRY(TXT_RESID_ACTIONS) \
ENTRY(TXT_RESID_REMOVE) \
ENTRY(TXT_RESID_NEW) \
ENTRY(TXT_RESID_FILTER) \
/* new sound id window */ \
ENTRY(TXT_NEW_SNDID_NEW) \
ENTRY(TXT_NEW_SNDID_FILENAME) \
ENTRY(TXT_NEW_SNDID_NEWSNDID) \
ENTRY(TXT_NEW_SNDID_PLAY) \
/* new general resource id window */ \
ENTRY(TXT_NEW_RESID_NEW) \
ENTRY(TXT_NEW_RESID_FILENAME) \
ENTRY(TXT_NEW_RESID_NEWRESID) \
/* new sound set window */ \
/* remove text message box */ \
ENTRY(TXT_MSG_REMOVE_TEXT_TITLE) \
ENTRY(TXT_MSG_REMOVE_TEXT_MESSAGE) \
/* remove sound message box */ \
ENTRY(TXT_MSG_REMOVE_SOUND_TITLE) \
ENTRY(TXT_MSG_REMOVE_SOUND_MESSAGE) \
/* remove general resource message box */ \
ENTRY(TXT_MSG_REMOVE_GENRES_TITLE) \
ENTRY(TXT_MSG_REMOVE_GENRES_MESSAGE) \
/* remove text message box */ \
ENTRY(TXT_MSG_REMOVE_PROPERTY_TITLE) \
ENTRY(TXT_MSG_REMOVE_PROPERTY_MESSAGE) \
/* change sound id window */ \
ENTRY(TXT_CHANGE_SNDID_CHANGE) \
ENTRY(TXT_CHANGE_SNDID_FILENAME) \
ENTRY(TXT_CHANGE_SNDID_CHANGESNDID) \
/* change general resource id window */ \
ENTRY(TXT_CHANGE_RESID_CHANGE) \
ENTRY(TXT_CHANGE_RESID_FILENAME) \
ENTRY(TXT_CHANGE_RESID_CHANGERESID) \
/* file already exists message box */ \
ENTRY(TXT_MSG_FILE_EXISTS_TITLE) \
ENTRY(TXT_MSG_FILE_EXISTS_MESSAGE) \
ENTRY(TXT_MSG_NO_NEW_ID_FOR_IMPORTED_RESOURCE) \
/* invalid directory message box */ \
ENTRY(TXT_MSG_INVALID_EXPORT_DIRECTORY) \
/* invalid directory for simulator */ \
ENTRY(TXT_MSG_INVALID_SIMULATOR_DIRECTORY) \
/* export error message box */ \
ENTRY(TXT_MSG_EXPORT_ERROR) \
/* import message box */ \
ENTRY(TXT_MSG_IMPORT_FORCE_WITH_FAILED_RESOURCE) \
ENTRY(TXT_MSG_IMPORT_SUCCESSFUL) \
ENTRY(TXT_MSG_IMPORT_SUCCESSFUL_WITH_WARNINGS) \
ENTRY(TXT_MSG_IMPORT_ERROR) \
ENTRY(TXT_MSG_IMPORT_ERR_HANDLE_EXISTS) \
ENTRY(TXT_MSG_IMPORT_NO_DIALOG) \
ENTRY(TXT_MSG_IMPORT_DIALOG_FOLDERS_DIFFER) \
/* key modifiers text */ \
ENTRY(TXT_GKM_SHIFT) \
ENTRY(TXT_GKM_CONTROL) \
ENTRY(TXT_GKM_ALT) \
ENTRY(TXT_GKM_META) \
/* invalid C identifier message box */ \
ENTRY(TXT_MSG_INVALID_C_IDENTIFIER) \
/* custom standard factory has been created */ \
ENTRY(TXT_MSG_CUSTOMSTANDARDFACTORY_CREATED) \
/* error message box when any custom extension generation fails */ \
ENTRY(TXT_MSG_CUSTOM_EXTENSION_ERROR) \
/* confirm deletion of repetition entry message box */ \
ENTRY(TXT_MSG_DELETE_REPETITION_ENTRY) \
/* export statistics */ \
ENTRY(TXT_EXPORT_STATISTICS_TITLE) \
ENTRY(TXT_EXPORT_STATISTICS_NUMBER_SETS) \
ENTRY(TXT_EXPORT_STATISTICS_NUMBER_RESOURCES) \
ENTRY(TXT_EXPORT_STATISTICS_SIZE_INPUT) \
ENTRY(TXT_EXPORT_STATISTICS_SIZE_OUTPUT) \
ENTRY(TXT_EXPORT_STATISTICS_PERCENTAGE) \
/* message boxes */ \
ENTRY(TXT_MSG_ERROR) \
ENTRY(TXT_MSG_WARNING) \
ENTRY(TXT_MSG_INVALID_OR_EMPTY_PATH) \
ENTRY(TXT_MSG_INVALID_DIALOG_NAME) \
ENTRY(TXT_MSG_INVALID_SIZE) \
ENTRY(TXT_MSG_COULD_NOT_OPEN) \
ENTRY(TXT_MSG_INVALID_PROJECT_NAME) \
ENTRY(TXT_MSG_PROJECT_EXISTS) \
ENTRY(TXT_MSG_SAME_PROJECT) \
ENTRY(TXT_MSG_DIALOG_ALREADY_EXISTS_PART1) \
ENTRY(TXT_MSG_DIALOG_ALREADY_EXISTS_PART2) \
ENTRY(TXT_MSG_WORKSPACE_NOT_EMPTY) \
ENTRY(TXT_MSG_WORKSPACE_DIR_NOT_FOUND_P1) \
ENTRY(TXT_MSG_WORKSPACE_DIR_NOT_FOUND_P2) \
ENTRY(TXT_MSG_PATH_OR_NAME_EMPTY) \
ENTRY(TXT_MSG_INVALID_CHILD_FOR_SELECTED_PARENT) \
ENTRY(TXT_MSG_ERROR_WHILE_LOADING_CONTROL) \
ENTRY(TXT_MSG_NO_ACTIVE_DIALOG) \
ENTRY(TXT_MSG_SETOBJECT_ID) \
ENTRY(TXT_MSG_TEXT_SETOBJECT_ID) \
ENTRY(TXT_MSG_CONTROLS_PACK_MISSING_HEADER) \
ENTRY(TXT_MSG_CONTROLS_PACK_MISSING_P1) \
ENTRY(TXT_MSG_CONTROLS_PACK_MISSING_P2) \
ENTRY(TXT_MSG_FOLDER_WRITE_PROTECTED_ERROR) \
/* evaluation version notifications */ \
ENTRY(TXT_MSG_EVALUATION_VERSION_TITLE) \
ENTRY(TXT_MSG_EVALUATION_VERSION) \
ENTRY(TXT_MSG_EVALUATION_TIMEBOMB) \
/* loaded dialog contains skipped elements */ \
ENTRY(TXT_MSG_DIALOG_CONTAINS_SKIPPED_ELEMENTS_TITLE) \
ENTRY(TXT_MSG_DIALOG_CONTAINS_SKIPPED_ELEMENTS_MSG) \
/* loaded dialog is corrupted */ \
ENTRY(TXT_MSG_DIALOG_IS_CORRUPTED_TITLE) \
ENTRY(TXT_MSG_DIALOG_IS_CORRUPTED_PROCEED_MSG) \
ENTRY(TXT_MSG_DIALOG_IS_CORRUPTED_MSG) \
/* remove language warning msg-box */ \
ENTRY(TXT_MSG_REMOVE_LANG_TITLE) \
ENTRY(TXT_MSG_REMOVE_LANG_MSG) \
/* re-use or overwrite font file msg box */ \
ENTRY(TXT_MSG_OVERWRITE_OR_REUSE_FONT) \
/* overwrite resource file msg box */ \
ENTRY(TXT_MSG_OVERWRITE_RESOURCE_FILE) \
ENTRY(TXT_USE_EXISTING) \
ENTRY(TXT_OVERWRITE) \
/* workspace loading error msg box */ \
ENTRY(TXT_MSG_WORKSPACE_LOADING_ERROR) \
ENTRY(TXT_MSG_WORKSPACE_SAVING_ERROR) \
/* File type descriptions */ \
/* ConfirmSaveProjectCmd.cpp */ \
ENTRY(TXT_FILE_TYPE_GSE_PROJECTS) \
ENTRY(TXT_FILE_TYPE_TOUCHGFX_PROJECTS) \
/* ShowChooseDirDlgCmd.cpp */ \
ENTRY(TXT_FILE_TYPE_DIRECTORIES) \
/* GUIFileDialog.cpp */ \
ENTRY(TXT_FILE_TYPE_ALL_FILES) \
/* MyGUI_ChangeFontIDWindow.cpp */ \
/* MyGUI_NewFontIDWindow.cpp */ \
ENTRY(TXT_FILE_TYPE_TRUETYPE_FONTS) \
ENTRY(TXT_FILE_TYPE_OPENTYPE_FONTS) \
/* MyGUI_ChangeImageIDWindow.cpp */ \
/* MyGUI_NewImageIDWindow.cpp */ \
ENTRY(TXT_FILE_TYPE_IMAGES) \
/* MyGUI_ChangeSoundIDWindow.cpp */ \
/* MyGUI_NewSoundIDWindow.cpp */ \
ENTRY(TXT_FILE_TYPE_SOUND_FILES) \
/* MyGUI_NewGeneralResourceIDWindow.cpp */ \
ENTRY(TXT_FILE_TYPE_RES_FILES) \
/* MyGUI_ImportPrepareResources.cpp */ \
ENTRY(TXT_FILE_TYPE_IMAGE_CONFIG) \
ENTRY(TXT_FILE_TYPE_FONT_CONFIG) \
ENTRY(TXT_FILE_TYPE_SOUND_CONFIG) \
ENTRY(TXT_FILE_TYPE_GENRES_CONFIG) \
ENTRY(TXT_FILE_TYPE_LANGUAGE_FILE) \
/* import */ \
ENTRY(TXT_FILE_TYPE_GUILIANI_DIALOG) \
ENTRY(TXT_FILE_TYPE_PSDFILE) \
/* FileDialog */ \
ENTRY(TXT_FILE_DIALOG_TITLE_OPEN) \
ENTRY(TXT_FILE_DIALOG_ACTION_TEXT_OPEN) \
ENTRY(TXT_FILE_DIALOG_ACTION_BUTTON_OPEN) \
ENTRY(TXT_FILE_DIALOG_TITLE_SAVE) \
ENTRY(TXT_FILE_DIALOG_ACTION_TEXT_SAVE) \
ENTRY(TXT_FILE_DIALOG_ACTION_BUTTON_SAVE) \
ENTRY(TXT_FILE_DIALOG_TITLE_CHOOSE) \
ENTRY(TXT_FILE_DIALOG_ACTION_TEXT_CHOOSE) \
ENTRY(TXT_FILE_DIALOG_ACTION_BUTTON_CHOOSE) \
ENTRY(TXT_FILE_DIALOG_HOME_PATH) \
ENTRY(TXT_FILE_DIALOG_ROOT_PATH) \
ENTRY(TXT_FILE_DIALOG_CURRENT_DIRECTORY) \
ENTRY(TXT_FILE_DIALOG_FILE_NAME) \
ENTRY(TXT_FILE_DIALOG_FILES_OF_TYPE) \
ENTRY(TXT_FILE_DIALOG_CANCEL_BUTTON) \
/* Last text resources test. */ \
/* DO NOT REMOVE THE FOLLOWING TEXT ID !!! */ \
ENTRY(TXT_TEXT_RES_TEST_3) \
/* Console Window */ \
ENTRY(TXT_CONSOLE_WINDOWTITLE) \
ENTRY(TXT_BTN_CONSOLE_CLEAR) \
/* Header for "CustomStandardFactory Generator" message box */ \
ENTRY(TXT_CUSTOMSTANDARDFACTORY) \
/* DataPool Management window */ \
ENTRY(TXT_MANAGE_DATAPOOL) \
ENTRY(TXT_ADD_DATAPOOL_ENTRY) \
ENTRY(TXT_REMOVE_DATAPOOL_ENTRY) \
ENTRY(TXT_ADD_DATAPOOL_OBSERVER) \
ENTRY(TXT_REMOVE_DATAPOOL_OBSERVER) \
ENTRY(TXT_NO_DATAPOOL_ENTRY_SELECTED) \
ENTRY(TXT_RENAME_ID) \
/* Dialog list tool tip thumb text switch */ \
ENTRY(TXT_DLG_LIST_THUMBS_TEXT_SWITCH) \
ENTRY(TXT_DLG_LIST_SET_START_DIALOG) \
/* Progress window cancel messages */ \
ENTRY(TXT_EXPORT_CANCEL) \
/* Message-text if project was converted from older version */ \
ENTRY(TXT_MSG_PROJECT_WAS_CONVERTED) \
ENTRY(TXT_DATAPOOL_ENTRY_NAME) \
ENTRY(TXT_DATAPOOL_ENTRY_DESCRIPTION) \
ENTRY(TXT_DATAPOOL_ENTRY_SIZE) \
ENTRY(TXT_DATAPOOL_ENTRY_ROWS) \
ENTRY(TXT_DATAPOOL_ENTRY_COLUMNS) \
ENTRY(TXT_MSG_REDUCE_DATAPOOL_SIZE_TITLE) \
ENTRY(TXT_MSG_REDUCE_DATAPOOL_SIZE_MESSAGE) \
/* Progressbar */ \
ENTRY(TXT_PROGRESSBAR_TITLE_LOADING_WORKSPACE) \
ENTRY(TXT_PROGRESSBAR_TEXT_LOADING_WORKSPACE) \
ENTRY(TXT_PROGRESSBAR_TEXT_CLEAR_WORKSPACE) \
ENTRY(TXT_PROGRESSBAR_TEXT_OPEN_PROJECT) \
ENTRY(TXT_PROGRESSBAR_TEXT_LOAD_RESOURCE_IDS) \
ENTRY(TXT_PROGRESSBAR_TEXT_LOAD_OBJECT_IDS) \
ENTRY(TXT_PROGRESSBAR_TEXT_LOAD_IMAGE_IDS) \
ENTRY(TXT_PROGRESSBAR_TEXT_LOAD_FONT_IDS) \
ENTRY(TXT_PROGRESSBAR_TEXT_LOAD_SOUND_IDS) \
ENTRY(TXT_PROGRESSBAR_TEXT_LOAD_TEXT_IDS) \
ENTRY(TXT_PROGRESSBAR_TEXT_LOAD_ANIMATION_IDS) \
ENTRY(TXT_PROGRESSBAR_TEXT_LOAD_GENERAL_IDS) \
ENTRY(TXT_PROGRESSBAR_TEXT_LOAD_PROPERTY_IDS) \
ENTRY(TXT_PROGRESSBAR_TEXT_LOAD_DATAPOOL_IDS) \
ENTRY(TXT_PROGRESSBAR_TEXT_LOAD_SETTINGS) \
ENTRY(TXT_PROGRESSBAR_TEXT_LOAD_DIALOG) \
ENTRY(TXT_PROGRESSBAR_TEXT_ACTIVATE_WORKSPACE) \
ENTRY(TXT_PROGRESSBAR_TITLE_REFERENCE_COUNT) \
ENTRY(TXT_PROGRESSBAR_TEXT_PROCESS_WORKSPACE) \
ENTRY(TXT_PROGRESSBAR_TITLE_TRUNCATED_TEXT) \
ENTRY(TXT_PROGRESSBAR_TEXT_SEARCH_TRUNCATION_DIALOG) \
ENTRY(TXT_PROGRESSBAR_TEXT_READ_RESOURCESET) \
ENTRY(TXT_PROGRESSBAR_TEXT_LOAD_IMAGES) \
ENTRY(TXT_PROGRESSBAR_TEXT_LOAD_LANGUAGES) \
ENTRY(TXT_PROGRESSBAR_TEXT_LOAD_FONTS) \
ENTRY(TXT_PROGRESSBAR_TEXT_LOAD_SOUNDS) \
ENTRY(TXT_PROGRESSBAR_TEXT_LOAD_GENRES) \
ENTRY(TXT_PROGRESSBAR_TEXT_LOAD_PROPERTIES) \
ENTRY(TXT_PROGRESSBAR_TEXT_PROCESS_DIALOG) \
ENTRY(TXT_PROGRESSBAR_TITLE_SEARCHING_ID) \
ENTRY(TXT_TYPE_OBJECT_ID) \
ENTRY(TXT_TYPE_IMAGE_ID) \
ENTRY(TXT_TYPE_TEXT_ID) \
ENTRY(TXT_TYPE_FONT_ID) \
ENTRY(TXT_TYPE_SOUND_ID) \
ENTRY(TXT_TYPE_GENRES_ID) \
ENTRY(TXT_TYPE_DATAPOOL_ID) \
ENTRY(TXT_TYPE_PROPERTY_ID) \
ENTRY(TXT_TYPE_CONTROL_ID) \
ENTRY(TXT_TYPE_COMMAND_ID) \
ENTRY(TXT_TYPE_BEHAVIOUR_ID) \
ENTRY(TXT_TYPE_LAYOUTER_ID) \
ENTRY(TXT_TYPE_ATTRIBUTE_NAME) \
ENTRY(TXT_TYPE_STRING) \
ENTRY(TXT_TYPE_INTEGER) \
ENTRY(TXT_TYPE_FLOAT) \
ENTRY(TXT_TYPE_BOOL) \
ENTRY(TXT_MSGBOX_TITLE_VERSION_LIMIT) \
ENTRY(TXT_MSGBOX_TEXT_MAX_NUMBER_DIALOGS) \
ENTRY(TXT_NEW_FOLDER) \
ENTRY(TXT_NEW_FOLDER_NAME) \
ENTRY(TXT_COLOR_SELECTION_WINDOW_TITLE) \
ENTRY(TXT_COLOR_SELECTION_CURRENT_COLOR) \
ENTRY(TXT_COLOR_SELECTION_ADD_TO_FAVORITES) \
ENTRY(TXT_COLOR_SELECTION_FAVORITES) \
ENTRY(TXT_COLOR_SELECTION_SWATCHES) \
ENTRY(TXT_COLOR_SELECTION_COMP_ALPHA) \
ENTRY(TXT_COLOR_SELECTION_COMP_RED) \
ENTRY(TXT_COLOR_SELECTION_COMP_GREEN) \
ENTRY(TXT_COLOR_SELECTION_COMP_BLUE) \
ENTRY(TXT_COLOR_SELECTION_COMP_HEX) \
ENTRY(TXT_FILEDLG_TITLE_OVERWRITE_FILE) \
ENTRY(TXT_FILEDLG_TITLE_DELETE_FILES) \
ENTRY(TXT_FILEDLG_MSG_DIR_DELETE_ERROR) \
ENTRY(TXT_FILEDLG_MSG_FILE_DELETE_ERROR) \
ENTRY(TXT_FILEDLG_MSG_DIR_CREATE_ERROR) \
ENTRY(TXT_FILEDLG_MSG_DIR_EXISTS) \
ENTRY(TXT_FILEDLG_MSG_DELETE_FILES_QUESTION) \
ENTRY(TXT_FILEDLG_MSG_FILE_NOTREADABLE_ERROR) \
ENTRY(TXT_FILEDLG_MSG_OVERWRITE_FILE_QUESTION) \
ENTRY(TXT_FILEDLG_MSG_PERMISSION_DENIED_ERROR) \
ENTRY(TXT_FILEDLG_MSG_DIR_NOT_EXISTS) \
ENTRY(TXT_FILEDLG_MSG_CHANGE_PARENT_ERROR) \
ENTRY(TXT_FILEDLG_MSG_SWITCH_DIR_ERROR) \
ENTRY(TXT_TEXT_RES_TEST_4) \
ENTRY(TXT_MSG_DELETE_ANIM_TITLE) \
ENTRY(TXT_MSG_DELETE_ANIM_MESSAGE) \
ENTRY(TXT_MSG_DELETE_ANIM_CHAIN_TITLE) \
ENTRY(TXT_MSG_DELETE_ANIM_CHAIN_MESSAGE) \
ENTRY(TXT_MSG_SELECTED_OBJECT_HAS_LAYOUTER) \
ENTRY(TXT_MSG_INVALID_CLIPBOARD_CONTENT) \
ENTRY(TXT_MANAGEID_SHOW_STANDARD_RES) \
/* Insert all GSE text IDs _in front of_ ENTRY(TXT_USER_START_TAG. */ \
ENTRY(TXT_USER_START_TAG)
