/**
User-defined object handles.
Each of these IDs maps to a object-pointer within the GUI.
Each entry has to look like:
ENTRY(OBJ_USEROBJECT01)    \
*/

#define USER_OBJECTID_TABLE            \
ENTRY(OBJ_GUI) \
ENTRY(OBJ_WINDOW_CONTROLS) \
ENTRY(OBJ_ATTRIBUTELIST) \
ENTRY(OBJ_ATTRIBUTELIST_CHECKBOX) \
ENTRY(OBJ_ATTRIBUTELIST_BUTTON) \
ENTRY(OBJ_ATTRIBUTELIST_INPUTFIELD) \
/* Combo box in attribute list for various selections. */ \
ENTRY(OBJ_ATTRIBUTELIST_COMBOBOX) \
ENTRY(OBJ_HIERARCHY_VIEW) \
ENTRY(OBJ_HIERARCHY_VIEW_COL_VISIBILITY) \
ENTRY(OBJ_HIERARCHY_VIEW_COL_COMMAND) \
ENTRY(OBJ_HIERARCHY_VIEW_COL_BEHAVIOUR) \
ENTRY(OBJ_HIERARCHY_VIEW_COL_LAYOUTER) \
ENTRY(OBJ_DIALOG_PARENT) \
ENTRY(OBJ_DIALOG_PARENT_SCROLLVIEW) \
ENTRY(OBJ_DIALOG_HIGHLIGHT_CONTAINER) \
ENTRY(OBJ_SELECTION_PANE) \
ENTRY(OBJ_BTN_QUIT) \
/* buttons for changing the object order */ \
ENTRY(OBJ_BTN_ORDER_RAISE) \
ENTRY(OBJ_BTN_ORDER_LOWER) \
ENTRY(OBJ_BTN_ORDER_FRONT) \
ENTRY(OBJ_BTN_ORDER_BACK) \
/* menu entries */ \
ENTRY(OBJ_BTN_LAYOUT_ALIGN_LEFT) \
ENTRY(OBJ_BTN_LAYOUT_ALIGN_RIGHT) \
ENTRY(OBJ_BTN_LAYOUT_ALIGN_TOP) \
ENTRY(OBJ_BTN_LAYOUT_ALIGN_BOTTOM) \
ENTRY(OBJ_BTN_LAYOUT_ALIGN_VCENTER) \
ENTRY(OBJ_BTN_LAYOUT_ALIGN_HCENTER) \
ENTRY(OBJ_BTN_LAYOUT_DISTRIBUTE_VERTICALLY) \
ENTRY(OBJ_BTN_LAYOUT_DISTRIBUTE_HORIZONTALLY) \
ENTRY(OBJ_BTN_LAYOUT_ALIGN_SIZE) \
ENTRY(OBJ_BTN_LAYOUT_ALIGN_RESIZE_TO_IMAGE) \
ENTRY(OBJ_BTN_LAYOUT_GROUP_OBJECTS) \
ENTRY(OBJ_BTN_LAYOUT_UNGROUP_OBJECTS) \
ENTRY(OBJ_BTN_LAYOUT_FLIP_HORIZONTALLY) \
ENTRY(OBJ_BTN_LAYOUT_FLIP_VERTICALLY) \
ENTRY(OBJ_BTN_LAYOUT_ROTATE_CLOCKWISE) \
ENTRY(OBJ_BTN_LAYOUT_ROTATE_COUNTER_CLOCKWISE) \
/* Quickstart panel */ \
ENTRY(OBJ_BTN_TOOLBAR_NEW_PROJECT) \
ENTRY(OBJ_BTN_TOOLBAR_NEW_DIALOG) \
ENTRY(OBJ_BTN_TOOLBAR_OPEN_PROJECT) \
ENTRY(OBJ_BTN_TOOLBAR_SAVE_PROJECT) \
ENTRY(OBJ_BTN_TOOLBAR_UNDO) \
ENTRY(OBJ_BTN_TOOLBAR_REDO) \
ENTRY(OBJ_BTN_TOOLBAR_COPY) \
ENTRY(OBJ_BTN_TOOLBAR_PASTE) \
ENTRY(OBJ_BTN_TOOLBAR_CUT) \
ENTRY(OBJ_BTN_TOOLBAR_DELETE) \
ENTRY(OBJ_BTN_TOOLBAR_RAISE_OBJECT) \
ENTRY(OBJ_BTN_TOOLBAR_LOWER_OBJECT) \
ENTRY(OBJ_BTN_TOOLBAR_FOREGROUND) \
ENTRY(OBJ_BTN_TOOLBAR_BACKGROUND) \
ENTRY(OBJ_BTN_TOOLBAR_ALIGN_LEFT) \
ENTRY(OBJ_BTN_TOOLBAR_ALIGN_RIGHT) \
ENTRY(OBJ_BTN_TOOLBAR_ALIGN_TOP) \
ENTRY(OBJ_BTN_TOOLBAR_ALIGN_BOTTOM) \
ENTRY(OBJ_BTN_TOOLBAR_CENTER_HOR) \
ENTRY(OBJ_BTN_TOOLBAR_CENTER_VER) \
ENTRY(OBJ_BTN_TOOLBAR_DISTRIBUTE_HOR) \
ENTRY(OBJ_BTN_TOOLBAR_DISTRIBUTE_VER) \
ENTRY(OBJ_BTN_TOOLBAR_UNIFY_SIZE) \
ENTRY(OBJ_BTN_TOOLBAR_RESIZE_TO_IMAGE) \
ENTRY(OBJ_BTN_TOOLBAR_TOGGLE_GUIDELINES) \
ENTRY(OBJ_BTN_TOOLBAR_GROUP_OBJECTS) \
ENTRY(OBJ_BTN_TOOLBAR_UNGROUP_OBJECTS) \
ENTRY(OBJ_BTN_TOOLBAR_SNAP_GUIDELINES) \
ENTRY(OBJ_BTN_TOOLBAR_TOGGLE_GRID) \
ENTRY(OBJ_BTN_TOOLBAR_TOGGLE_COORDINATES) \
ENTRY(OBJ_BTN_TOOLBAR_SETTINGS) \
ENTRY(OBJ_BTN_TOOLBAR_RUN) \
/* Menus */ \
ENTRY(OBJ_MAINMENU) \
/* top bar entries */ \
ENTRY(OBJ_MENUBAR_FILE) \
ENTRY(OBJ_MENUBAR_EDIT) \
ENTRY(OBJ_MENUBAR_VIEW) \
ENTRY(OBJ_MENUBAR_LAYOUT) \
ENTRY(OBJ_MENUBAR_RESOURCES) \
ENTRY(OBJ_MENUBAR_CUSTOM_EXTENSIONS) \
ENTRY(OBJ_MENUBAR_WINDOW) \
ENTRY(OBJ_MENUBAR_HELP) \
/* File menu */ \
ENTRY(OBJ_MENU_FILE_NEW_PROJECT) \
ENTRY(OBJ_MENU_FILE_NEW_FORM) \
ENTRY(OBJ_MENU_FILE_OPEN_PROJECT) \
ENTRY(OBJ_MENU_FILE_RECENT_PROJECTS) \
ENTRY(OBJ_MENU_FILE_OPEN_FORM) \
ENTRY(OBJ_MENU_FILE_IMPORT_FILE) \
ENTRY(OBJ_MENU_FILE_SAVE_PROJECT) \
ENTRY(OBJ_MENU_FILE_SAVE_PROJECT_AS) \
ENTRY(OBJ_MENU_FILE_QUIT) \
ENTRY(OBJ_MENU_FILE_SETTINGS) \
ENTRY(OBJ_MENU_FILE_RUN_SIMULATION) \
ENTRY(OBJ_MENU_FILE_CLOSE_PROJECT) \
ENTRY(OBJ_MENU_FILE_CLOSE_FORM) \
ENTRY(OBJ_SUBMENU_RECENT_PROJECTS) \
/* Edit menu */ \
ENTRY(OBJ_MENU_EDIT_UNDO) \
ENTRY(OBJ_MENU_EDIT_REDO) \
ENTRY(OBJ_MENU_EDIT_COPY) \
ENTRY(OBJ_MENU_EDIT_CUT) \
ENTRY(OBJ_MENU_EDIT_PASTE) \
ENTRY(OBJ_MENU_EDIT_DELETE) \
ENTRY(OBJ_MENU_EDIT_SELECT_ALL) \
ENTRY(OBJ_MENU_EDIT_FIND) \
/* View menu */ \
ENTRY(OBJ_MENU_VIEW_ZOOM_IN) \
ENTRY(OBJ_MENU_VIEW_ZOOM_OUT) \
ENTRY(OBJ_MENU_VIEW_SHOW_HELP_LINES) \
ENTRY(OBJ_MENU_VIEW_HIDE_HELP_LINES) \
ENTRY(OBJ_MENU_VIEW_SHOW_RASTER) \
ENTRY(OBJ_MENU_VIEW_HIDE_RASTER) \
/* Layout menu */ \
ENTRY(OBJ_MENU_LAYOUT_ARRANGE_OBJECTS) \
ENTRY(OBJ_MENU_LAYOUT_ALIGN_OBJECTS) \
ENTRY(OBJ_MENU_LAYOUT_GROUP_OBJECTS) \
ENTRY(OBJ_MENU_LAYOUT_UNGROUP_OBJECTS) \
ENTRY(OBJ_MENU_LAYOUT_SCALE_OBJECTS_SAME_SIZE) \
/* Layout - arrange objects sub-menu */ \
ENTRY(OBJ_MENU_LAYOUT_ARRANGE_OBJECTS_RAISE_OBJECT) \
ENTRY(OBJ_MENU_LAYOUT_ARRANGE_OBJECTS_LOWER_OBJECT) \
ENTRY(OBJ_MENU_LAYOUT_ARRANGE_OBJECTS_OBJECT_FRONT) \
ENTRY(OBJ_MENU_LAYOUT_ARRANGE_OBJECTS_OBJECT_BACK) \
/* Layout - adjust objects sub-menu */ \
ENTRY(OBJ_MENU_LAYOUT_ALIGN_OBJECTS_LEFT) \
ENTRY(OBJ_MENU_LAYOUT_ALIGN_OBJECTS_RIGHT) \
ENTRY(OBJ_MENU_LAYOUT_ALIGN_OBJECTS_TOP) \
ENTRY(OBJ_MENU_LAYOUT_ALIGN_OBJECTS_BOTTOM) \
ENTRY(OBJ_MENU_LAYOUT_ALIGN_OBJECTS_VERTICALLY) \
ENTRY(OBJ_MENU_LAYOUT_ALIGN_OBJECTS_HORIZONTALLY) \
ENTRY(OBJ_MENU_LAYOUT_ALIGN_OBJECTS_CENTER) \
/* Resources menu */ \
ENTRY(OBJ_MENU_RESOURCES_IMAGES) \
ENTRY(OBJ_MENU_RESOURCES_TEXTS) \
ENTRY(OBJ_MENU_RESOURCES_FONTS) \
ENTRY(OBJ_MENU_RESOURCES_SOUNDS) \
ENTRY(OBJ_MENU_RESOURCES_GENERAL) \
ENTRY(OBJ_MENU_RESOURCES_PROPERTIES) \
ENTRY(OBJ_MENU_RESOURCES_DATAPOOL) \
ENTRY(OBJ_MENU_RESOURCES_REQUIREMENTS) \
ENTRY(OBJ_MENU_RESOURCES_IMPORT) \
ENTRY(OBJ_MENU_RESOURCES_EXPORT) \
ENTRY(OBJ_MENU_RESOURCES_FIND_UNUSED) \
/* Custom extensions menu */ \
ENTRY(OBJ_MENU_CUSTOM_EXTENSIONS_CREATE_CUSTOM_EXTENSION) \
ENTRY(OBJ_MENU_CUSTOM_EXTENSIONS_GENERATE_STANDARD_FACTORY) \
/* Window menu */ \
ENTRY(OBJ_MENU_WINDOW_SHOW_WIDGETS) \
ENTRY(OBJ_MENU_WINDOW_HIDE_WIDGETS) \
ENTRY(OBJ_MENU_WINDOW_SHOW_PROJECT) \
ENTRY(OBJ_MENU_WINDOW_HIDE_PROJECT) \
ENTRY(OBJ_MENU_WINDOW_SHOW_FORM) \
ENTRY(OBJ_MENU_WINDOW_HIDE_FORM) \
ENTRY(OBJ_MENU_WINDOW_SHOW_PROPERTIES) \
ENTRY(OBJ_MENU_WINDOW_HIDE_PROPERTIES) \
ENTRY(OBJ_MENU_WINDOW_SHOW_DESKTOP) \
ENTRY(OBJ_MENU_WINDOW_HIDE_DESKTOP) \
ENTRY(OBJ_MENU_WINDOW_SHOW_WELCOME_SCREEN) \
ENTRY(OBJ_MENU_WINDOW_HIDE_WELCOME_SCREEN) \
/* Help menu */ \
ENTRY(OBJ_MENU_HELP_ABOUT) \
/* new dialog window */ \
ENTRY(OBJ_WINDOW_NEW_DIALOG) \
ENTRY(OBJ_NEW_DIALOG_NAME) \
ENTRY(OBJ_NEW_DIALOG_USE_RECENT_FORMAT) \
ENTRY(OBJ_NEW_DIALOG_TEMPLATE) \
ENTRY(OBJ_NEW_DIALOG_WIDTH) \
ENTRY(OBJ_NEW_DIALOG_HEIGHT) \
ENTRY(OBJ_NEW_DIALOG_SAVE_AS_TEMPLATE) \
ENTRY(OBJ_NEW_DIALOG_REMOVE_TEMPLATE) \
ENTRY(OBJ_NEW_DIALOG_OK) \
ENTRY(OBJ_NEW_DIALOG_CANCEL) \
/* search dialog window */ \
ENTRY(OBJ_WINDOW_SEARCH_DIALOG) \
ENTRY(OBJ_SEARCH_FOR_COMBO) \
ENTRY(OBJ_SEARCH_ATTRIBUTE_VALUE_INPUT) \
ENTRY(OBJ_SEARCH_ATTRIBUTE_VALUE_COMBO) \
ENTRY(OBJ_SEARCH_MATCHNAME_CHECKBOX) \
ENTRY(OBJ_SEARCH_ATTRIBUTE_NAME_INPUT) \
ENTRY(OBJ_SEARCH_ATTRIBUTE_NAME_LBL) \
ENTRY(OBJ_SEARCH_IN_COMBO) \
ENTRY(OBJ_SEARCH_DIALOG_OK) \
ENTRY(OBJ_SEARCH_DIALOG_CANCEL) \
ENTRY(OBJ_SEARCH_RESULT_TABLE) \
ENTRY(OBJ_WINDOW_SEARCH_ERROR) \
/* search object ID window*/ \
ENTRY(OBJ_WINDOW_SEARCH_OBJECT_DIALOG) \
ENTRY(OBJ_INPUT_SEARCH_OBJECT_VALUE) \
ENTRY(OBJ_RADIO_SEARCH_OBJECT_SCOPE) \
ENTRY(OBJ_RADIO_SEARCH_OBJECT_SCOPE_GLOBAL) \
ENTRY(OBJ_RADIO_SEARCH_OBJECT_SCOPE_DIALOG) \
ENTRY(OBJ_RADIO_SEARCH_OBJECT_SCOPE_CHILDREN) \
ENTRY(OBJ_TABLE_SEARCH_OBJECT_RESULT_TABLE) \
ENTRY(OBJ_BTN_SEARCH_OBJECT_SEARCH) \
ENTRY(OBJ_BTN_SEARCH_OBJECT_OK) \
ENTRY(OBJ_BTN_SEARCH_OBJECT_CANCEL) \
/* find unused resources window */ \
ENTRY(OBJ_WINDOW_FIND_UNUSED_RESOURCES) \
ENTRY(OBJ_UNUSED_RESOURCES_TABLE) \
ENTRY(OBJ_UNUSED_RESOURCES_SEARCH) \
ENTRY(OBJ_UNUSED_RESOURCES_CLOSE) \
ENTRY(OBJ_UNUSED_RESOURCES_ERROR) \
/*Delete all unused resources button */ \
ENTRY(OBJ_BUTTON_DELETE_ALL_IDS) \
ENTRY(OBJ_BUTTON_DELETE_SELECTED_IDS) \
/* manage sets window */ \
ENTRY(OBJ_WINDOW_MANAGESETS) \
ENTRY(OBJ_MANAGESETS_SETNAMEIDCREATE) \
ENTRY(OBJ_MANAGESETS_SETNAMEIDRENAME) \
ENTRY(OBJ_MANAGESETS_SETNAMEINPUTID) \
ENTRY(OBJ_MANAGESETS_SETNAME) \
ENTRY(OBJ_MANAGESETS_CREATEVISIBLE) \
ENTRY(OBJ_MANAGESETS_RENAMEVISIBLE) \
ENTRY(OBJ_MANAGESETS_REMOVEVISIBLE) \
ENTRY(OBJ_MANAGESETS_CREATEID) \
ENTRY(OBJ_MANAGESETS_RENAMEID) \
ENTRY(OBJ_MANAGESETS_REMOVEID) \
ENTRY(OBJ_MANAGESETS_SETNAMECHOSENSETCREATE) \
ENTRY(OBJ_MANAGESETS_SETNAMECHOSENSETREMOVE) \
ENTRY(OBJ_MANAGESETS_SETNAMECHOSENSETRENAME) \
ENTRY(OBJ_MANAGESETS_COMBOID) \
ENTRY(OBJ_MANAGESETS_COPYSET) \
ENTRY(OBJ_MANAGESETS_CLOSE) \
/* manage export-config window */ \
ENTRY(OBJ_WINDOW_MANAGEEXPORTCONFIG) \
ENTRY(OBJ_MANAGEEXPORTCONFIG_CONFIGNAMEIDCREATE) \
ENTRY(OBJ_MANAGEEXPORTCONFIG_CONFIGNAMEIDRENAME) \
ENTRY(OBJ_MANAGEEXPORTCONFIG_CONFIGNAMEINPUTID) \
ENTRY(OBJ_MANAGEEXPORTCONFIG_CONFIGNAME) \
ENTRY(OBJ_MANAGEEXPORTCONFIG_CREATEVISIBLE) \
ENTRY(OBJ_MANAGEEXPORTCONFIG_RENAMEVISIBLE) \
ENTRY(OBJ_MANAGEEXPORTCONFIG_REMOVEVISIBLE) \
ENTRY(OBJ_MANAGEEXPORTCONFIG_CREATEID) \
ENTRY(OBJ_MANAGEEXPORTCONFIG_RENAMEID) \
ENTRY(OBJ_MANAGEEXPORTCONFIG_REMOVEID) \
ENTRY(OBJ_MANAGEEXPORTCONFIG_CONFIGNAMECHOSENSETCREATE) \
ENTRY(OBJ_MANAGEEXPORTCONFIG_CONFIGNAMECHOSENSETREMOVE) \
ENTRY(OBJ_MANAGEEXPORTCONFIG_CONFIGNAMECHOSENSETRENAME) \
ENTRY(OBJ_MANAGEEXPORTCONFIG_COMBOID) \
ENTRY(OBJ_MANAGEEXPORTCONFIG_COPYCONFIG) \
ENTRY(OBJ_MANAGEEXPORTCONFIG_CLOSE) \
/* import language window */ \
ENTRY(OBJ_WINDOW_IMPORTLANG) \
ENTRY(OBJ_IMP_LANG_RADIO1) \
ENTRY(OBJ_IMP_LANG_RADIO2) \
ENTRY(OBJ_IMP_LANG_COMBO) \
ENTRY(OBJ_ADD_LANG_LOAD_FILE) \
ENTRY(OBJ_ADD_LANG_CHOOSEDIR) \
ENTRY(OBJ_ADD_LANG_COPY) \
ENTRY(OBJ_ADD_LANG_OK) \
ENTRY(OBJ_ADD_LANG_CANCEL) \
/* export language window */ \
ENTRY(OBJ_WINDOW_EXPORTLANG) \
ENTRY(OBJ_EXP_LANG_RADIO1) \
ENTRY(OBJ_EXP_LANG_RADIO2) \
ENTRY(OBJ_EXP_LANG_LANGUAGE) \
ENTRY(OBJ_EXP_LANG_COMBO) \
ENTRY(OBJ_EXP_LANG_FILE_NAME) \
ENTRY(OBJ_EXP_LANG_CHOOSEDIR) \
ENTRY(OBJ_EXP_LANG_OK) \
ENTRY(OBJ_EXP_LANG_CANCEL) \
/* new font id window */ \
ENTRY(OBJ_WINDOW_NEWFNTID) \
ENTRY(OBJ_NEW_FNTID_NEWFNTID) \
ENTRY(OBJ_NEW_FNTID_NEWFNTID_FILE) \
ENTRY(OBJ_NEW_FNTID_CHOOSEDIR) \
ENTRY(OBJ_NEW_FNTID_SIZE) \
ENTRY(OBJ_NEW_FNTID_PERMANENT) \
ENTRY(OBJ_NEW_FNTID_EXPORT_FORMAT) \
ENTRY(OBJ_NEW_FNTID_OK) \
ENTRY(OBJ_NEW_FNTID_CANCEL) \
/* new sound id window */ \
ENTRY(OBJ_WINDOW_NEWSNDID) \
ENTRY(OBJ_NEW_SNDID_NEWSNDID) \
ENTRY(OBJ_NEW_SNDID_NEWSNDID_FILE) \
ENTRY(OBJ_NEW_SNDID_CHOOSEDIR) \
ENTRY(OBJ_NEW_SNDID_PERMANENT) \
ENTRY(OBJ_NEW_SNDID_OK) \
ENTRY(OBJ_NEW_SNDID_CANCEL) \
/* new general resource id window */ \
ENTRY(OBJ_WINDOW_NEWRESID) \
ENTRY(OBJ_NEW_RESID_NEWRESID) \
ENTRY(OBJ_NEW_RESID_NEWRESID_FILE) \
ENTRY(OBJ_NEW_RESID_CHOOSEDIR) \
ENTRY(OBJ_NEW_RESID_PERMANENT) \
ENTRY(OBJ_NEW_RESID_OK) \
ENTRY(OBJ_NEW_RESID_CANCEL) \
/* new property id window */ \
ENTRY(OBJ_WINDOW_NEWPROPID) \
ENTRY(OBJ_NEW_PROPID_NEWPROPID) \
ENTRY(OBJ_NEW_PROPID_NEWPROPID_VALUE) \
ENTRY(OBJ_NEW_PROPID_NEWPROPID_TYPE) \
ENTRY(OBJ_NEW_PROPID_OK) \
ENTRY(OBJ_NEW_PROPID_CANCEL) \
/* new image set window */ \
ENTRY(OBJ_WINDOW_NEWIMGSET) \
ENTRY(OBJ_NEW_IMGSET_NEWIMGSET) \
ENTRY(OBJ_NEW_IMGSET_COPY) \
ENTRY(OBJ_NEW_IMGSET_OK) \
ENTRY(OBJ_NEW_IMGSET_CANCEL) \
/* dialog window */ \
ENTRY(OBJ_WINDOW_WORKSPACE_TITLEBAR) \
ENTRY(OBJ_WINDOW_WORKSPACE_FOOTER) \
ENTRY(OBJ_WINDOW_WORKSPACE) \
ENTRY(OBJ_WINDOW_WORKSPACE_RULER_HOR) \
ENTRY(OBJ_WINDOW_WORKSPACE_RULER_VER) \
ENTRY(OBJ_WINDOW_WORKSPACE_BACKGROUND) \
ENTRY(OBJ_BTN_DLG_ORDER_RAISE) \
ENTRY(OBJ_BTN_DLG_ORDER_LOWER) \
ENTRY(OBJ_BTN_DLG_ORDER_FRONT) \
ENTRY(OBJ_BTN_DLG_ORDER_BACK) \
ENTRY(OBJ_BTN_DLG_ALIGN_LEFT) \
ENTRY(OBJ_BTN_DLG_ALIGN_RIGHT) \
ENTRY(OBJ_BTN_DLG_ALIGN_TOP) \
ENTRY(OBJ_BTN_DLG_ALIGN_BOTTOM) \
ENTRY(OBJ_BTN_DLG_ALIGN_VCENTER) \
ENTRY(OBJ_BTN_DLG_ALIGN_HCENTER) \
ENTRY(OBJ_BTN_DLG_ALIGN_CENTER) \
ENTRY(OBJ_BTN_DLG_DUPLICATE) \
ENTRY(OBJ_BTN_DLG_RESIZE_TO_IMAGE) \
ENTRY(OBJ_BTN_DLG_DISTRIBUTE_VERTICALLY) \
ENTRY(OBJ_BTN_DLG_DISTRIBUTE_HORIZONTALLY) \
ENTRY(OBJ_BTN_DLG_TOGGLE_GUIDELINES) \
ENTRY(OBJ_BTN_DLG_TOGGLE_GRIDLINES) \
ENTRY(OBJ_BTN_DLG_TOGGLE_SNAPTOGUIDES) \
ENTRY(OBJ_BTN_DLG_TOGGLE_COORDINATES) \
/* dialog list window */ \
ENTRY(OBJ_WINDOW_DIALOGLIST) \
ENTRY(OBJ_BTN_DIALOGLIST_NEW) \
ENTRY(OBJ_BTN_DIALOGLIST_REMOVE) \
ENTRY(OBJ_BTN_DIALOGLIST_STARTDIALOG) \
ENTRY(OBJ_BTN_DIALOGLIST_SWITCH_THUMBS_TEXT) \
/* settings window */ \
ENTRY(OBJ_WINDOW_SETTINGS) \
ENTRY(OBJ_BTN_GLOBAL_SETTINGS) \
ENTRY(OBJ_BTN_PROJECT_SETTINGS) \
ENTRY(OBJ_BTN_EXPORT_SETTINGS) \
ENTRY(OBJ_COMP_SETTINGS) \
ENTRY(OBJ_COMP_LAYER_GLOBALSETTINGS) \
ENTRY(OBJ_COMP_LAYER_PROJECTSETTINGS) \
ENTRY(OBJ_COMP_LAYER_EXPORTSETTINGS) \
ENTRY(OBJ_BTN_SETTINGS_OK) \
ENTRY(OBJ_BTN_SETTINGS_CANCEL) \
ENTRY(OBJ_SETTINGS_GLOBAL_PROJ_DIR_LABEL) \
ENTRY(OBJ_SETTINGS_GLOBAL_PROJ_PATH) \
ENTRY(OBJ_SETTINGS_GLOBAL_PROJ_CHOOSEDIR) \
ENTRY(OBJ_SETTINGS_GLOBAL_LANG_FILE_COMBOBOX) \
ENTRY(OBJ_SETTINGS_GLOBAL_IMAGESET_COMBOBOX) \
ENTRY(OBJ_SETTINGS_GLOBAL_AUTOOPEN_CONSOLE) \
ENTRY(OBJ_SETTINGS_GLOBAL_KEEP_TEMP_DIRECTORY) \
ENTRY(OBJ_SETTINGS_GLOBAL_SHOW_TOOLTIPS) \
ENTRY(OBJ_SETTINGS_GLOBAL_AUTOOPEN_LASTPROJECT) \
ENTRY(OBJ_SETTINGS_GLOBAL_SKIP_CORRUPTED_DATA) \
ENTRY(OBJ_SETTINGS_GLOBAL_COLOR_GUIDELINES) \
ENTRY(OBJ_SETTINGS_GLOBAL_COLOR_WORKSPACEBACKGROUND) \
ENTRY(OBJ_SETTINGS_GLOBAL_COLOR_DROPHIGHLIGHT) \
ENTRY(OBJ_SETTINGS_GLOBAL_CLEAR_RECENT_PROJECTS) \
ENTRY(OBJ_SETTINGS_GLOBAL_RESET_SETTINGS) \
ENTRY(OBJ_SETTINGS_GLOBAL_RECORDING_INTERVAL) \
ENTRY(OBJ_SETTINGS_PROJECT_IMP_DIR_LABEL) \
ENTRY(OBJ_SETTINGS_PROJECT_IMP_PATH) \
ENTRY(OBJ_SETTINGS_PROJECT_IMP_CHOOSEDIR) \
ENTRY(OBJ_SETTINGS_PROJECT_CUSTOMEXTENSION_DIR_LABEL) \
ENTRY(OBJ_SETTINGS_PROJECT_CUSTOMEXTENSION_PATH) \
ENTRY(OBJ_SETTINGS_PROJECT_CUSTOMEXTENSION_CHOOSEDIR) \
ENTRY(OBJ_SETTINGS_PROJECT_SIMULATOR_DIR_LABEL) \
ENTRY(OBJ_SETTINGS_PROJECT_SIMULATOR_PATH) \
ENTRY(OBJ_SETTINGS_PROJECT_SIMULATOR_CHOOSEDIR) \
ENTRY(OBJ_SETTINGS_PROJECT_DETECT_CORRUPTED_DIALOGS) \
ENTRY(OBJ_SETTINGS_PROJECT_COPY_IDENTICAL_FILES) \
ENTRY(OBJ_SETTINGS_PROJECT_LANG_CHECK) \
ENTRY(OBJ_SETTINGS_PROJECT_LANG_SEPARATOR) \
ENTRY(OBJ_SETTINGS_PROJECT_GRID_SIZE_X) \
ENTRY(OBJ_SETTINGS_PROJECT_GRID_SIZE_Y) \
ENTRY(OBJ_SETTINGS_PROJECT_IMAGES_EXPORTFORMAT_COMBOBOX) \
ENTRY(OBJ_SETTINGS_PROJECT_RESET_IMAGES_EXPORTFORMAT) \
ENTRY(OBJ_SETTINGS_PROJECT_FONTS_EXPORTFORMAT_COMBOBOX) \
ENTRY(OBJ_SETTINGS_PROJECT_FONTS_EXPORTCOUNT) \
ENTRY(OBJ_SETTINGS_PROJECT_RESET_FONTS_EXPORTFORMAT) \
ENTRY(OBJ_SETTINGS_PROJECT_ENDIANESS_COMBOBOX) \
ENTRY(OBJ_SETTINGS_PROJECT_ALIGNMENT_COMBOBOX) \
ENTRY(OBJ_SETTINGS_PROJECT_OBJECTID_GENERATION_COMBOBOX) \
ENTRY(OBJ_SETTINGS_PROJECT_OBJECTID_GENERATION_RULE) \
ENTRY(OBJ_SETTINGS_EXPORT_CONFIGURATIONS) \
/* requirements window */ \
ENTRY(OBJ_WINDOW_REQUIREMENTS) \
ENTRY(OBJ_REQS_REQVIEW) \
ENTRY(OBJ_REQS_BUTTON_NEW) \
ENTRY(OBJ_REQS_BUTTON_EDIT) \
ENTRY(OBJ_REQS_BUTTON_DELETE) \
ENTRY(OBJ_REQS_BUTTON_EXPORT) \
ENTRY(OBJ_REQS_BUTTON_CANCEL) \
/* edit requirements window */ \
ENTRY(OBJ_WINDOW_EDITREQS) \
ENTRY(OBJ_EDITREQS_REQ_NUMBER) \
ENTRY(OBJ_EDITREQS_REQ_ID_TEXT) \
ENTRY(OBJ_EDITREQS_REQ_ID) \
ENTRY(OBJ_EDITREQS_MULTILINE) \
ENTRY(OBJ_EDITREQS_DIALOG_ID) \
ENTRY(OBJ_EDITREQS_DIALOG_ID_COMBO) \
ENTRY(OBJ_EDITREQS_OBJECT_ID) \
ENTRY(OBJ_EDITREQS_AFFECTED_REQS_TEXT) \
ENTRY(OBJ_EDITREQS_AFFECTED_REQS_OWN) \
ENTRY(OBJ_EDITREQS_AFFECTED_REQS_ALL) \
ENTRY(OBJ_EDITREQS_ADD_BUTTON) \
ENTRY(OBJ_EDITREQS_REMOVE_BUTTON) \
ENTRY(OBJ_EDITREQS_BUTTON_OK) \
ENTRY(OBJ_EDITREQS_BUTTON_CANCEL) \
/* export window */ \
ENTRY(OBJ_WINDOW_EXPORT) \
ENTRY(OBJ_IPF_EXPORT_PATH) \
ENTRY(OBJ_IPF_EXPORT_WIDTH) \
ENTRY(OBJ_IPF_EXPORT_HEIGHT) \
ENTRY(OBJ_IPF_EXPORT_BGCOLOR) \
ENTRY(OBJ_IPF_EXPORT_RESOURCEDIR) \
ENTRY(OBJ_EXPORT_RES_DIR_TOOLTIP) \
ENTRY(OBJ_EXPORT_SIMU_HEAD_TEXT2) \
ENTRY(OBJ_EXPORT_SIMU_TEXT2) \
ENTRY(OBJ_COMBO_EXPORT_IMAGESET) \
ENTRY(OBJ_COMBO_EXPORT_FONTSET) \
ENTRY(OBJ_COMBO_EXPORT_SOUNDSET) \
ENTRY(OBJ_COMBO_EXPORT_GENRESSET) \
ENTRY(OBJ_COMBO_EXPORT_LANGUAGE) \
ENTRY(OBJ_COMBO_EXPORT_PROPERTYSET) \
ENTRY(OBJ_COMBO_EXPORT_STARTDIALOG) \
ENTRY(OBJ_BTN_EXPORT_OK) \
ENTRY(OBJ_BTN_EXPORT_CANCEL) \
ENTRY(OBJ_BTN_EXPORT_CHOOSEDIR) \
ENTRY(OBJ_CHB_EXPORT_BGCOLOR) \
ENTRY(OBJ_IPF_EXPORT_DIR_LABEL) \
ENTRY(OBJ_CHB_EXPORT_RESFILEHEAD) \
ENTRY(OBJ_CHB_EXPORT_RESFILE) \
ENTRY(OBJ_RADIO_SIMULATOR_APPLICATION) \
ENTRY(OBJ_RADIO_DEFAULT_SIMULATOR) \
ENTRY(OBJ_RADIO_CUSTOM_SIMULATOR) \
ENTRY(OBJ_RADIO_EXPORT_STREAMER) \
ENTRY(OBJ_RADIO_EXPORT_XML) \
ENTRY(OBJ_RADIO_EXPORT_BINARY) \
ENTRY(OBJ_BTN_EXPORT_MANAGE_CONFIG) \
ENTRY(OBJ_BTN_EXPORT_SELECT_IMAGESETS) \
ENTRY(OBJ_BTN_EXPORT_SELECT_FONTSETS) \
ENTRY(OBJ_BTN_EXPORT_SELECT_SOUNDSETS) \
ENTRY(OBJ_BTN_EXPORT_SELECT_GENRESSETS) \
ENTRY(OBJ_BTN_EXPORT_SELECT_LANGUAGES) \
ENTRY(OBJ_BTN_EXPORT_SELECT_PROPERTYSETS) \
ENTRY(OBJ_CHB_EXPORT_STRD_RESOURCES) \
ENTRY(OBJ_CHB_EXPORT_OVERWRITE_STREAMRUNTIME_HEADERS) \
ENTRY(OBJ_CHB_EXPORT_COPY_SIMULATOR) \
ENTRY(OBJ_CHB_EXPORT_SHOW_STATISTICS) \
ENTRY(OBJ_CHB_EXPORT_REPLACE_DUPLICATES) \
ENTRY(OBJ_EXPORT_SCRIPT_PRE_CHECKBOX) \
ENTRY(OBJ_EXPORT_SCRIPT_PRE_IPF) \
ENTRY(OBJ_EXPORT_SCRIPT_PRE_CHOOSEDIR) \
ENTRY(OBJ_EXPORT_SCRIPT_POST_CHECKBOX) \
ENTRY(OBJ_EXPORT_SCRIPT_POST_IPF) \
ENTRY(OBJ_EXPORT_SCRIPT_POST_CHOOSEDIR) \
ENTRY(OBJ_EXPORT_SCRIPT_FLASH_CHECKBOX) \
ENTRY(OBJ_EXPORT_SCRIPT_FLASH_IPF) \
ENTRY(OBJ_EXPORT_SCRIPT_FLASH_CHOOSEDIR) \
ENTRY(OBJ_WINDOW_EXPORT_TXT_ADVICE) \
ENTRY(OBJ_WINDOW_EXPORT_SCROLLVIEW_ADVICE) \
/* export set selection window */ \
ENTRY(OBJ_WINDOW_EXPORT_SELECT_SETS) \
ENTRY(OBJ_BTN_EXPORT_SET_SELECTION_OK) \
ENTRY(OBJ_BTN_EXPORT_SET_SELECTION_CANCEL) \
ENTRY(OBJ_TABLEVIEW_EXPORT_SETS) \
/* import window */ \
ENTRY(OBJ_WINDOW_IMPORT) \
ENTRY(OBJ_IPF_IMPORT_FILE_LABEL) \
ENTRY(OBJ_IPF_IMPORT_FILE) \
ENTRY(OBJ_BTN_IMPORT_CHOOSEFILE) \
ENTRY(OBJ_LST_IMPORT_DIALOG) \
ENTRY(OBJ_BTN_IMPORT_ADD_DIALOG) \
ENTRY(OBJ_BTN_IMPORT_REMOVE_DIALOG) \
ENTRY(OBJ_BTN_IMPORT_CHECK_RES) \
ENTRY(OBJ_BTN_IMPORT_CANCEL) \
/* import psd-file window */ \
ENTRY(OBJ_WINDOW_IMPORT_PSDFILE) \
ENTRY(OBJ_IPF_IMPORT_PSDFILE_FILE_LABEL) \
ENTRY(OBJ_IPF_IMPORT_PSDFILE_FILE) \
ENTRY(OBJ_BTN_IMPORT_PSDFILE_CHOOSEFILE) \
ENTRY(OBJ_BTN_IMPORT_PSDFILE_STARTIMPORT) \
ENTRY(OBJ_BTN_IMPORT_PSDFILE_CANCEL) \
/* process psd-file window */ \
ENTRY(OBJ_WINDOW_PROCESS_PSDFILE) \
ENTRY(OBJ_CHK_PROCESS_PSDFILE_IMPORTIMAGES) \
ENTRY(OBJ_CHK_PROCESS_PSDFILE_OVERWRITEIMAGES) \
ENTRY(OBJ_CHK_PROCESS_PSDFILE_IMPORTDIALOGS) \
ENTRY(OBJ_CHK_PROCESS_PSDFILE_APPLY_TEXTCORRECTION) \
ENTRY(OBJ_CHK_PROCESS_PSDFILE_CREATETEXTIDS) \
ENTRY(OBJ_CHK_PROCESS_PSDFILE_CREATECONTROLS) \
ENTRY(OBJ_CHK_PROCESS_PSDFILE_OVERWRITE_DIALOGS) \
ENTRY(OBJ_TABLEVIEW_PROCESS_PSDFILE_DIALOGS) \
ENTRY(OBJ_BTN_PROCESS_PSDFILE_SETALL) \
ENTRY(OBJ_BTN_PROCESS_PSDFILE_CLEARALL) \
ENTRY(OBJ_BTN_PROCESS_PSDFILE_STARTPROCESS) \
ENTRY(OBJ_BTN_PROCESS_PSDFILE_CANCEL) \
/* import prepare resources window */ \
ENTRY(OBJ_WINDOW_IMPORT_PREPARERES) \
ENTRY(OBJ_IPF_IMPORT_RES_ROOT_LABEL) \
ENTRY(OBJ_IPF_IMPORT_RES_ROOT) \
ENTRY(OBJ_BTN_IMPORT_RES_ROOT_CHOOSEDIR) \
ENTRY(OBJ_IPF_IMPORT_RES_IMGCONF_LABEL) \
ENTRY(OBJ_IPF_IMPORT_RES_IMGCONF) \
ENTRY(OBJ_BTN_IMPORT_RES_IMGCONF_CHOOSEFILE) \
ENTRY(OBJ_IPF_IMPORT_RES_FONTCONF_LABEL) \
ENTRY(OBJ_IPF_IMPORT_RES_FONTCONF) \
ENTRY(OBJ_BTN_IMPORT_RES_FONTCONF_CHOOSEFILE) \
ENTRY(OBJ_IPF_IMPORT_RES_SOUNDCONF_LABEL) \
ENTRY(OBJ_IPF_IMPORT_RES_SOUNDCONF) \
ENTRY(OBJ_BTN_IMPORT_RES_SOUNDCONF_CHOOSEFILE) \
ENTRY(OBJ_IPF_IMPORT_RES_GENRESCONF_LABEL) \
ENTRY(OBJ_IPF_IMPORT_RES_GENRESCONF) \
ENTRY(OBJ_BTN_IMPORT_RES_GENRESCONF_CHOOSEFILE) \
ENTRY(OBJ_IPF_IMPORT_RES_LANGCONF_LABEL) \
ENTRY(OBJ_IPF_IMPORT_RES_LANGCONF) \
ENTRY(OBJ_BTN_IMPORT_RES_LANGCONF_CHOOSEFILE) \
ENTRY(OBJ_IPF_IMPORT_RES_STATUS_LABEL) \
ENTRY(OBJ_BTN_IMPORT_RES_OK) \
ENTRY(OBJ_BTN_IMPORT_RES_CANCEL) \
/* TextID window */ \
ENTRY(OBJ_WINDOW_TXTID) \
ENTRY(OBJ_CBX_TXTID_TRANSLATE_LANG) \
ENTRY(OBJ_TXTID_MANAGE_SETS) \
ENTRY(OBJ_TXTID_IMPORT_LANGUAGE) \
ENTRY(OBJ_TXTID_EXPORT_LANGUAGE) \
ENTRY(OBJ_CBX_TXTID_COMPARE_LANG) \
ENTRY(OBJ_CBX_TXTID_PREVIEW_FONT) \
ENTRY(OBJ_CBX_TXTID_PREVIEW_FONT_REF) \
ENTRY(OBJ_TXTID_TRANSLATE_LANG_RM) \
ENTRY(OBJ_TXTID_NEW) \
ENTRY(OBJ_TXTID_REMOVE) \
ENTRY(OBJ_TXTID_OK) \
ENTRY(OBJ_TXTID_CANCEL) \
ENTRY(OBJ_TXTID_TRANSLATIONVIEW) \
ENTRY(OBJ_TXTID_INPUTFIELD_FILTER) \
ENTRY(OBJ_TXTID_TRUNCATION) \
/* Text truncation window */ \
ENTRY(OBJ_WINDOW_TEXTTRUNC) \
ENTRY(OBJ_TXTTRUNC_TRUNCATIONVIEW) \
ENTRY(OBJ_TXTTRUNC_OK) \
ENTRY(OBJ_TXTTRUNC_CANCEL) \
/* FontID window */ \
ENTRY(OBJ_WINDOW_FNTID) \
ENTRY(OBJ_FNTID_SETS) \
ENTRY(OBJ_FNTID_MANAGE_SETS) \
ENTRY(OBJ_FNTID_REM_SET) \
ENTRY(OBJ_FNTID_REMOVE) \
ENTRY(OBJ_FNTID_CHANGE) \
ENTRY(OBJ_FNTID_APPLY) \
ENTRY(OBJ_FNTID_NEW) \
ENTRY(OBJ_FNTID_OK) \
ENTRY(OBJ_FNTID_CANCEL) \
ENTRY(OBJ_FNTID_SELECTION_LIST) \
ENTRY(OBJ_FNTID_INPUTFIELD_FILTER) \
/* SoundID window */ \
ENTRY(OBJ_WINDOW_SNDID) \
ENTRY(OBJ_SNDID_SETS) \
ENTRY(OBJ_SNDID_MANAGE_SETS) \
ENTRY(OBJ_SNDID_REM_SET) \
ENTRY(OBJ_SNDID_VIEW) \
ENTRY(OBJ_SNDID_REMOVE) \
ENTRY(OBJ_SNDID_CHANGE) \
ENTRY(OBJ_SNDID_NEW) \
ENTRY(OBJ_SNDID_OK) \
ENTRY(OBJ_SNDID_PREVIEW) \
ENTRY(OBJ_SNDID_CANCEL) \
ENTRY(OBJ_SNDID_SELECTION_LIST) \
ENTRY(OBJ_SNDID_INPUTFIELD_FILTER) \
/* GeneralResourceID window */ \
ENTRY(OBJ_WINDOW_RESID) \
ENTRY(OBJ_RESID_SETS) \
ENTRY(OBJ_RESID_MANAGE_SETS) \
ENTRY(OBJ_RESID_REM_SET) \
ENTRY(OBJ_RESID_VIEW) \
ENTRY(OBJ_RESID_REMOVE) \
ENTRY(OBJ_RESID_CHANGE) \
ENTRY(OBJ_RESID_NEW) \
ENTRY(OBJ_RESID_OK) \
ENTRY(OBJ_RESID_CANCEL) \
ENTRY(OBJ_RESID_SELECTION_LIST) \
ENTRY(OBJ_RESID_INPUTFIELD_FILTER) \
/* PropertyResourceID window */ \
ENTRY(OBJ_WINDOW_PROPID) \
ENTRY(OBJ_PROPID_SETS) \
ENTRY(OBJ_PROPID_MANAGE_SETS) \
ENTRY(OBJ_PROPID_REM_SET) \
ENTRY(OBJ_PROPID_VIEW) \
ENTRY(OBJ_PROPID_REMOVE) \
ENTRY(OBJ_PROPID_CHANGE) \
ENTRY(OBJ_PROPID_NEW) \
ENTRY(OBJ_PROPID_OK) \
ENTRY(OBJ_PROPID_CANCEL) \
ENTRY(OBJ_PROPID_PROPERTYVIEW) \
ENTRY(OBJ_PROPID_INPUTFIELD_FILTER) \
/* new object id window */ \
ENTRY(OBJ_WINDOW_NEWOBJID) \
ENTRY(OBJ_NEW_OBJID_NEWOBJID) \
ENTRY(OBJ_NEW_OBJID_OK) \
ENTRY(OBJ_NEW_OBJID_CANCEL) \
/* new text id window */ \
ENTRY(OBJ_WINDOW_NEWTXTID) \
ENTRY(OBJ_NEW_TXTID_NEWTXTID) \
ENTRY(OBJ_NEW_TXTID_OK) \
ENTRY(OBJ_NEW_TXTID_CANCEL) \
/* new font set window */ \
ENTRY(OBJ_WINDOW_NEWFNTSET) \
ENTRY(OBJ_NEW_FNTSET_NEWFNTSET) \
ENTRY(OBJ_NEW_FNTSET_COPY) \
ENTRY(OBJ_NEW_FNTSET_OK) \
ENTRY(OBJ_NEW_FNTSET_CANCEL) \
/* new sound set window */ \
ENTRY(OBJ_WINDOW_NEWSNDSET) \
ENTRY(OBJ_NEW_SNDSET_NEWSNDSET) \
ENTRY(OBJ_NEW_SNDSET_COPY) \
ENTRY(OBJ_NEW_SNDSET_OK) \
ENTRY(OBJ_NEW_SNDSET_CANCEL) \
/* new property set window */ \
ENTRY(OBJ_WINDOW_NEWPROPSET) \
ENTRY(OBJ_NEW_PROPSET_NEWPROPSET) \
ENTRY(OBJ_NEW_PROPSET_COPY) \
ENTRY(OBJ_NEW_PROPSET_OK) \
ENTRY(OBJ_NEW_PROPSET_CANCEL) \
/* new project window */ \
ENTRY(OBJ_WINDOW_NEW_PROJECT) \
ENTRY(OBJ_NEW_PROJECT_BROWSE) \
ENTRY(OBJ_NEW_PROJECT_SAVEIN) \
ENTRY(OBJ_NEW_PROJECT_NAME) \
ENTRY(OBJ_NEW_PROJECT_NAME_TEXT) \
ENTRY(OBJ_NEW_PROJECT_TEMPLATE) \
ENTRY(OBJ_NEW_PROJECT_WIDTH) \
ENTRY(OBJ_NEW_PROJECT_HEIGHT) \
ENTRY(OBJ_NEW_PROJECT_SAVE_AS_TEMPLATE) \
ENTRY(OBJ_NEW_PROJECT_REMOVE_TEMPLATE) \
ENTRY(OBJ_NEW_PROJECT_OK) \
ENTRY(OBJ_NEW_PROJECT_CANCEL) \
/* save project as window */ \
ENTRY(OBJ_WINDOW_SAVE_PROJECT) \
ENTRY(OBJ_SAVE_PROJECT_BROWSE) \
ENTRY(OBJ_SAVE_PROJECT_SAVEIN) \
ENTRY(OBJ_SAVE_PROJECT_NAME) \
ENTRY(OBJ_SAVE_PROJECT_NAME_TEXT) \
ENTRY(OBJ_SAVE_PROJECT_OK) \
ENTRY(OBJ_SAVE_PROJECT_CANCEL) \
/* manage images window */ \
ENTRY(OBJ_WINDOW_IMGID) \
ENTRY(OBJ_IMGID_SETS) \
ENTRY(OBJ_IMGID_MANAGE_SETS) \
ENTRY(OBJ_IMGID_VIEW) \
ENTRY(OBJ_IMGID_REMOVE) \
ENTRY(OBJ_IMGID_CHANGE) \
ENTRY(OBJ_IMGID_NEW) \
ENTRY(OBJ_IMGID_OK) \
ENTRY(OBJ_IMGID_CANCEL) \
ENTRY(OBJ_IMGID_SELECTION_LIST) \
ENTRY(OBJ_IMGID_INPUTFIELD_FILTER) \
/* new image id window */ \
ENTRY(OBJ_WINDOW_NEWIMGID) \
ENTRY(OBJ_NEW_IMGID_NEWIMGID) \
ENTRY(OBJ_NEW_IMGID_NEWIMGID_FILE) \
ENTRY(OBJ_NEW_IMGID_CHOOSEDIR) \
ENTRY(OBJ_NEW_IMGID_PERMANENT) \
ENTRY(OBJ_NEW_IMGID_EXPORT_FORMAT) \
ENTRY(OBJ_NEW_IMGID_OK) \
ENTRY(OBJ_NEW_IMGID_CANCEL) \
/* change image id window */ \
ENTRY(OBJ_WINDOW_CHANGEIMGID) \
ENTRY(OBJ_CHANGE_IMGID_CHANGEOLDIMGID) \
ENTRY(OBJ_CHANGE_IMGID_CHANGENEWIMGID) \
ENTRY(OBJ_CHANGE_IMGID_CHANGEIMGID_FILE) \
ENTRY(OBJ_CHANGE_IMGID_CHOOSEDIR) \
ENTRY(OBJ_CHANGE_IMGID_PERMANENT) \
ENTRY(OBJ_CHANGE_IMGID_EXPORT_FORMAT) \
ENTRY(OBJ_CHANGE_IMGID_OK) \
ENTRY(OBJ_CHANGE_IMGID_CANCEL) \
/* change font id window */ \
ENTRY(OBJ_WINDOW_CHANGEFNTID) \
ENTRY(OBJ_CHANGE_FNTID_CHANGEOLDFNTID) \
ENTRY(OBJ_CHANGE_FNTID_CHANGENEWFNTID) \
ENTRY(OBJ_CHANGE_FNTID_CHANGEFNTID_FILE) \
ENTRY(OBJ_CHANGE_FNTID_CHOOSEDIR) \
ENTRY(OBJ_CHANGE_FNTID_SIZE) \
ENTRY(OBJ_CHANGE_FNTID_PERMANENT) \
ENTRY(OBJ_CHANGE_FNTID_EXPORT_FORMAT) \
ENTRY(OBJ_CHANGE_FNTID_OK) \
ENTRY(OBJ_CHANGE_FNTID_CANCEL) \
/* change property id window */ \
ENTRY(OBJ_WINDOW_CHANGEPROPID) \
ENTRY(OBJ_CHANGE_PROPID_OLDPROPID) \
ENTRY(OBJ_CHANGE_PROPID_NEWPROPID) \
ENTRY(OBJ_CHANGE_PROPID_VALUE) \
ENTRY(OBJ_CHANGE_PROPID_TYPE) \
ENTRY(OBJ_CHANGE_PROPID_OK) \
ENTRY(OBJ_CHANGE_PROPID_CANCEL) \
/* change object-id window */ \
ENTRY(OBJ_WINDOW_RENAMEOBJID) \
ENTRY(OBJ_RENAME_OBJID_OLDOBJID) \
ENTRY(OBJ_RENAME_OBJID_NEWOBJID) \
ENTRY(OBJ_RENAME_OBJID_OK) \
ENTRY(OBJ_RENAME_OBJID_CANCEL) \
/* hierarchy window */ \
ENTRY(OBJ_WINDOW_OBJ_HIERARCHY) \
ENTRY(OBJ_BTN_HIERARCHY_ORDER_RAISE) \
ENTRY(OBJ_BTN_HIERARCHY_ORDER_LOWER) \
ENTRY(OBJ_BTN_HIERARCHY_DELETE) \
ENTRY(OBJ_BTN_HIERARCHY_SHOWFULLDIALOG) \
ENTRY(OBJ_BTN_HIERARCHY_SHOWZOOMEDDIALOG) \
ENTRY(OBJ_BTN_HIERARCHY_EXPAND) \
ENTRY(OBJ_BTN_HIERARCHY_COLLAPSE) \
ENTRY(OBJ_BTN_HIERARCHY_TOGGLE_SIDEBAR) \
/* attribute view window */ \
ENTRY(OBJ_WINDOW_ATTRIBUTES) \
ENTRY(OBJ_BTN_ATTRIBUTE_VALUE) \
ENTRY(OBJ_BTN_ATTRIBUTE_PROPERTY) \
/* animations window */ \
ENTRY(OBJ_WINDOW_ANIMATIONS) \
ENTRY(OBJ_ANIMATIONS_VIEW) \
ENTRY(OBJ_ANIMATIONS_PLAY) \
ENTRY(OBJ_ANIMATIONS_JUMP_BACK) \
ENTRY(OBJ_ANIMATIONS_PAUSE) \
ENTRY(OBJ_ANIMATIONS_RECORD) \
ENTRY(OBJ_ANIMATIONS_STOP) \
ENTRY(OBJ_ANIMATIONS_DISCONNECT) \
ENTRY(OBJ_ANIMATIONS_CONNECT) \
ENTRY(OBJ_ANIMATIONS_APPLY_START) \
ENTRY(OBJ_ANIMATIONS_APPLY_TARGET) \
ENTRY(OBJ_ANIMATIONS_TOGGLE_SNAP) \
ENTRY(OBJ_BTN_ANIMATION_ADD) \
ENTRY(OBJ_BTN_ANIMATION_REMOVE) \
ENTRY(OBJ_BTN_ANIMATION_PREVIEW) \
ENTRY(OBJ_BTN_ANIMATION_FINDOBJECT) \
ENTRY(OBJ_BTN_ANIMATION_ATTR_TIMER_ON_OFF) \
ENTRY(OBJ_BTN_ANIMATION_ZOOM_IN) \
ENTRY(OBJ_BTN_ANIMATION_ZOOM_OUT) \
ENTRY(OBJ_BTN_ANIMATION_CHAIN_REMOVE) \
ENTRY(OBJ_BTN_ANIMATION_CHAIN_ADD) \
ENTRY(OBJ_BTN_ANIMATION_CHAIN_COPY) \
ENTRY(OBJ_BTN_ANIMATION_COPY) \
ENTRY(OBJ_BTN_ANIMATION_CHAIN_REPEAT) \
ENTRY(OBJ_BTN_ANIMATION_GRAB_LEFT_ATTRIBUTE) \
ENTRY(OBJ_BTN_ANIMATION_GRAB_RIGHT_ATTRIBUTE) \
ENTRY(OBJ_ANIMATIONS_ZOOM_IN) \
ENTRY(OBJ_ANIMATIONS_ZOOM_OUT) \
/* change sound id window */ \
ENTRY(OBJ_WINDOW_CHANGESNDID) \
ENTRY(OBJ_CHANGE_SNDID_CHANGEOLDSNDID) \
ENTRY(OBJ_CHANGE_SNDID_CHANGENEWSNDID) \
ENTRY(OBJ_CHANGE_SNDID_CHANGESNDID_FILE) \
ENTRY(OBJ_CHANGE_SNDID_CHOOSEDIR) \
ENTRY(OBJ_CHANGE_SNDID_PERMANENT) \
ENTRY(OBJ_CHANGE_SNDID_OK) \
ENTRY(OBJ_CHANGE_SNDID_CANCEL) \
/* change general resource id window */ \
ENTRY(OBJ_WINDOW_CHANGERESID) \
ENTRY(OBJ_CHANGE_RESID_CHANGEOLDRESID) \
ENTRY(OBJ_CHANGE_RESID_CHANGENEWRESID) \
ENTRY(OBJ_CHANGE_RESID_CHANGERESID_FILE) \
ENTRY(OBJ_CHANGE_RESID_CHOOSEDIR) \
ENTRY(OBJ_CHANGE_RESID_PERMANENT) \
ENTRY(OBJ_CHANGE_RESID_OK) \
ENTRY(OBJ_CHANGE_RESID_CANCEL) \
/* custom extensions manager window */ \
ENTRY(OBJ_WINDOW_CUSTOM_EXTENSION_MANAGER) \
ENTRY(OBJ_CMB_CUSTOM_EXTENSION_TARGET) \
ENTRY(OBJ_COMP_LAYER_CUSTOM_EXTENSION_COMMAND) \
ENTRY(OBJ_IPF_CUSTOM_EXTENSION_CMD_CLASS_NAME) \
ENTRY(OBJ_IPF_CUSTOM_EXTENSION_CMD_ID) \
ENTRY(OBJ_COMP_LAYER_CUSTOM_EXTENSION_LAYOUTER) \
ENTRY(OBJ_IPF_CUSTOM_EXTENSION_LAYOUTER_CLASS_NAME) \
ENTRY(OBJ_IPF_CUSTOM_EXTENSION_LAYOUTER_ID) \
ENTRY(OBJ_COMP_LAYER_CUSTOM_EXTENSION_BEHAVIOUR) \
ENTRY(OBJ_IPF_CUSTOM_EXTENSION_BEHAVIOUR_CLASS_NAME) \
ENTRY(OBJ_IPF_CUSTOM_EXTENSION_BEHAVIOUR_ID) \
ENTRY(OBJ_COMP_LAYER_CUSTOM_EXTENSION_CONTROL) \
ENTRY(OBJ_IPF_CUSTOM_EXTENSION_CONTROL_CLASS_NAME) \
ENTRY(OBJ_IPF_CUSTOM_EXTENSION_CONTROL_ID) \
ENTRY(OBJ_COMP_LAYER_CUSTOM_EXTENSION_TEXTTYPE) \
ENTRY(OBJ_IPF_CUSTOM_EXTENSION_TEXTTYPE_CLASS_NAME) \
ENTRY(OBJ_IPF_CUSTOM_EXTENSION_TEXTTYPE_ID) \
ENTRY(OBJ_LABEL_CUSTOM_EXTENSION_SOURCE_FOLDER) \
ENTRY(OBJ_BTN_CUSTOM_EXTENSION_OK) \
ENTRY(OBJ_BTN_CUSTOM_EXTENSION_CANCEL) \
/* Switch controls (in Manage Images window) */ \
ENTRY(OBJ_SWITCH_CONTROLS_COMBOBOX) \
ENTRY(OBJ_SWITCH_CONTROLS_TEXT) \
/* About dialog */ \
ENTRY(OBJ_ABOUT_DIALOG) \
ENTRY(OBJ_ABOUT_COUNT_CUSTOMEXTENSIONS) \
ENTRY(OBJ_ABOUT_COUNT_DIALOGS) \
ENTRY(OBJ_ABOUT_COUNT_DATAPOOL) \
ENTRY(OBJ_ABOUT_COUNT_FONTS) \
ENTRY(OBJ_ABOUT_COUNT_IMAGES) \
ENTRY(OBJ_ABOUT_COUNT_GENRES) \
ENTRY(OBJ_ABOUT_COUNT_SOUNDS) \
ENTRY(OBJ_ABOUT_COUNT_TEXTS) \
ENTRY(OBJ_ABOUT_COUNT_ANIMATIONS) \
ENTRY(OBJ_ABOUT_OK_BTN) \
/* Export Statistics-dialog*/ \
ENTRY(OBJ_EXPORT_STATISTICS_DIALOG) \
ENTRY(OBJ_EXPORT_STATISTICS_IMAGES_SETS) \
ENTRY(OBJ_EXPORT_STATISTICS_IMAGES_RESOURCES) \
ENTRY(OBJ_EXPORT_STATISTICS_IMAGES_INPUT) \
ENTRY(OBJ_EXPORT_STATISTICS_IMAGES_OUTPUT) \
ENTRY(OBJ_EXPORT_STATISTICS_IMAGES_PERCENTAGE) \
ENTRY(OBJ_EXPORT_STATISTICS_FONTS_SETS) \
ENTRY(OBJ_EXPORT_STATISTICS_FONTS_RESOURCES) \
ENTRY(OBJ_EXPORT_STATISTICS_FONTS_INPUT) \
ENTRY(OBJ_EXPORT_STATISTICS_FONTS_OUTPUT) \
ENTRY(OBJ_EXPORT_STATISTICS_FONTS_PERCENTAGE) \
ENTRY(OBJ_EXPORT_STATISTICS_SOUNDS_SETS) \
ENTRY(OBJ_EXPORT_STATISTICS_SOUNDS_RESOURCES) \
ENTRY(OBJ_EXPORT_STATISTICS_SOUNDS_INPUT) \
ENTRY(OBJ_EXPORT_STATISTICS_SOUNDS_OUTPUT) \
ENTRY(OBJ_EXPORT_STATISTICS_SOUNDS_PERCENTAGE) \
ENTRY(OBJ_EXPORT_STATISTICS_GENRES_SETS) \
ENTRY(OBJ_EXPORT_STATISTICS_GENRES_RESOURCES) \
ENTRY(OBJ_EXPORT_STATISTICS_GENRES_INPUT) \
ENTRY(OBJ_EXPORT_STATISTICS_GENRES_OUTPUT) \
ENTRY(OBJ_EXPORT_STATISTICS_GENRES_PERCENTAGE) \
/* main window */ \
ENTRY(OBJ_MAIN_SCROLLVIEW) \
ENTRY(OBJ_MAIN_WIN) \
/*Tooltip text field */ \
ENTRY(OBJ_TOOLTIP) \
/* Console window */ \
ENTRY(OBJ_WINDOW_CONSOLE) \
ENTRY(OBJ_CONSOLE_MULTILINEEDIT) \
ENTRY(OBJ_BTN_CONSOLE_CLEAR) \
/* generic progress window */ \
ENTRY(OBJ_WINDOW_PROGRESS) \
ENTRY(OBJ_LABEL_PROGRESS_WINDOW_STATIC_TEXT) \
ENTRY(OBJ_LABEL_PROGRESS_WINDOW_STEP_DESCRIPTION) \
ENTRY(OBJ_PROGRESSBAR_PROGRESS_WINDOW) \
ENTRY(OBJ_CANCEL_PROGRESS_WINDOW) \
/* Data Pool Management Window */ \
ENTRY(OBJ_WINDOW_MANAGEDATAPOOL) \
ENTRY(OBJ_WINDOW_MANAGEDATAPOOL_ENTRIES_LISTBOX) \
ENTRY(OBJ_WINDOW_MANAGEDATAPOOL_ENTRIES_DETAILSVIEW) \
ENTRY(OBJ_WINDOW_MANAGEDATAPOOL_ENTRIES_ADD) \
ENTRY(OBJ_WINDOW_MANAGEDATAPOOL_ENTRIES_REMOVE) \
ENTRY(OBJ_WINDOW_MANAGEDATAPOOL_NAME_INPUTFIELD) \
ENTRY(OBJ_WINDOW_MANAGEDATAPOOL_DESCRIPTION_INPUTFIELD) \
ENTRY(OBJ_WINDOW_MANAGEDATAPOOL_ROWS_INPUTFIELD) \
ENTRY(OBJ_WINDOW_MANAGEDATAPOOL_COLUMNS_INPUTFIELD) \
ENTRY(OBJ_WINDOW_MANAGEDATAPOOL_VALUE_TABLEVIEW) \
ENTRY(OBJ_WINDOW_MANAGEDATAPOOL_OBJECTID_COMBOBOX) \
ENTRY(OBJ_WINDOW_MANAGEDATAPOOL_OBSERVERS_ADD) \
ENTRY(OBJ_WINDOW_MANAGEDATAPOOL_OBSERVERS_LISTBOX) \
ENTRY(OBJ_WINDOW_MANAGEDATAPOOL_REMOVE_OBSERVER_BUTTON) \
ENTRY(OBJ_WINDOW_MANAGEDATAPOOL_CLOSE_BUTTON) \
ENTRY(OBJ_DIALOG_COLOR_SELECTION) \
ENTRY(OBJ_DIALOG_COLOR_SELECTION_ADD_TO_FAVORITES) \
ENTRY(OBJ_DIALOG_COLOR_SELECTION_COLOR) \
ENTRY(OBJ_DIALOG_COLOR_SELECTION_ALPHA) \
ENTRY(OBJ_DIALOG_COLOR_SELECTION_RED) \
ENTRY(OBJ_DIALOG_COLOR_SELECTION_GREEN) \
ENTRY(OBJ_DIALOG_COLOR_SELECTION_BLUE) \
ENTRY(OBJ_DIALOG_COLOR_SELECTION_HEX) \
ENTRY(OBJ_DIALOG_COLOR_SELECTION_OK) \
ENTRY(OBJ_DIALOG_COLOR_SELECTION_CANCEL) \
/* Insert all GSE object IDs _in front of_ OBJ_USER_START_TAG. */ \
ENTRY(OBJ_USER_START_TAG) 
