/**
User-defined image-Resources.
Each of these IDs maps to a bitmap within the GUI.
You may freely add and remove entries here.

Each entry has to look like:

ENTRY(IMG_ID, "Path/ImageName.png", true)    \

Last parameter specifies if image is permanent.
Where the first parameter specifies the name of the image id and the
second parameter is the path including the filename starting from
its resource directory.
*/

#define USER_IMAGE_TABLE            \
    \
/* Common images */ \
/* radiobutton */ \
ENTRY(IMG_RADIOBUTTON_FOCUSSED_SELECTED, "Common/RadioButton/radio_button_dot.png", true)    \
ENTRY(IMG_RADIOBUTTON_FOCUSSED_NOT_SELECTED, "Common/RadioButton/radio_button_field.png", true)    \
ENTRY(IMG_RADIOBUTTON_GRAYED_OUT_SELECTED, "Common/RadioButton/radio_button_dot_g.png", true)    \
ENTRY(IMG_RADIOBUTTON_GRAYED_OUT_NOT_SELECTED, "Common/RadioButton/radio_button_field_g.png", true)    \
ENTRY(IMG_RADIOBUTTON_HIGHLIGHTED_SELECTED, "Common/RadioButton/radio_button_dot_h.png", true)    \
ENTRY(IMG_RADIOBUTTON_HIGHLIGHTED_NOT_SELECTED, "Common/RadioButton/radio_button_field_h.png", true)    \
ENTRY(IMG_RADIOBUTTON_PRESSED_SELECTED, "Common/RadioButton/radio_button_dot_p.png", true)    \
ENTRY(IMG_RADIOBUTTON_PRESSED_NOT_SELECTED, "Common/RadioButton/radio_button_field_p.png", true)    \
ENTRY(IMG_RADIOBUTTON_STANDARD_SELECTED, "Common/RadioButton/radio_button_dot.png", true)    \
ENTRY(IMG_RADIOBUTTON_STANDARD_NOT_SELECTED, "Common/RadioButton/radio_button_field.png", true)    \
/* checkbox */ \
ENTRY(IMG_CHECKBOX_FOCUSSED_SELECTED, "Common/Checkbox/check_box_checked.png", true)    \
ENTRY(IMG_CHECKBOX_FOCUSSED_NOT_SELECTED, "Common/Checkbox/check_box_empty.png", true)    \
ENTRY(IMG_CHECKBOX_GRAYED_OUT_SELECTED, "Common/Checkbox/check_box_checked_g.png", true)    \
ENTRY(IMG_CHECKBOX_GRAYED_OUT_NOT_SELECTED, "Common/Checkbox/check_box_empty_g.png", true)    \
ENTRY(IMG_CHECKBOX_HIGHLIGHTED_SELECTED, "Common/Checkbox/check_box_checked_h.png", true)    \
ENTRY(IMG_CHECKBOX_HIGHLIGHTED_NOT_SELECTED, "Common/Checkbox/check_box_empty_h.png", true)    \
ENTRY(IMG_CHECKBOX_PRESSED_SELECTED, "Common/Checkbox/check_box_checked_p.png", true)    \
ENTRY(IMG_CHECKBOX_PRESSED_NOT_SELECTED, "Common/Checkbox/check_box_empty_p.png", true)    \
ENTRY(IMG_CHECKBOX_STANDARD_SELECTED, "Common/Checkbox/check_box_checked.png", true)    \
ENTRY(IMG_CHECKBOX_STANDARD_NOT_SELECTED, "Common/Checkbox/check_box_empty.png", true)    \
    \
/* combobox */ \
ENTRY(IMG_COMBOBOX_BUTTON_STANDARD, "Common/Combobox/combobox_arrow.png", true)    \
ENTRY(IMG_COMBOBOX_BUTTON_PRESSED, "Common/Combobox/combobox_arrow_p.png", true)    \
ENTRY(IMG_COMBOBOX_BUTTON_HIGHLIGHTED, "Common/Combobox/combobox_arrow_h.png", true)    \
ENTRY(IMG_COMBOBOX_BUTTON_GRAYEDOUT, "Common/Combobox/combobox_arrow_g.png", true)    \
ENTRY(IMG_COMBOBOX_BUTTON_FOCUSSED, "Common/Combobox/combobox_arrow_h.png", true)    \
/* tree view */\
ENTRY(IMG_TREE_HIDE_SUBTREE, "Common/TreeView/controls_drop_arrow_right_standard.png", true)    \
ENTRY(IMG_TREE_HIDE_SUBTREE_FOCUSSED, "Common/TreeView/controls_drop_arrow_right_hover.png", true)    \
ENTRY(IMG_TREE_SHOW_SUBTREE, "Common/TreeView/controls_drop_arrow_down_standard.png", true)    \
ENTRY(IMG_TREE_SHOW_SUBTREE_FOCUSSED, "Common/TreeView/controls_drop_arrow_down_hover.png", true)    \
/* input field */\
ENTRY(IMG_INPUTFIELD_FOCUSSED, "Common/Textinputline/Textinputline_focussed.png", true)    \
ENTRY(IMG_INPUTFIELD_GRAYEDOUT, "Common/Textinputline/Textinputline_grayedout.png", true)    \
ENTRY(IMG_INPUTFIELD_HIGHLIGHTED, "Common/Textinputline/Textinputline_highlighted.png", true)    \
ENTRY(IMG_INPUTFIELD_STANDARD, "Common/Textinputline/Textinputline_Standard.png", true)    \
/* Elements button */\
ENTRY(IMG_BUTTON_STANDARD, "Common/Button_64x16/Button_standard.png", true)    \
ENTRY(IMG_BUTTON_FOCUSSED, "Common/Button_64x16/Button_highlighted.png", true)    \
ENTRY(IMG_BUTTON_HIGHLIGHTED, "Common/Button_64x16/Button_highlighted.png", true)    \
ENTRY(IMG_BUTTON_GRAYEDOUT, "Common/Button_64x16/Button_grayedout.png", true)    \
ENTRY(IMG_BUTTON_PRESSED, "Common/Button_64x16/Button_pressed.png", true)    \
    \
/* progress bar */\
ENTRY(IMG_PROGRESS_BACKGROUND, "Common/ProgressBar/pb_background.png", true)    \
ENTRY(IMG_PROGRESS_FILLER, "Common/ProgressBar/pb_filler.png", true)    \
/* slider */\
ENTRY(IMG_SLIDER_BACKGROUND, "Common/Slider/slider_background.png", true)   \
ENTRY(IMG_SLIDER_HANDLE, "Common/Slider/slider_handle.png", true)   \
ENTRY(IMG_SLIDER_HANDLE_H, "Common/Slider/slider_handle_h.png", true) \
ENTRY(IMG_SLIDER_HANDLE_P, "Common/Slider/slider_handle_p.png", true)   \
/* Main menu */\
ENTRY(IMG_MENUBAR_BACKGRND, "Menu/MenuBarBackground.png", true)    \
ENTRY(IMG_MENU_BACKGRND, "Menu/MenuBackground.png", true)    \
ENTRY(IMG_MENUBAR_ITEM, "Menu/MenuBarItem.png", true)    \
ENTRY(IMG_MENUBAR_ITEM_F, "Menu/MenuBarItem_f.png", true)    \
ENTRY(IMG_MENUBAR_ITEM_H, "Menu/MenuBarItem_h.png", true)    \
ENTRY(IMG_MENUBAR_ITEM_P, "Menu/MenuBarItem_p.png", true)    \
ENTRY(IMG_MENUBAR_ITEM_G, "Menu/MenuBarItem_g.png", true)    \
/* Sub menu arrows */\
ENTRY(IMG_SUBMENU_ARROW_CLOSED, "Menu/ArrowRight.png", true)    \
ENTRY(IMG_SUBMENU_ARROW_OPEN, "Menu/ArrowDown.png", true)    \
    \
ENTRY(IMG_MENUITEM_STANDARD, "Menu/MenuItem.png", true)    \
ENTRY(IMG_MENUITEM_HIGHLIGHTED, "Menu/MenuItem_h.png", true)    \
ENTRY(IMG_MENUITEM_PRESSED, "Menu/MenuItem_p.png", true)    \
ENTRY(IMG_MENUITEM_GRAYEDOUT, "Menu/MenuItem_g.png", true)    \
ENTRY(IMG_MENUITEM_SELECTED, "Menu/MenuItem_s.png", true)    \
ENTRY(IMG_MENUITEM_FOCUSSED, "Menu/MenuItem_f.png", true)    \
    \
/* Menu icons */\
/* File menu */\
ENTRY(IMG_MENU_FILE_ICON_NEW_FORM, "Icons/Menu/File/new_dialog.png", true)    \
ENTRY(IMG_MENU_FILE_ICON_NEW_FORM_G, "Icons/Menu/File/new_dialog_g.png", true)    \
ENTRY(IMG_MENU_FILE_ICON_NEW_FORM_H, "Icons/Menu/File/new_dialog_h.png", true)    \
ENTRY(IMG_MENU_FILE_ICON_NEW_FORM_P, "Icons/Menu/File/new_dialog_p.png", true)    \
ENTRY(IMG_MENU_FILE_ICON_NEW_PROJECT, "Icons/Menu/File/new_project.png", true)    \
ENTRY(IMG_MENU_FILE_ICON_NEW_PROJECT_G, "Icons/Menu/File/new_project_g.png", true)    \
ENTRY(IMG_MENU_FILE_ICON_NEW_PROJECT_H, "Icons/Menu/File/new_project_h.png", true)    \
ENTRY(IMG_MENU_FILE_ICON_NEW_PROJECT_P, "Icons/Menu/File/new_project_p.png", true)    \
ENTRY(IMG_MENU_FILE_ICON_OPEN_PROJECT, "Icons/Menu/File/open_project.png", true)    \
ENTRY(IMG_MENU_FILE_ICON_OPEN_PROJECT_G, "Icons/Menu/File/open_project_g.png", true)    \
ENTRY(IMG_MENU_FILE_ICON_OPEN_PROJECT_H, "Icons/Menu/File/open_project_h.png", true)    \
ENTRY(IMG_MENU_FILE_ICON_OPEN_PROJECT_P, "Icons/Menu/File/open_project_p.png", true)    \
ENTRY(IMG_MENU_FILE_ICON_RECENT_PROJECTS, "Icons/Menu/File/recent_projects.png", true)    \
ENTRY(IMG_MENU_FILE_ICON_RECENT_PROJECTS_G, "Icons/Menu/File/recent_projects_g.png", true)    \
ENTRY(IMG_MENU_FILE_ICON_RECENT_PROJECTS_H, "Icons/Menu/File/recent_projects_h.png", true)    \
ENTRY(IMG_MENU_FILE_ICON_RECENT_PROJECTS_P, "Icons/Menu/File/recent_projects_p.png", true)    \
ENTRY(IMG_MENU_FILE_ICON_SAVE, "Icons/Menu/File/save_project.png", true)    \
ENTRY(IMG_MENU_FILE_ICON_SAVE_G, "Icons/Menu/File/save_project_g.png", true)    \
ENTRY(IMG_MENU_FILE_ICON_SAVE_H, "Icons/Menu/File/save_project_h.png", true)    \
ENTRY(IMG_MENU_FILE_ICON_SAVE_P, "Icons/Menu/File/save_project_p.png", true)    \
ENTRY(IMG_MENU_FILE_ICON_SETTINGS, "Icons/Menu/File/settings.png", true)    \
ENTRY(IMG_MENU_FILE_ICON_SETTINGS_G, "Icons/Menu/File/settings_g.png", true)    \
ENTRY(IMG_MENU_FILE_ICON_SETTINGS_H, "Icons/Menu/File/settings_h.png", true)    \
ENTRY(IMG_MENU_FILE_ICON_SETTINGS_P, "Icons/Menu/File/settings_p.png", true)    \
ENTRY(IMG_MENU_FILE_ICON_RUN, "Icons/Menu/File/run_simulation.png", true)    \
ENTRY(IMG_MENU_FILE_ICON_RUN_G, "Icons/Menu/File/run_simulation_g.png", true)    \
ENTRY(IMG_MENU_FILE_ICON_RUN_H, "Icons/Menu/File/run_simulation_h.png", true)    \
ENTRY(IMG_MENU_FILE_ICON_RUN_P, "Icons/Menu/File/run_simulation_p.png", true)    \
ENTRY(IMG_MENU_FILE_ICON_QUIT, "Icons/Menu/File/quit.png", true)    \
ENTRY(IMG_MENU_FILE_ICON_QUIT_G, "Icons/Menu/File/quit_g.png", true)    \
ENTRY(IMG_MENU_FILE_ICON_QUIT_H, "Icons/Menu/File/quit_h.png", true)    \
ENTRY(IMG_MENU_FILE_ICON_QUIT_P, "Icons/Menu/File/quit_p.png", true)    \
/* Edit menu */\
ENTRY(IMG_MENU_EDIT_ICON_COPY, "Icons/Menu/Edit/copy.png", true)    \
ENTRY(IMG_MENU_EDIT_ICON_CUT, "Icons/Menu/Edit/cut.png", true)    \
ENTRY(IMG_MENU_EDIT_ICON_DELETE, "Icons/Menu/Edit/delete.png", true)    \
ENTRY(IMG_MENU_EDIT_ICON_FIND, "Icons/Menu/Edit/find.png", true)    \
ENTRY(IMG_MENU_EDIT_ICON_PASTE, "Icons/Menu/Edit/paste.png", true)    \
ENTRY(IMG_MENU_EDIT_ICON_REDO, "Icons/Menu/Edit/redo.png", true)    \
ENTRY(IMG_MENU_EDIT_ICON_SELECT_ALL, "Icons/Menu/Edit/select_all.png", true)    \
ENTRY(IMG_MENU_EDIT_ICON_UNDO, "Icons/Menu/Edit/undo.png", true)    \
/* View menu */\
ENTRY(IMG_MENU_VIEW_ICON_SHOW_GUIDELINES, "Icons/Menu/View/toggle_guidelines.png", true)    \
ENTRY(IMG_MENU_VIEW_ICON_SHOW_GUIDELINES_H, "Icons/Menu/View/toggle_guidelines_h.png", true)    \
ENTRY(IMG_MENU_VIEW_ICON_SHOW_GUIDELINES_P, "Icons/Menu/View/toggle_guidelines_p.png", true)    \
ENTRY(IMG_MENU_VIEW_ICON_HIDE_GUIDELINES, "Icons/Menu/View/toggle_guidelines_s.png", true)    \
ENTRY(IMG_MENU_VIEW_ICON_HIDE_GUIDELINES_H, "Icons/Menu/View/toggle_guidelines_sh.png", true)    \
ENTRY(IMG_MENU_VIEW_ICON_HIDE_GUIDELINES_P, "Icons/Menu/View/toggle_guidelines_sp.png", true)    \
ENTRY(IMG_MENU_VIEW_ICON_SHOW_GRID, "Icons/Menu/View/toggle_grid.png", true)    \
ENTRY(IMG_MENU_VIEW_ICON_SHOW_GRID_H, "Icons/Menu/View/toggle_grid_h.png", true)    \
ENTRY(IMG_MENU_VIEW_ICON_SHOW_GRID_P, "Icons/Menu/View/toggle_grid_p.png", true)    \
ENTRY(IMG_MENU_VIEW_ICON_HIDE_GRID, "Icons/Menu/View/toggle_grid_s.png", true)    \
ENTRY(IMG_MENU_VIEW_ICON_HIDE_GRID_H, "Icons/Menu/View/toggle_grid_sh.png", true)    \
ENTRY(IMG_MENU_VIEW_ICON_HIDE_GRID_P, "Icons/Menu/View/toggle_grid_sp.png", true)    \
ENTRY(IMG_MENU_VIEW_ICON_SNAP_GUIDELINES, "Icons/Menu/View/toggle_snap_guidelines.png", true)    \
ENTRY(IMG_MENU_VIEW_ICON_SNAP_GUIDELINES_H, "Icons/Menu/View/toggle_snap_guidelines_h.png", true)    \
ENTRY(IMG_MENU_VIEW_ICON_SNAP_GUIDELINES_P, "Icons/Menu/View/toggle_snap_guidelines_p.png", true)    \
ENTRY(IMG_MENU_VIEW_ICON_UNSNAP_GUIDELINES, "Icons/Menu/View/toggle_snap_guidelines_s.png", true)    \
ENTRY(IMG_MENU_VIEW_ICON_UNSNAP_GUIDELINES_H, "Icons/Menu/View/toggle_snap_guidelines_sh.png", true)    \
ENTRY(IMG_MENU_VIEW_ICON_UNSNAP_GUIDELINES_P, "Icons/Menu/View/toggle_snap_guidelines_sp.png", true)    \
ENTRY(IMG_MENU_VIEW_ICON_SHOW_COORDINATES, "Icons/Menu/View/toggle_coordinates.png", true)    \
ENTRY(IMG_MENU_VIEW_ICON_SHOW_COORDINATES_H, "Icons/Menu/View/toggle_coordinates_h.png", true)    \
ENTRY(IMG_MENU_VIEW_ICON_SHOW_COORDINATES_P, "Icons/Menu/View/toggle_coordinates_p.png", true)    \
ENTRY(IMG_MENU_VIEW_ICON_HIDE_COORDINATES, "Icons/Menu/View/toggle_coordinates_s.png", true)    \
ENTRY(IMG_MENU_VIEW_ICON_HIDE_COORDINATES_H, "Icons/Menu/View/toggle_coordinates_sh.png", true)    \
ENTRY(IMG_MENU_VIEW_ICON_HIDE_COORDINATES_P, "Icons/Menu/View/toggle_coordinates_sp.png", true)    \
/* Layout menu */\
/* subemnu-icons */\
ENTRY(IMG_MENU_LAYOUT_SUBMENU_ARRANGE, "Icons/Menu/Layout/submenu_arrange.png", true)   \
ENTRY(IMG_MENU_LAYOUT_SUBMENU_ARRANGE_H, "Icons/Menu/Layout/submenu_arrange_h.png", true)   \
ENTRY(IMG_MENU_LAYOUT_SUBMENU_ARRANGE_P, "Icons/Menu/Layout/submenu_arrange_p.png", true)   \
ENTRY(IMG_MENU_LAYOUT_SUBMENU_ALIGN, "Icons/Menu/Layout/submenu_align.png", true)   \
ENTRY(IMG_MENU_LAYOUT_SUBMENU_ALIGN_H, "Icons/Menu/Layout/submenu_align_h.png", true)   \
ENTRY(IMG_MENU_LAYOUT_SUBMENU_ALIGN_P, "Icons/Menu/Layout/submenu_align_p.png", true)   \
ENTRY(IMG_MENU_LAYOUT_ALIGN_ICON_CENTER, "Icons/Menu/Layout/object_resize_original.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ALIGN_ICON_CENTER_G, "Icons/Menu/Layout/object_resize_original_g.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ALIGN_ICON_CENTER_H, "Icons/Menu/Layout/object_resize_original_h.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ALIGN_ICON_CENTER_P, "Icons/Menu/Layout/object_resize_original_p.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ICON_SCALE_OBJECTS_SAME_SIZE, "Icons/Menu/Layout/object_unify_size.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ICON_SCALE_OBJECTS_SAME_SIZE_G, "Icons/Menu/Layout/object_unify_size_g.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ICON_SCALE_OBJECTS_SAME_SIZE_H, "Icons/Menu/Layout/object_unify_size_h.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ICON_SCALE_OBJECTS_SAME_SIZE_P, "Icons/Menu/Layout/object_unify_size_p.png", true)    \
/* Layout - group/ungroup objects */ \
ENTRY(IMG_MENU_LAYOUT_ICON_GROUP_OBJECTS, "Icons/Menu/Layout/object_group.png", true)   \
ENTRY(IMG_MENU_LAYOUT_ICON_GROUP_OBJECTS_G, "Icons/Menu/Layout/object_group_g.png", true)   \
ENTRY(IMG_MENU_LAYOUT_ICON_GROUP_OBJECTS_H, "Icons/Menu/Layout/object_group_h.png", true)   \
ENTRY(IMG_MENU_LAYOUT_ICON_GROUP_OBJECTS_P, "Icons/Menu/Layout/object_group_p.png", true)   \
ENTRY(IMG_MENU_LAYOUT_ICON_UNGROUP_OBJECTS, "Icons/Menu/Layout/object_ungroup.png", true)   \
ENTRY(IMG_MENU_LAYOUT_ICON_UNGROUP_OBJECTS_G, "Icons/Menu/Layout/object_ungroup_g.png", true)   \
ENTRY(IMG_MENU_LAYOUT_ICON_UNGROUP_OBJECTS_H, "Icons/Menu/Layout/object_ungroup_h.png", true)   \
ENTRY(IMG_MENU_LAYOUT_ICON_UNGROUP_OBJECTS_P, "Icons/Menu/Layout/object_ungroup_p.png", true)   \
/* Layout - flip */ \
ENTRY(IMG_MENU_LAYOUT_ICON_FLIP_HOR, "Icons/Menu/Layout/flip_hor.png", true)   \
ENTRY(IMG_MENU_LAYOUT_ICON_FLIP_HOR_G, "Icons/Menu/Layout/flip_hor_g.png", true)   \
ENTRY(IMG_MENU_LAYOUT_ICON_FLIP_HOR_H, "Icons/Menu/Layout/flip_hor_h.png", true)   \
ENTRY(IMG_MENU_LAYOUT_ICON_FLIP_HOR_P, "Icons/Menu/Layout/flip_hor_p.png", true)   \
ENTRY(IMG_MENU_LAYOUT_ICON_FLIP_VER, "Icons/Menu/Layout/flip_ver.png", true)   \
ENTRY(IMG_MENU_LAYOUT_ICON_FLIP_VER_G, "Icons/Menu/Layout/flip_ver_g.png", true)   \
ENTRY(IMG_MENU_LAYOUT_ICON_FLIP_VER_H, "Icons/Menu/Layout/flip_ver_h.png", true)   \
ENTRY(IMG_MENU_LAYOUT_ICON_FLIP_VER_P, "Icons/Menu/Layout/flip_ver_p.png", true)   \
/* Layout - rotate */ \
ENTRY(IMG_MENU_LAYOUT_ICON_ROTATE_RIGHT, "Icons/Menu/Layout/rotate_right.png", true)   \
ENTRY(IMG_MENU_LAYOUT_ICON_ROTATE_RIGHT_G, "Icons/Menu/Layout/rotate_right_g.png", true)   \
ENTRY(IMG_MENU_LAYOUT_ICON_ROTATE_RIGHT_H, "Icons/Menu/Layout/rotate_right_h.png", true)   \
ENTRY(IMG_MENU_LAYOUT_ICON_ROTATE_RIGHT_P, "Icons/Menu/Layout/rotate_right_p.png", true)   \
ENTRY(IMG_MENU_LAYOUT_ICON_ROTATE_LEFT, "Icons/Menu/Layout/rotate_left.png", true)   \
ENTRY(IMG_MENU_LAYOUT_ICON_ROTATE_LEFT_G, "Icons/Menu/Layout/rotate_left_g.png", true)   \
ENTRY(IMG_MENU_LAYOUT_ICON_ROTATE_LEFT_H, "Icons/Menu/Layout/rotate_left_h.png", true)   \
ENTRY(IMG_MENU_LAYOUT_ICON_ROTATE_LEFT_P, "Icons/Menu/Layout/rotate_left_p.png", true)   \
/* Layout - arrange objects sub-menu */\
ENTRY(IMG_MENU_LAYOUT_ARRANGE_ICON_RAISE_OBJECT, "Icons/Menu/Layout/object_raise.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ARRANGE_ICON_RAISE_OBJECT_G, "Icons/Menu/Layout/object_raise_g.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ARRANGE_ICON_RAISE_OBJECT_H, "Icons/Menu/Layout/object_raise_h.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ARRANGE_ICON_RAISE_OBJECT_P, "Icons/Menu/Layout/object_raise_p.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ARRANGE_ICON_LOWER_OBJECT, "Icons/Menu/Layout/object_lower.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ARRANGE_ICON_LOWER_OBJECT_G, "Icons/Menu/Layout/object_lower_g.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ARRANGE_ICON_LOWER_OBJECT_H, "Icons/Menu/Layout/object_lower_h.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ARRANGE_ICON_LOWER_OBJECT_P, "Icons/Menu/Layout/object_lower_p.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ARRANGE_ICON_OBJECT_FRONT, "Icons/Menu/Layout/object_foreground.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ARRANGE_ICON_OBJECT_FRONT_G, "Icons/Menu/Layout/object_foreground_g.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ARRANGE_ICON_OBJECT_FRONT_H, "Icons/Menu/Layout/object_foreground_h.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ARRANGE_ICON_OBJECT_FRONT_P, "Icons/Menu/Layout/object_foreground_p.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ARRANGE_ICON_OBJECT_BACK, "Icons/Menu/Layout/object_background.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ARRANGE_ICON_OBJECT_BACK_G, "Icons/Menu/Layout/object_background_g.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ARRANGE_ICON_OBJECT_BACK_H, "Icons/Menu/Layout/object_background_h.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ARRANGE_ICON_OBJECT_BACK_P, "Icons/Menu/Layout/object_background_p.png", true)    \
/* Layout - adjust objects sub-menu */\
ENTRY(IMG_MENU_LAYOUT_ALIGN_ICON_LEFT, "Icons/Menu/Layout/object_align_left.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ALIGN_ICON_LEFT_G, "Icons/Menu/Layout/object_align_left_g.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ALIGN_ICON_LEFT_H, "Icons/Menu/Layout/object_align_left_h.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ALIGN_ICON_LEFT_P, "Icons/Menu/Layout/object_align_left_p.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ALIGN_ICON_RIGHT, "Icons/Menu/Layout/object_align_right.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ALIGN_ICON_RIGHT_G, "Icons/Menu/Layout/object_align_right_g.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ALIGN_ICON_RIGHT_H, "Icons/Menu/Layout/object_align_right_h.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ALIGN_ICON_RIGHT_P, "Icons/Menu/Layout/object_align_right_p.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ALIGN_ICON_TOP, "Icons/Menu/Layout/object_align_top.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ALIGN_ICON_TOP_G, "Icons/Menu/Layout/object_align_top_g.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ALIGN_ICON_TOP_H, "Icons/Menu/Layout/object_align_top_h.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ALIGN_ICON_TOP_P, "Icons/Menu/Layout/object_align_top_p.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ALIGN_ICON_BOTTOM, "Icons/Menu/Layout/object_align_bottom.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ALIGN_ICON_BOTTOM_G, "Icons/Menu/Layout/object_align_bottom_g.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ALIGN_ICON_BOTTOM_H, "Icons/Menu/Layout/object_align_bottom_h.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ALIGN_ICON_BOTTOM_P, "Icons/Menu/Layout/object_align_bottom_p.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ALIGN_ICON_VERTICALLY, "Icons/Menu/Layout/object_center_vertically.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ALIGN_ICON_VERTICALLY_G, "Icons/Menu/Layout/object_center_vertically_g.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ALIGN_ICON_VERTICALLY_H, "Icons/Menu/Layout/object_center_vertically_h.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ALIGN_ICON_VERTICALLY_P, "Icons/Menu/Layout/object_center_vertically_p.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ALIGN_ICON_HORIZONTALLY, "Icons/Menu/Layout/object_center_horizontally.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ALIGN_ICON_HORIZONTALLY_G, "Icons/Menu/Layout/object_center_horizontally_g.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ALIGN_ICON_HORIZONTALLY_H, "Icons/Menu/Layout/object_center_horizontally_h.png", true)    \
ENTRY(IMG_MENU_LAYOUT_ALIGN_ICON_HORIZONTALLY_P, "Icons/Menu/Layout/object_center_horizontally_p.png", true)    \
ENTRY(IMG_MENU_LAYOUT_DISTRIBUTE_VERTICALLY, "Icons/Menu/Layout/object_distribute_vertically.png", true)    \
ENTRY(IMG_MENU_LAYOUT_DISTRIBUTE_VERTICALLY_G, "Icons/Menu/Layout/object_distribute_vertically_g.png", true)    \
ENTRY(IMG_MENU_LAYOUT_DISTRIBUTE_VERTICALLY_H, "Icons/Menu/Layout/object_distribute_vertically_h.png", true)    \
ENTRY(IMG_MENU_LAYOUT_DISTRIBUTE_VERTICALLY_P, "Icons/Menu/Layout/object_distribute_vertically_p.png", true)    \
ENTRY(IMG_MENU_LAYOUT_DISTRIBUTE_HORIZONTALLY, "Icons/Menu/Layout/object_distribute_horizontally.png", true)    \
ENTRY(IMG_MENU_LAYOUT_DISTRIBUTE_HORIZONTALLY_G, "Icons/Menu/Layout/object_distribute_horizontally_g.png", true)    \
ENTRY(IMG_MENU_LAYOUT_DISTRIBUTE_HORIZONTALLY_H, "Icons/Menu/Layout/object_distribute_horizontally_h.png", true)    \
ENTRY(IMG_MENU_LAYOUT_DISTRIBUTE_HORIZONTALLY_P, "Icons/Menu/Layout/object_distribute_horizontally_p.png", true)    \
/* Resources menu */\
ENTRY(IMG_MENU_RESOURCES_SUBMENU_MANAGE, "Icons/Menu/ManageResources/submenu_manage.png", true)   \
ENTRY(IMG_MENU_RESOURCES_SUBMENU_MANAGE_H, "Icons/Menu/ManageResources/submenu_manage_h.png", true)   \
ENTRY(IMG_MENU_RESOURCES_SUBMENU_MANAGE_P, "Icons/Menu/ManageResources/submenu_manage_p.png", true)   \
ENTRY(IMG_MENU_RESOURCES_ICON_IMAGES, "Icons/Menu/ManageResources/manage_images.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_IMAGES_G, "Icons/Menu/ManageResources/manage_images_g.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_IMAGES_H, "Icons/Menu/ManageResources/manage_images_h.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_IMAGES_P, "Icons/Menu/ManageResources/manage_images_p.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_TEXTS, "Icons/Menu/ManageResources/manage_texts.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_TEXTS_G, "Icons/Menu/ManageResources/manage_texts_g.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_TEXTS_H, "Icons/Menu/ManageResources/manage_texts_h.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_TEXTS_P, "Icons/Menu/ManageResources/manage_texts_p.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_FONTS, "Icons/Menu/ManageResources/manage_fonts.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_FONTS_G, "Icons/Menu/ManageResources/manage_fonts_g.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_FONTS_H, "Icons/Menu/ManageResources/manage_fonts_h.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_FONTS_P, "Icons/Menu/ManageResources/manage_fonts_p.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_SOUNDS, "Icons/Menu/ManageResources/manage_sounds.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_SOUNDS_G, "Icons/Menu/ManageResources/manage_sounds_g.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_SOUNDS_H, "Icons/Menu/ManageResources/manage_sounds_h.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_SOUNDS_P, "Icons/Menu/ManageResources/manage_sounds_p.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_GENRES, "Icons/Menu/ManageResources/manage_general.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_GENRES_G, "Icons/Menu/ManageResources/manage_general_g.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_GENRES_H, "Icons/Menu/ManageResources/manage_general_h.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_GENRES_P, "Icons/Menu/ManageResources/manage_general_p.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_PROPERTIES, "Icons/Menu/ManageResources/manage_general.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_PROPERTIES_G, "Icons/Menu/ManageResources/manage_general_g.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_PROPERTIES_H, "Icons/Menu/ManageResources/manage_general_h.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_PROPERTIES_P, "Icons/Menu/ManageResources/manage_general_p.png", true)    \
ENTRY(IMG_MENU_RESOURCES_MANAGE_DATAPOOL, "Icons/Menu/ManageResources/manage_datapool.png", true)    \
ENTRY(IMG_MENU_RESOURCES_MANAGE_DATAPOOL_G, "Icons/Menu/ManageResources/manage_datapool_g.png", true)    \
ENTRY(IMG_MENU_RESOURCES_MANAGE_DATAPOOL_H, "Icons/Menu/ManageResources/manage_datapool_h.png", true)    \
ENTRY(IMG_MENU_RESOURCES_MANAGE_DATAPOOL_P, "Icons/Menu/ManageResources/manage_datapool_p.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_REQUIREMENTS, "Icons/Menu/ManageResources/requirements.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_REQUIREMENTS_G, "Icons/Menu/ManageResources/requirements_g.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_REQUIREMENTS_H, "Icons/Menu/ManageResources/requirements_h.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_REQUIREMENTS_P, "Icons/Menu/ManageResources/requirements_p.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_EXPORT, "Icons/Menu/ManageResources/export.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_EXPORT_G, "Icons/Menu/ManageResources/export_g.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_EXPORT_H, "Icons/Menu/ManageResources/export_h.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_EXPORT_P, "Icons/Menu/ManageResources/export_p.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_IMPORT, "Icons/Menu/ManageResources/import.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_IMPORT_G, "Icons/Menu/ManageResources/import_g.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_IMPORT_H, "Icons/Menu/ManageResources/import_h.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_IMPORT_P, "Icons/Menu/ManageResources/import_p.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_FIND_UNUSED, "Icons/Menu/ManageResources/find_unused.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_FIND_UNUSED_G, "Icons/Menu/ManageResources/find_unused_g.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_FIND_UNUSED_H, "Icons/Menu/ManageResources/find_unused_h.png", true)    \
ENTRY(IMG_MENU_RESOURCES_ICON_FIND_UNUSED_P, "Icons/Menu/ManageResources/find_unused_p.png", true)    \
/* Custom Extension menu */\
ENTRY(IMG_MENU_CUSTOM_EXTENSIONS_ICON_EXTENSION, "Icons/Menu/CustomExtension/custom_extension.png", true)    \
ENTRY(IMG_MENU_CUSTOM_EXTENSIONS_ICON_EXTENSION_G, "Icons/Menu/CustomExtension/custom_extension_g.png", true)    \
ENTRY(IMG_MENU_CUSTOM_EXTENSIONS_ICON_EXTENSION_H, "Icons/Menu/CustomExtension/custom_extension_h.png", true)    \
ENTRY(IMG_MENU_CUSTOM_EXTENSIONS_ICON_EXTENSION_P, "Icons/Menu/CustomExtension/custom_extension_p.png", true)    \
ENTRY(IMG_MENU_CUSTOM_EXTENSIONS_ICON_FACTORY, "Icons/Menu/CustomExtension/custom_factory.png", true)    \
ENTRY(IMG_MENU_CUSTOM_EXTENSIONS_ICON_FACTORY_G, "Icons/Menu/CustomExtension/custom_factory_g.png", true)    \
ENTRY(IMG_MENU_CUSTOM_EXTENSIONS_ICON_FACTORY_H, "Icons/Menu/CustomExtension/custom_factory_h.png", true)    \
ENTRY(IMG_MENU_CUSTOM_EXTENSIONS_ICON_FACTORY_P, "Icons/Menu/CustomExtension/custom_factory_p.png", true)    \
/* Show Windows */\
ENTRY(IMG_MENU_WINDOW_ICON_ATTRIBUTE, "Icons/Menu/Window/attributes.png", true)    \
ENTRY(IMG_MENU_WINDOW_ICON_ATTRIBUTE_G, "Icons/Menu/Window/attributes_g.png", true)    \
ENTRY(IMG_MENU_WINDOW_ICON_ATTRIBUTE_H, "Icons/Menu/Window/attributes_h.png", true)    \
ENTRY(IMG_MENU_WINDOW_ICON_ATTRIBUTE_P, "Icons/Menu/Window/attributes_p.png", true)    \
ENTRY(IMG_MENU_WINDOW_ICON_CONSOLE, "Icons/Menu/Window/error_console.png", true)    \
ENTRY(IMG_MENU_WINDOW_ICON_CONSOLE_G, "Icons/Menu/Window/error_console_g.png", true)    \
ENTRY(IMG_MENU_WINDOW_ICON_CONSOLE_H, "Icons/Menu/Window/error_console_h.png", true)    \
ENTRY(IMG_MENU_WINDOW_ICON_CONSOLE_P, "Icons/Menu/Window/error_console_p.png", true)    \
ENTRY(IMG_MENU_WINDOW_ICON_CONTROLS, "Icons/Menu/Window/controls.png", true)    \
ENTRY(IMG_MENU_WINDOW_ICON_CONTROLS_G, "Icons/Menu/Window/controls_g.png", true)    \
ENTRY(IMG_MENU_WINDOW_ICON_CONTROLS_H, "Icons/Menu/Window/controls_h.png", true)    \
ENTRY(IMG_MENU_WINDOW_ICON_CONTROLS_P, "Icons/Menu/Window/controls_p.png", true)    \
ENTRY(IMG_MENU_WINDOW_ICON_DIALOG, "Icons/Menu/Window/dialogs.png", true)    \
ENTRY(IMG_MENU_WINDOW_ICON_DIALOG_G, "Icons/Menu/Window/dialogs_g.png", true)    \
ENTRY(IMG_MENU_WINDOW_ICON_DIALOG_H, "Icons/Menu/Window/dialogs_h.png", true)    \
ENTRY(IMG_MENU_WINDOW_ICON_DIALOG_P, "Icons/Menu/Window/dialogs_p.png", true)    \
ENTRY(IMG_MENU_WINDOW_ICON_HIERARCHY, "Icons/Menu/Window/object_hierarchy.png", true)    \
ENTRY(IMG_MENU_WINDOW_ICON_HIERARCHY_G, "Icons/Menu/Window/object_hierarchy_g.png", true)    \
ENTRY(IMG_MENU_WINDOW_ICON_HIERARCHY_H, "Icons/Menu/Window/object_hierarchy_h.png", true)    \
ENTRY(IMG_MENU_WINDOW_ICON_HIERARCHY_P, "Icons/Menu/Window/object_hierarchy_p.png", true)    \
ENTRY(IMG_MENU_WINDOW_ICON_WORKSPACE, "Icons/Menu/Window/workspace.png", true)    \
ENTRY(IMG_MENU_WINDOW_ICON_WORKSPACE_G, "Icons/Menu/Window/workspace_g.png", true)    \
ENTRY(IMG_MENU_WINDOW_ICON_WORKSPACE_H, "Icons/Menu/Window/workspace_h.png", true)    \
ENTRY(IMG_MENU_WINDOW_ICON_WORKSPACE_P, "Icons/Menu/Window/workspace_p.png", true)    \
ENTRY(IMG_MENU_WINDOW_ICON_ANIMATION, "Icons/Menu/Window/animation.png", true)    \
ENTRY(IMG_MENU_WINDOW_ICON_ANIMATION_G, "Icons/Menu/Window/animation_g.png", true)    \
ENTRY(IMG_MENU_WINDOW_ICON_ANIMATION_H, "Icons/Menu/Window/animation_h.png", true)    \
ENTRY(IMG_MENU_WINDOW_ICON_ANIMATION_P, "Icons/Menu/Window/animation_p.png", true)    \
ENTRY(IMG_MENU_WINDOW_ICON_AUTO_ARRANGE, "Icons/Menu/Window/auto_arrange.png", true)    \
ENTRY(IMG_MENU_WINDOW_ICON_AUTO_ARRANGE_G, "Icons/Menu/Window/auto_arrange_g.png", true)    \
ENTRY(IMG_MENU_WINDOW_ICON_AUTO_ARRANGE_H, "Icons/Menu/Window/auto_arrange_h.png", true)    \
ENTRY(IMG_MENU_WINDOW_ICON_AUTO_ARRANGE_P, "Icons/Menu/Window/auto_arrange_p.png", true)    \
/* Help menu */\
ENTRY(IMG_MENU_HELP_ICON_ABOUT, "Icons/Menu/Help/about.png", true)    \
ENTRY(IMG_MENU_HELP_ICON_ABOUT_G, "Icons/Menu/Help/about_g.png", true)    \
ENTRY(IMG_MENU_HELP_ICON_ABOUT_H, "Icons/Menu/Help/about_h.png", true)    \
ENTRY(IMG_MENU_HELP_ICON_ABOUT_P, "Icons/Menu/Help/about_p.png", true)    \
\
/* toolbar */\
ENTRY(IMG_TOOLBAR_SEPARATOR_LINE, "Icons/Toolbar/separator_line.png", true)    \
ENTRY(IMG_TOOLBAR_NEW_PROJECT, "Icons/Toolbar/new_project.png", true)    \
ENTRY(IMG_TOOLBAR_NEW_PROJECT_F, "Icons/Toolbar/new_project.png", true)    \
ENTRY(IMG_TOOLBAR_NEW_PROJECT_G, "Icons/Toolbar/new_project_g.png", true)    \
ENTRY(IMG_TOOLBAR_NEW_PROJECT_H, "Icons/Toolbar/new_project_h.png", true)    \
ENTRY(IMG_TOOLBAR_NEW_PROJECT_P, "Icons/Toolbar/new_project_p.png", true)    \
ENTRY(IMG_TOOLBAR_NEW_DIALOG, "Icons/Toolbar/new_dialog.png", true)    \
ENTRY(IMG_TOOLBAR_NEW_DIALOG_F, "Icons/Toolbar/new_dialog.png", true)    \
ENTRY(IMG_TOOLBAR_NEW_DIALOG_G, "Icons/Toolbar/new_dialog_g.png", true)    \
ENTRY(IMG_TOOLBAR_NEW_DIALOG_H, "Icons/Toolbar/new_dialog_h.png", true)    \
ENTRY(IMG_TOOLBAR_NEW_DIALOG_P, "Icons/Toolbar/new_dialog_p.png", true)    \
ENTRY(IMG_TOOLBAR_OPEN_PROJECT, "Icons/Toolbar/open_project.png", true)    \
ENTRY(IMG_TOOLBAR_OPEN_PROJECT_F, "Icons/Toolbar/open_project.png", true)    \
ENTRY(IMG_TOOLBAR_OPEN_PROJECT_G, "Icons/Toolbar/open_project_g.png", true)    \
ENTRY(IMG_TOOLBAR_OPEN_PROJECT_H, "Icons/Toolbar/open_project_h.png", true)    \
ENTRY(IMG_TOOLBAR_OPEN_PROJECT_P, "Icons/Toolbar/open_project_p.png", true)    \
ENTRY(IMG_TOOLBAR_SAVE_PROJECT, "Icons/Toolbar/save_project.png", true)    \
ENTRY(IMG_TOOLBAR_SAVE_PROJECT_F, "Icons/Toolbar/save_project.png", true)    \
ENTRY(IMG_TOOLBAR_SAVE_PROJECT_G, "Icons/Toolbar/save_project_g.png", true)    \
ENTRY(IMG_TOOLBAR_SAVE_PROJECT_H, "Icons/Toolbar/save_project_h.png", true)    \
ENTRY(IMG_TOOLBAR_SAVE_PROJECT_P, "Icons/Toolbar/save_project_p.png", true)    \
ENTRY(IMG_TOOLBAR_UNDO, "Icons/Toolbar/undo.png", true)    \
ENTRY(IMG_TOOLBAR_UNDO_F, "Icons/Toolbar/undo.png", true)    \
ENTRY(IMG_TOOLBAR_UNDO_G, "Icons/Toolbar/undo_g.png", true)    \
ENTRY(IMG_TOOLBAR_UNDO_H, "Icons/Toolbar/undo_h.png", true)    \
ENTRY(IMG_TOOLBAR_UNDO_P, "Icons/Toolbar/undo_p.png", true)    \
ENTRY(IMG_TOOLBAR_REDO, "Icons/Toolbar/redo.png", true)    \
ENTRY(IMG_TOOLBAR_REDO_F, "Icons/Toolbar/redo.png", true)    \
ENTRY(IMG_TOOLBAR_REDO_G, "Icons/Toolbar/redo_g.png", true)    \
ENTRY(IMG_TOOLBAR_REDO_H, "Icons/Toolbar/redo_h.png", true)    \
ENTRY(IMG_TOOLBAR_REDO_P, "Icons/Toolbar/redo_p.png", true)    \
/* edit */ \
ENTRY(IMG_TOOLBAR_COPY, "Icons/Toolbar/copy.png", true)    \
ENTRY(IMG_TOOLBAR_COPY_F, "Icons/Toolbar/copy.png", true)    \
ENTRY(IMG_TOOLBAR_COPY_G, "Icons/Toolbar/copy_g.png", true)    \
ENTRY(IMG_TOOLBAR_COPY_H, "Icons/Toolbar/copy_h.png", true)    \
ENTRY(IMG_TOOLBAR_COPY_P, "Icons/Toolbar/copy_p.png", true)    \
ENTRY(IMG_TOOLBAR_PASTE, "Icons/Toolbar/paste.png", true)    \
ENTRY(IMG_TOOLBAR_PASTE_F, "Icons/Toolbar/paste.png", true)    \
ENTRY(IMG_TOOLBAR_PASTE_G, "Icons/Toolbar/paste_g.png", true)    \
ENTRY(IMG_TOOLBAR_PASTE_H, "Icons/Toolbar/paste_h.png", true)    \
ENTRY(IMG_TOOLBAR_PASTE_P, "Icons/Toolbar/paste_p.png", true)    \
ENTRY(IMG_TOOLBAR_CUT, "Icons/Toolbar/cut.png", true)    \
ENTRY(IMG_TOOLBAR_CUT_F, "Icons/Toolbar/cut.png", true)    \
ENTRY(IMG_TOOLBAR_CUT_G, "Icons/Toolbar/cut_g.png", true)    \
ENTRY(IMG_TOOLBAR_CUT_H, "Icons/Toolbar/cut_h.png", true)    \
ENTRY(IMG_TOOLBAR_CUT_P, "Icons/Toolbar/cut_p.png", true)    \
ENTRY(IMG_TOOLBAR_DELETE, "Icons/Toolbar/delete.png", true)    \
ENTRY(IMG_TOOLBAR_DELETE_F, "Icons/Toolbar/delete.png", true)    \
ENTRY(IMG_TOOLBAR_DELETE_G, "Icons/Toolbar/delete_g.png", true)    \
ENTRY(IMG_TOOLBAR_DELETE_H, "Icons/Toolbar/delete_h.png", true)    \
ENTRY(IMG_TOOLBAR_DELETE_P, "Icons/Toolbar/delete_p.png", true)    \
/* arrangement */ \
ENTRY(IMG_TOOLBAR_RAISE_OBJECT, "Icons/Toolbar/object_raise.png", true)    \
ENTRY(IMG_TOOLBAR_RAISE_OBJECT_F, "Icons/Toolbar/object_raise.png", true)    \
ENTRY(IMG_TOOLBAR_RAISE_OBJECT_G, "Icons/Toolbar/object_raise_g.png", true)    \
ENTRY(IMG_TOOLBAR_RAISE_OBJECT_H, "Icons/Toolbar/object_raise_h.png", true)    \
ENTRY(IMG_TOOLBAR_RAISE_OBJECT_P, "Icons/Toolbar/object_raise_p.png", true)    \
ENTRY(IMG_TOOLBAR_LOWER_OBJECT, "Icons/Toolbar/object_lower.png", true)    \
ENTRY(IMG_TOOLBAR_LOWER_OBJECT_F, "Icons/Toolbar/object_lower.png", true)    \
ENTRY(IMG_TOOLBAR_LOWER_OBJECT_G, "Icons/Toolbar/object_lower_g.png", true)    \
ENTRY(IMG_TOOLBAR_LOWER_OBJECT_H, "Icons/Toolbar/object_lower_h.png", true)    \
ENTRY(IMG_TOOLBAR_LOWER_OBJECT_P, "Icons/Toolbar/object_lower_p.png", true)    \
ENTRY(IMG_TOOLBAR_FOREGROUND, "Icons/Toolbar/object_foreground.png", true)    \
ENTRY(IMG_TOOLBAR_FOREGROUND_F, "Icons/Toolbar/object_foreground.png", true)    \
ENTRY(IMG_TOOLBAR_FOREGROUND_G, "Icons/Toolbar/object_foreground_g.png", true)    \
ENTRY(IMG_TOOLBAR_FOREGROUND_H, "Icons/Toolbar/object_foreground_h.png", true)    \
ENTRY(IMG_TOOLBAR_FOREGROUND_P, "Icons/Toolbar/object_foreground_p.png", true)    \
ENTRY(IMG_TOOLBAR_BACKGROUND, "Icons/Toolbar/object_background.png", true)    \
ENTRY(IMG_TOOLBAR_BACKGROUND_F, "Icons/Toolbar/object_background.png", true)    \
ENTRY(IMG_TOOLBAR_BACKGROUND_G, "Icons/Toolbar/object_background_g.png", true)    \
ENTRY(IMG_TOOLBAR_BACKGROUND_H, "Icons/Toolbar/object_background_h.png", true)    \
ENTRY(IMG_TOOLBAR_BACKGROUND_P, "Icons/Toolbar/object_background_p.png", true)    \
/* alignment */ \
ENTRY(IMG_TOOLBAR_ALIGN_LEFT, "Icons/Toolbar/object_align_left.png", true)    \
ENTRY(IMG_TOOLBAR_ALIGN_LEFT_F, "Icons/Toolbar/object_align_left.png", true)    \
ENTRY(IMG_TOOLBAR_ALIGN_LEFT_G, "Icons/Toolbar/object_align_left_g.png", true)    \
ENTRY(IMG_TOOLBAR_ALIGN_LEFT_H, "Icons/Toolbar/object_align_left_h.png", true)    \
ENTRY(IMG_TOOLBAR_ALIGN_LEFT_P, "Icons/Toolbar/object_align_left_p.png", true)    \
ENTRY(IMG_TOOLBAR_ALIGN_RIGHT, "Icons/Toolbar/object_align_right.png", true)    \
ENTRY(IMG_TOOLBAR_ALIGN_RIGHT_F, "Icons/Toolbar/object_align_right.png", true)    \
ENTRY(IMG_TOOLBAR_ALIGN_RIGHT_G, "Icons/Toolbar/object_align_right_g.png", true)    \
ENTRY(IMG_TOOLBAR_ALIGN_RIGHT_H, "Icons/Toolbar/object_align_right_h.png", true)    \
ENTRY(IMG_TOOLBAR_ALIGN_RIGHT_P, "Icons/Toolbar/object_align_right_p.png", true)    \
ENTRY(IMG_TOOLBAR_ALIGN_TOP, "Icons/Toolbar/object_align_top.png", true)    \
ENTRY(IMG_TOOLBAR_ALIGN_TOP_F, "Icons/Toolbar/object_align_top.png", true)    \
ENTRY(IMG_TOOLBAR_ALIGN_TOP_G, "Icons/Toolbar/object_align_top_g.png", true)    \
ENTRY(IMG_TOOLBAR_ALIGN_TOP_H, "Icons/Toolbar/object_align_top_h.png", true)    \
ENTRY(IMG_TOOLBAR_ALIGN_TOP_P, "Icons/Toolbar/object_align_top_p.png", true)    \
ENTRY(IMG_TOOLBAR_ALIGN_BOTTOM, "Icons/Toolbar/object_align_bottom.png", true)    \
ENTRY(IMG_TOOLBAR_ALIGN_BOTTOM_F, "Icons/Toolbar/object_align_bottom.png", true)    \
ENTRY(IMG_TOOLBAR_ALIGN_BOTTOM_G, "Icons/Toolbar/object_align_bottom_g.png", true)    \
ENTRY(IMG_TOOLBAR_ALIGN_BOTTOM_H, "Icons/Toolbar/object_align_bottom_h.png", true)    \
ENTRY(IMG_TOOLBAR_ALIGN_BOTTOM_P, "Icons/Toolbar/object_align_bottom_p.png", true)    \
ENTRY(IMG_TOOLBAR_CENTER_HOR, "Icons/Toolbar/object_align_horizontal.png", true)    \
ENTRY(IMG_TOOLBAR_CENTER_HOR_F, "Icons/Toolbar/object_align_horizontal.png", true)    \
ENTRY(IMG_TOOLBAR_CENTER_HOR_G, "Icons/Toolbar/object_align_horizontal_g.png", true)    \
ENTRY(IMG_TOOLBAR_CENTER_HOR_H, "Icons/Toolbar/object_align_horizontal_h.png", true)    \
ENTRY(IMG_TOOLBAR_CENTER_HOR_P, "Icons/Toolbar/object_align_horizontal_p.png", true)    \
ENTRY(IMG_TOOLBAR_CENTER_VER, "Icons/Toolbar/object_align_vertical.png", true)    \
ENTRY(IMG_TOOLBAR_CENTER_VER_F, "Icons/Toolbar/object_align_vertical.png", true)    \
ENTRY(IMG_TOOLBAR_CENTER_VER_G, "Icons/Toolbar/object_align_vertical_g.png", true)    \
ENTRY(IMG_TOOLBAR_CENTER_VER_H, "Icons/Toolbar/object_align_vertical_h.png", true)    \
ENTRY(IMG_TOOLBAR_CENTER_VER_P, "Icons/Toolbar/object_align_vertical_p.png", true)    \
ENTRY(IMG_TOOLBAR_DISTRIBUTE_HOR, "Icons/Toolbar/object_distribute_horizontal.png", true)    \
ENTRY(IMG_TOOLBAR_DISTRIBUTE_HOR_F, "Icons/Toolbar/object_distribute_horizontal.png", true)    \
ENTRY(IMG_TOOLBAR_DISTRIBUTE_HOR_G, "Icons/Toolbar/object_distribute_horizontal_g.png", true)    \
ENTRY(IMG_TOOLBAR_DISTRIBUTE_HOR_H, "Icons/Toolbar/object_distribute_horizontal_h.png", true)    \
ENTRY(IMG_TOOLBAR_DISTRIBUTE_HOR_P, "Icons/Toolbar/object_distribute_horizontal_p.png", true)    \
ENTRY(IMG_TOOLBAR_DISTRIBUTE_VER, "Icons/Toolbar/object_distribute_vertical.png", true)    \
ENTRY(IMG_TOOLBAR_DISTRIBUTE_VER_F, "Icons/Toolbar/object_distribute_vertical.png", true)    \
ENTRY(IMG_TOOLBAR_DISTRIBUTE_VER_G, "Icons/Toolbar/object_distribute_vertical_g.png", true)    \
ENTRY(IMG_TOOLBAR_DISTRIBUTE_VER_H, "Icons/Toolbar/object_distribute_vertical_h.png", true)    \
ENTRY(IMG_TOOLBAR_DISTRIBUTE_VER_P, "Icons/Toolbar/object_distribute_vertical_p.png", true)    \
/* sizes */ \
ENTRY(IMG_TOOLBAR_UNIFY_SIZE, "Icons/Toolbar/resize_unify.png", true)    \
ENTRY(IMG_TOOLBAR_UNIFY_SIZE_F, "Icons/Toolbar/resize_unify.png", true)    \
ENTRY(IMG_TOOLBAR_UNIFY_SIZE_G, "Icons/Toolbar/resize_unify_g.png", true)    \
ENTRY(IMG_TOOLBAR_UNIFY_SIZE_H, "Icons/Toolbar/resize_unify_h.png", true)    \
ENTRY(IMG_TOOLBAR_UNIFY_SIZE_P, "Icons/Toolbar/resize_unify_p.png", true)    \
ENTRY(IMG_TOOLBAR_RESIZE_TO_IMAGE, "Icons/Toolbar/resize_original.png", true)    \
ENTRY(IMG_TOOLBAR_RESIZE_TO_IMAGE_F, "Icons/Toolbar/resize_original.png", true)    \
ENTRY(IMG_TOOLBAR_RESIZE_TO_IMAGE_G, "Icons/Toolbar/resize_original_g.png", true)    \
ENTRY(IMG_TOOLBAR_RESIZE_TO_IMAGE_H, "Icons/Toolbar/resize_original_h.png", true)    \
ENTRY(IMG_TOOLBAR_RESIZE_TO_IMAGE_P, "Icons/Toolbar/resize_original_p.png", true)    \
ENTRY(IMG_TOOLBAR_GROUP_OBJECTS, "Icons/Toolbar/object_group.png", true)    \
ENTRY(IMG_TOOLBAR_GROUP_OBJECTS_F, "Icons/Toolbar/object_group.png", true)    \
ENTRY(IMG_TOOLBAR_GROUP_OBJECTS_G, "Icons/Toolbar/object_group_g.png", true)    \
ENTRY(IMG_TOOLBAR_GROUP_OBJECTS_H, "Icons/Toolbar/object_group_h.png", true)    \
ENTRY(IMG_TOOLBAR_GROUP_OBJECTS_P, "Icons/Toolbar/object_group_p.png", true)    \
ENTRY(IMG_TOOLBAR_UNGROUP_OBJECTS, "Icons/Toolbar/object_ungroup.png", true)    \
ENTRY(IMG_TOOLBAR_UNGROUP_OBJECTS_F, "Icons/Toolbar/object_ungroup.png", true)    \
ENTRY(IMG_TOOLBAR_UNGROUP_OBJECTS_G, "Icons/Toolbar/object_ungroup_g.png", true)    \
ENTRY(IMG_TOOLBAR_UNGROUP_OBJECTS_H, "Icons/Toolbar/object_ungroup_h.png", true)    \
ENTRY(IMG_TOOLBAR_UNGROUP_OBJECTS_P, "Icons/Toolbar/object_ungroup_p.png", true)    \
/* global settings */ \
ENTRY(IMG_TOOLBAR_TOGGLE_GUIDELINES, "Icons/Toolbar/toggle_guidelines.png", true)    \
ENTRY(IMG_TOOLBAR_TOGGLE_GUIDELINES_F, "Icons/Toolbar/toggle_guidelines.png", true)    \
ENTRY(IMG_TOOLBAR_TOGGLE_GUIDELINES_G, "Icons/Toolbar/toggle_guidelines_g.png", true)    \
ENTRY(IMG_TOOLBAR_TOGGLE_GUIDELINES_H, "Icons/Toolbar/toggle_guidelines_h.png", true)    \
ENTRY(IMG_TOOLBAR_TOGGLE_GUIDELINES_P, "Icons/Toolbar/toggle_guidelines_p.png", true)    \
ENTRY(IMG_TOOLBAR_TOGGLE_GUIDELINES_S, "Icons/Toolbar/toggle_guidelines_s.png", true)    \
ENTRY(IMG_TOOLBAR_SNAP_GUIDELINES, "Icons/Toolbar/snap_guidelines.png", true)    \
ENTRY(IMG_TOOLBAR_SNAP_GUIDELINES_F, "Icons/Toolbar/snap_guidelines.png", true)    \
ENTRY(IMG_TOOLBAR_SNAP_GUIDELINES_G, "Icons/Toolbar/snap_guidelines_g.png", true)    \
ENTRY(IMG_TOOLBAR_SNAP_GUIDELINES_H, "Icons/Toolbar/snap_guidelines_h.png", true)    \
ENTRY(IMG_TOOLBAR_SNAP_GUIDELINES_P, "Icons/Toolbar/snap_guidelines_p.png", true)    \
ENTRY(IMG_TOOLBAR_SNAP_GUIDELINES_S, "Icons/Toolbar/snap_guidelines_s.png", true)    \
ENTRY(IMG_TOOLBAR_TOGGLE_GRID, "Icons/Toolbar/toggle_grid.png", true)    \
ENTRY(IMG_TOOLBAR_TOGGLE_GRID_F, "Icons/Toolbar/toggle_grid.png", true)    \
ENTRY(IMG_TOOLBAR_TOGGLE_GRID_G, "Icons/Toolbar/toggle_grid_g.png", true)    \
ENTRY(IMG_TOOLBAR_TOGGLE_GRID_H, "Icons/Toolbar/toggle_grid_h.png", true)    \
ENTRY(IMG_TOOLBAR_TOGGLE_GRID_P, "Icons/Toolbar/toggle_grid_p.png", true)    \
ENTRY(IMG_TOOLBAR_TOGGLE_GRID_S, "Icons/Toolbar/toggle_grid_s.png", true)    \
ENTRY(IMG_TOOLBAR_TOGGLE_COORDINATES, "Icons/Toolbar/toggle_coordinates.png", true)    \
ENTRY(IMG_TOOLBAR_TOGGLE_COORDINATES_F, "Icons/Toolbar/toggle_coordinates.png", true)    \
ENTRY(IMG_TOOLBAR_TOGGLE_COORDINATES_G, "Icons/Toolbar/toggle_coordinates_g.png", true)    \
ENTRY(IMG_TOOLBAR_TOGGLE_COORDINATES_H, "Icons/Toolbar/toggle_coordinates_h.png", true)    \
ENTRY(IMG_TOOLBAR_TOGGLE_COORDINATES_P, "Icons/Toolbar/toggle_coordinates_p.png", true)    \
ENTRY(IMG_TOOLBAR_TOGGLE_COORDINATES_S, "Icons/Toolbar/toggle_coordinates_s.png", true)    \
/* settings/run */ \
ENTRY(IMG_TOOLBAR_SETTINGS, "Icons/Toolbar/settings.png", true)    \
ENTRY(IMG_TOOLBAR_SETTINGS_F, "Icons/Toolbar/settings.png", true)    \
ENTRY(IMG_TOOLBAR_SETTINGS_G, "Icons/Toolbar/settings_g.png", true)    \
ENTRY(IMG_TOOLBAR_SETTINGS_H, "Icons/Toolbar/settings_h.png", true)    \
ENTRY(IMG_TOOLBAR_SETTINGS_P, "Icons/Toolbar/settings_p.png", true)    \
ENTRY(IMG_TOOLBAR_RUN, "Icons/Toolbar/run.png", true)    \
ENTRY(IMG_TOOLBAR_RUN_F, "Icons/Toolbar/run.png", true)    \
ENTRY(IMG_TOOLBAR_RUN_G, "Icons/Toolbar/run_g.png", true)    \
ENTRY(IMG_TOOLBAR_RUN_H, "Icons/Toolbar/run_h.png", true)    \
ENTRY(IMG_TOOLBAR_RUN_P, "Icons/Toolbar/run_p.png", true)    \
\
/* selection */\
ENTRY(IMG_SEL_HANDLE_TOP_LEFT, "Icons/Workspace/selection/handle_top-left.png", true)    \
ENTRY(IMG_SEL_HANDLE_TOP_RIGHT, "Icons/Workspace/selection/handle_top-right.png", true)    \
ENTRY(IMG_SEL_HANDLE_BOTTOM_LEFT, "Icons/Workspace/selection/handle_bottom-left.png", true)    \
ENTRY(IMG_SEL_HANDLE_BOTTOM_RIGHT, "Icons/Workspace/selection/handle_bottom-right.png", true)    \
ENTRY(IMG_SEL_HANDLE_HORIZONTAL, "Icons/Workspace/selection/handle_horizontal.png", true)    \
ENTRY(IMG_SEL_HANDLE_VERTICAL, "Icons/Workspace/selection/handle_vertical.png", true)    \
    \
/* Window images */\
ENTRY(IMG_WINDOW_CLOSE, "Window/WindowButtonClose.png", true)    \
ENTRY(IMG_WINDOW_CLOSE_HI, "Window/WindowButtonClose_h.png", true)    \
ENTRY(IMG_WINDOW_CLOSE_PRESSED, "Window/WindowButtonClose_p.png", true)    \
ENTRY(IMG_WINDOW_CLOSE_GRAYED_OUT, "Window/WindowButtonClose.png", true)    \
ENTRY(IMG_WINDOW_MAXIMIZE, "Window/WindowButtonMax.png", true)    \
ENTRY(IMG_WINDOW_MAXIMIZE_HI, "Window/WindowButtonMax_h.png", true)    \
ENTRY(IMG_WINDOW_MAXIMIZE_PRESSED, "Window/WindowButtonMax_p.png", true)    \
ENTRY(IMG_WINDOW_MINIMIZE, "Window/WindowButtonMin.png", true)    \
ENTRY(IMG_WINDOW_MINIMIZE_HI, "Window/WindowButtonMin_h.png", true)    \
ENTRY(IMG_WINDOW_MINIMIZE_PRESSED, "Window/WindowButtonMin_p.png", true)    \
ENTRY(IMG_WINDOW_RESTORE, "Window/WindowButtonRestore.png", true)    \
ENTRY(IMG_WINDOW_RESTORE_HI, "Window/WindowButtonRestore_h.png", true)    \
ENTRY(IMG_WINDOW_RESTORE_PRESSED, "Window/WindowButtonRestore_p.png", true)    \
ENTRY(IMG_WINDOW_RESTORE_GRAYED_OUT, "Window/WindowButtonRestore.png", true)    \
ENTRY(IMG_WINDOW_BACKGROUND_BORDER, "Window/WindowBackgroundBorder.png", true)    \
ENTRY(IMG_WINDOW_BACKGROUND_SIZEABLE, "Window/WindowBackgroundBorderSizeable.png", true)    \
ENTRY(IMG_WINDOWBAR_BACKGROUND, "Window/WindowBarBackground.png", true)    \
/* window scrollbar */\
ENTRY(IMG_WINDOW_SLIDER_HOR, "Common/Scrollbar/sliders_bar_standard_535353.png", true)    \
ENTRY(IMG_WINDOW_SLIDER_HOR_P, "Common/Scrollbar/sliders_bar_pressed_282828__10px.png", true)    \
ENTRY(IMG_WINDOW_SLIDER_VER, "Common/Scrollbar/sliders_bar_standard_535353.png", true)    \
ENTRY(IMG_WINDOW_SLIDER_VER_P, "Common/Scrollbar/sliders_bar_pressed_282828__10px.png", true)    \
ENTRY(IMG_WINDOW_SLIDER_BG_HOR, "Common/Scrollbar/sliders_background_404040.png", true)    \
ENTRY(IMG_WINDOW_SLIDER_BG_VER, "Common/Scrollbar/sliders_background_404040.png", true)    \
ENTRY(IMG_WINDOW_SCROLLBUTTON_UP, "Common/Scrollbar/scrollbar_arrow_up.png", true)    \
ENTRY(IMG_WINDOW_SCROLLBUTTON_UP_H, "Common/Scrollbar/scrollbar_arrow_up_p.png", true)    \
ENTRY(IMG_WINDOW_SCROLLBUTTON_UP_P, "Common/Scrollbar/scrollbar_arrow_up_p.png", true)    \
ENTRY(IMG_WINDOW_SCROLLBUTTON_UP_G, "Common/Scrollbar/scrollbar_arrow_up.png", true)    \
ENTRY(IMG_WINDOW_SCROLLBUTTON_DOWN, "Common/Scrollbar/scrollbar_arrow_down.png", true)    \
ENTRY(IMG_WINDOW_SCROLLBUTTON_DOWN_H, "Common/Scrollbar/scrollbar_arrow_down_p.png", true)    \
ENTRY(IMG_WINDOW_SCROLLBUTTON_DOWN_P, "Common/Scrollbar/scrollbar_arrow_down_p.png", true)    \
ENTRY(IMG_WINDOW_SCROLLBUTTON_DOWN_G, "Common/Scrollbar/scrollbar_arrow_down.png", true)    \
ENTRY(IMG_WINDOW_SCROLLBUTTON_LEFT, "Common/Scrollbar/scrollbar_arrow_left.png", true)    \
ENTRY(IMG_WINDOW_SCROLLBUTTON_LEFT_H, "Common/Scrollbar/scrollbar_arrow_left_p.png", true)    \
ENTRY(IMG_WINDOW_SCROLLBUTTON_LEFT_P, "Common/Scrollbar/scrollbar_arrow_left_p.png", true)    \
ENTRY(IMG_WINDOW_SCROLLBUTTON_LEFT_G, "Common/Scrollbar/scrollbar_arrow_left.png", true)    \
ENTRY(IMG_WINDOW_SCROLLBUTTON_RIGHT, "Common/Scrollbar/scrollbar_arrow_right.png", true)    \
ENTRY(IMG_WINDOW_SCROLLBUTTON_RIGHT_H, "Common/Scrollbar/scrollbar_arrow_right_p.png", true)    \
ENTRY(IMG_WINDOW_SCROLLBUTTON_RIGHT_P, "Common/Scrollbar/scrollbar_arrow_right_p.png", true)    \
ENTRY(IMG_WINDOW_SCROLLBUTTON_RIGHT_G, "Common/Scrollbar/scrollbar_arrow_right.png", true)    \
/* icons */\
/* object hierarchy */\
ENTRY(IMG_ICON_DELETE, "Icons/ObjectHierarchy/delete.png", true)    \
/* message-box */ \
ENTRY(IMG_ICON_MSGBOX_ATTENTION, "Icons/MessageBox/warning_shield.png", true)    \
ENTRY(IMG_ICON_MSGBOX_ERROR, "Icons/MessageBox/x_shield.png", true)    \
ENTRY(IMG_ICON_MSGBOX_QUESTION, "Icons/MessageBox/question_shield.png", true)    \
/* dialog-list */ \
ENTRY(IMG_ICON_DIALOGLIST_NEW_DIALOG, "Icons/DialogList/add_dialog.png", true)    \
ENTRY(IMG_ICON_DIALOGLIST_NEW_DIALOG_HI, "Icons/DialogList/add_dialog_h.png", true)    \
ENTRY(IMG_ICON_DIALOGLIST_NEW_DIALOG_PRESSED, "Icons/DialogList/add_dialog_p.png", true)    \
ENTRY(IMG_ICON_DIALOGLIST_NEW_DIALOG_FOCUSSED, "Icons/DialogList/add_dialog.png", true)    \
ENTRY(IMG_ICON_DIALOGLIST_NEW_DIALOG_GRAYED, "Icons/DialogList/add_dialog_g.png", true)    \
ENTRY(IMG_ICON_DIALOGLIST_DELETE, "Icons/DialogList/delete_dialog.png", true)    \
ENTRY(IMG_ICON_DIALOGLIST_DELETE_HI, "Icons/DialogList/delete_dialog_h.png", true)    \
ENTRY(IMG_ICON_DIALOGLIST_DELETE_PRESSED, "Icons/DialogList/delete_dialog_p.png", true)    \
ENTRY(IMG_ICON_DIALOGLIST_DELETE_FOCUSSED, "Icons/DialogList/delete_dialog.png", true)    \
ENTRY(IMG_ICON_DIALOGLIST_DELETE_GRAYED, "Icons/DialogList/delete_dialog_g.png", true)    \
ENTRY(IMG_ICON_DIALOGLIST_START, "Icons/DialogList/start_dialog.png", true)    \
ENTRY(IMG_ICON_DIALOGLIST_START_HI, "Icons/DialogList/start_dialog_h.png", true)    \
ENTRY(IMG_ICON_DIALOGLIST_START_PRESSED, "Icons/DialogList/start_dialog_p.png", true)    \
ENTRY(IMG_ICON_DIALOGLIST_START_FOCUSSED, "Icons/DialogList/start_dialog.png", true)    \
ENTRY(IMG_ICON_DIALOGLIST_START_GRAYED, "Icons/DialogList/start_dialog_g.png", true)    \
ENTRY(IMG_ICON_DIALOGLIST_SHOW_THUMBS, "Icons/DialogList/toggle_thumbs.png", true)    \
ENTRY(IMG_ICON_DIALOGLIST_SHOW_THUMBS_HI, "Icons/DialogList/toggle_thumbs_h.png", true)    \
ENTRY(IMG_ICON_DIALOGLIST_SHOW_THUMBS_PRESSED, "Icons/DialogList/toggle_thumbs_p.png", true)    \
ENTRY(IMG_ICON_DIALOGLIST_SHOW_THUMBS_FOCUSSED, "Icons/DialogList/toggle_thumbs.png", true)    \
ENTRY(IMG_ICON_DIALOGLIST_SHOW_THUMBS_GRAYED, "Icons/DialogList/toggle_thumbs_g.png", true)    \
ENTRY(IMG_ICON_DIALOGLIST_SHOW_NAMES, "Icons/DialogList/toggle_names.png", true)    \
ENTRY(IMG_ICON_DIALOGLIST_SHOW_NAMES_HI, "Icons/DialogList/toggle_names_h.png", true)    \
ENTRY(IMG_ICON_DIALOGLIST_SHOW_NAMES_PRESSED, "Icons/DialogList/toggle_names_p.png", true)    \
ENTRY(IMG_ICON_DIALOGLIST_SHOW_NAMES_FOCUSSED, "Icons/DialogList/toggle_names.png", true)    \
ENTRY(IMG_ICON_DIALOGLIST_SHOW_NAMES_GRAYED, "Icons/DialogList/toggle_names_g.png", true)    \
\
/* object-hierarchy */ \
ENTRY(IMG_ICON_HIERARCHY_EYE, "Icons/ObjectHierarchy/eye.png", true) \
ENTRY(IMG_ICON_HIERARCHY_COMMAND, "Icons/ObjectHierarchy/command.png", true) \
ENTRY(IMG_ICON_HIERARCHY_BEHAVIOUR, "Icons/ObjectHierarchy/behaviour.png", true) \
ENTRY(IMG_ICON_HIERARCHY_LAYOUTER, "Icons/ObjectHierarchy/layouter.png", true) \
ENTRY(IMG_ICON_HIERARCHY_UP, "Icons/ObjectHierarchy/object_up.png", true)    \
ENTRY(IMG_ICON_HIERARCHY_UP_HI, "Icons/ObjectHierarchy/object_up_h.png", true)    \
ENTRY(IMG_ICON_HIERARCHY_UP_PRESSED, "Icons/ObjectHierarchy/object_up_p.png", true)    \
ENTRY(IMG_ICON_HIERARCHY_UP_GRAYED, "Icons/ObjectHierarchy/object_up_g.png", true)    \
ENTRY(IMG_ICON_HIERARCHY_DOWN, "Icons/ObjectHierarchy/object_down.png", true)    \
ENTRY(IMG_ICON_HIERARCHY_DOWN_HI, "Icons/ObjectHierarchy/object_down_h.png", true)    \
ENTRY(IMG_ICON_HIERARCHY_DOWN_PRESSED, "Icons/ObjectHierarchy/object_down_p.png", true)    \
ENTRY(IMG_ICON_HIERARCHY_DOWN_GRAYED, "Icons/ObjectHierarchy/object_down_g.png", true)    \
ENTRY(IMG_ICON_HIERARCHY_SHOW_FULL_DIALOG, "Icons/ObjectHierarchy/focus_out.png", true)    \
ENTRY(IMG_ICON_HIERARCHY_SHOW_FULL_DIALOG_HI, "Icons/ObjectHierarchy/focus_out_h.png", true)    \
ENTRY(IMG_ICON_HIERARCHY_SHOW_FULL_DIALOG_PRESSED, "Icons/ObjectHierarchy/focus_out_p.png", true)    \
ENTRY(IMG_ICON_HIERARCHY_SHOW_FULL_DIALOG_GRAYED, "Icons/ObjectHierarchy/focus_out_g.png", true)    \
ENTRY(IMG_ICON_HIERARCHY_SHOW_ZOOMED_DIALOG, "Icons/ObjectHierarchy/focus_in.png", true)    \
ENTRY(IMG_ICON_HIERARCHY_SHOW_ZOOMED_DIALOG_HI, "Icons/ObjectHierarchy/focus_in_h.png", true)    \
ENTRY(IMG_ICON_HIERARCHY_SHOW_ZOOMED_DIALOG_PRESSED, "Icons/ObjectHierarchy/focus_in_p.png", true)    \
ENTRY(IMG_ICON_HIERARCHY_SHOW_ZOOMED_DIALOG_GRAYED, "Icons/ObjectHierarchy/focus_in_g.png", true)    \
ENTRY(IMG_ICON_HIERARCHY_COLLAPSE, "Icons/ObjectHierarchy/collapse.png", true) \
ENTRY(IMG_ICON_HIERARCHY_COLLAPSE_HI, "Icons/ObjectHierarchy/collapse_h.png", true) \
ENTRY(IMG_ICON_HIERARCHY_COLLAPSE_PRESSED, "Icons/ObjectHierarchy/collapse_p.png", true) \
ENTRY(IMG_ICON_HIERARCHY_COLLAPSE_GRAYED, "Icons/ObjectHierarchy/collapse_g.png", true) \
ENTRY(IMG_ICON_HIERARCHY_EXPAND, "Icons/ObjectHierarchy/expand.png", true) \
ENTRY(IMG_ICON_HIERARCHY_EXPAND_HI, "Icons/ObjectHierarchy/expand_h.png", true) \
ENTRY(IMG_ICON_HIERARCHY_EXPAND_PRESSED, "Icons/ObjectHierarchy/expand_p.png", true) \
ENTRY(IMG_ICON_HIERARCHY_EXPAND_GRAYED, "Icons/ObjectHierarchy/expand_g.png", true) \
ENTRY(IMG_ICON_HIERARCHY_SHOW_SIDE, "Icons/ObjectHierarchy/show_side.png", true) \
ENTRY(IMG_ICON_HIERARCHY_SHOW_SIDE_HI, "Icons/ObjectHierarchy/show_side_h.png", true) \
ENTRY(IMG_ICON_HIERARCHY_SHOW_SIDE_PRESSED, "Icons/ObjectHierarchy/show_side_p.png", true) \
ENTRY(IMG_ICON_HIERARCHY_SHOW_SIDE_GRAYED, "Icons/ObjectHierarchy/show_side_g.png", true) \
ENTRY(IMG_ICON_HIERARCHY_HIDE_SIDE, "Icons/ObjectHierarchy/hide_side.png", true) \
ENTRY(IMG_ICON_HIERARCHY_HIDE_SIDE_HI, "Icons/ObjectHierarchy/hide_side_h.png", true) \
ENTRY(IMG_ICON_HIERARCHY_HIDE_SIDE_PRESSED, "Icons/ObjectHierarchy/hide_side_p.png", true) \
ENTRY(IMG_ICON_HIERARCHY_HIDE_SIDE_GRAYED, "Icons/ObjectHierarchy/hide_side_g.png", true) \
/* file dialog */\
ENTRY(IMG_FILEDIALOG_BACK_BT_FOCUSSED, "FileDlg/icon_back_h.png", true)    \
ENTRY(IMG_FILEDIALOG_BACK_BT_STANDARD, "FileDlg/icon_back.png", true)    \
ENTRY(IMG_FILEDIALOG_BACK_BT_PRESSED, "FileDlg/icon_back_p.png", true)    \
ENTRY(IMG_FILEDIALOG_BACK_BT_GRAYEDOUT, "FileDlg/icon_back_g.png", true)    \
ENTRY(IMG_FILEDIALOG_UP_BT_FOCUSSED, "FileDlg/icon_up_h.png", true)    \
ENTRY(IMG_FILEDIALOG_UP_BT_STANDARD, "FileDlg/icon_up.png", true)    \
ENTRY(IMG_FILEDIALOG_UP_BT_GRAYEDOUT, "FileDlg/icon_up_g.png", true)    \
ENTRY(IMG_FILEDIALOG_UP_BT_PRESSED, "FileDlg/icon_up_p.png", true)    \
ENTRY(IMG_FILEDIALOG_DELETE_BT_GRAYEDOUT, "FileDlg/icon_delete_g.png", true)    \
ENTRY(IMG_FILEDIALOG_DELETE_BT_STANDARD, "FileDlg/icon_delete.png", true)    \
ENTRY(IMG_FILEDIALOG_DELETE_BT_FOCUSSED, "FileDlg/icon_delete_h.png", true)    \
ENTRY(IMG_FILEDIALOG_DELETE_BT_PRESSED, "FileDlg/icon_delete_p.png", true)    \
ENTRY(IMG_FILEDIALOG_CREATE_BT_GRAYEDOUT, "FileDlg/icon_create_g.png", true)    \
ENTRY(IMG_FILEDIALOG_CREATE_BT_STANDARD, "FileDlg/icon_create.png", true)    \
ENTRY(IMG_FILEDIALOG_CREATE_BT_FOCUSSED, "FileDlg/icon_create_h.png", true)    \
ENTRY(IMG_FILEDIALOG_CREATE_BT_PRESSED, "FileDlg/icon_create_p.png", true)    \
ENTRY(IMG_FILEDIALOG_DESKTOP_BT_STANDARD, "FileDlg/icon_desktop.png", true)    \
ENTRY(IMG_FILEDIALOG_MYPROJECTS_BT_STANDARD, "FileDlg/icon_myprojects.png", true)    \
ENTRY(IMG_FILEDIALOG_MYCOMPUTER_BT_STANDARD, "FileDlg/icon_mycomputer.png", true)    \
ENTRY(IMG_FILEDIALOG_FILE_STANDARD_ICON, "FileDlg/icon_file.png", true)    \
ENTRY(IMG_FILEDIALOG_FILE_SELECTED_ICON, "FileDlg/icon_file.png", true)    \
ENTRY(IMG_FILEDIALOG_DIR_STANDARD_ICON, "FileDlg/icon_directory.png", true)    \
ENTRY(IMG_FILEDIALOG_DIR_SELECTED_ICON, "FileDlg/icon_directory.png", true)    \
ENTRY(IMG_FILEDIALOG_DRIVE_STANDARD_ICON, "FileDlg/icon_drive.png", true)    \
ENTRY(IMG_FILEDIALOG_DRIVE_SELECTED_ICON, "FileDlg/icon_drive.png", true)    \
/* dialog window */\
ENTRY(IMG_ICON_SOUND, "Icons/Toolbar/redo.png", true)    \
ENTRY(IMG_ICON_SOUND_F, "Icons/Toolbar/redo.png", true)    \
ENTRY(IMG_ICON_SOUND_G, "Icons/Toolbar/redo_g.png", true)    \
ENTRY(IMG_ICON_SOUND_H, "Icons/Toolbar/redo_h.png", true)    \
ENTRY(IMG_ICON_SOUND_P, "Icons/Toolbar/redo_p.png", true)    \
ENTRY(IMG_ICON_TMPL_ANIMATEDIMAGE, "Icons/Controls/animated_image.png", true)    \
ENTRY(IMG_ICON_TMPL_BLENDBUTTON, "Icons/Controls/blend_button.png", true)    \
ENTRY(IMG_ICON_TMPL_BUTTON, "Icons/Controls/button.png", true)    \
ENTRY(IMG_ICON_TMPL_CAROUSEL, "Icons/Controls/carousel.png", true)    \
ENTRY(IMG_ICON_TMPL_CALENDAR, "Icons/Controls/calendar.png", true)    \
ENTRY(IMG_ICON_TMPL_CENTERFOCUS, "Icons/Controls/center_focus_container.png", true)    \
ENTRY(IMG_ICON_TMPL_CHART, "Icons/Controls/chart.png", true)    \
ENTRY(IMG_ICON_TMPL_CHECKBOX, "Icons/Controls/checkbox.png", true)    \
ENTRY(IMG_ICON_TMPL_CIRCULAR_SLIDER, "Icons/Controls/circular_slider.png", true)    \
ENTRY(IMG_ICON_TMPL_CLOCK, "Icons/Controls/clock.png", true)    \
ENTRY(IMG_ICON_TMPL_COMBOBOX, "Icons/Controls/combobox.png", true)    \
ENTRY(IMG_ICON_TMPL_COMPOSITE, "Icons/Controls/composite_object.png", true)    \
ENTRY(IMG_ICON_TMPL_CUSTOM_WIDGET, "Icons/Controls/custom_extension.png", true)    \
ENTRY(IMG_ICON_TMPL_FRAGMENT_CONTAINER, "Icons/Controls/fragment_container.png", true)    \
ENTRY(IMG_ICON_TMPL_GAUGE, "Icons/Controls/gauge.png", true)    \
ENTRY(IMG_ICON_TMPL_GEOMETRY, "Icons/Controls/geometry_object.png", true)    \
ENTRY(IMG_ICON_TMPL_GRAPH, "Icons/Controls/graph.png", true)    \
ENTRY(IMG_ICON_TMPL_GROUP_CONTAINER, "Icons/Controls/group_container.png", true)    \
ENTRY(IMG_ICON_TMPL_HORSCROLLBAR, "Icons/Controls/horizontal_scrollbar.png", true) \
ENTRY(IMG_ICON_TMPL_HORSLIDER, "Icons/Controls/horizontal_slider.png", true) \
ENTRY(IMG_ICON_TMPL_ICONBUTTON, "Icons/Controls/icon_button.png", true)    \
ENTRY(IMG_ICON_TMPL_IMAGE, "Icons/Controls/image.png", true)    \
ENTRY(IMG_ICON_TMPL_IMAGESTACK, "Icons/Controls/imagestack.png", true)    \
ENTRY(IMG_ICON_TMPL_INPUTFIELD, "Icons/Controls/input_field.png", true)    \
ENTRY(IMG_ICON_TMPL_KEYBOARD, "Icons/Controls/keyboard.png", true)    \
ENTRY(IMG_ICON_TMPL_KNOB, "Icons/Controls/knob.png", true)    \
ENTRY(IMG_ICON_TMPL_LAYER_CONTAINER, "Icons/Controls/layer_container.png", true)    \
ENTRY(IMG_ICON_TMPL_LISTBOX, "Icons/Controls/listbox.png", true)    \
ENTRY(IMG_ICON_TMPL_LISTITEM, "Icons/Controls/listitem.png", true)    \
ENTRY(IMG_ICON_TMPL_PAGE_CONTAINER, "Icons/Controls/page_container.png", true)    \
ENTRY(IMG_ICON_TMPL_PLOT, "Icons/Controls/plot.png", true)    \
ENTRY(IMG_ICON_TMPL_PRIMITIVEBUTTON, "Icons/Controls/primitive_button.png", true) \
ENTRY(IMG_ICON_TMPL_PROGRESSBAR, "Icons/Controls/progressbar.png", true)    \
ENTRY(IMG_ICON_TMPL_RADIAL_PROGRESSBAR, "Icons/Controls/radial_progressbar.png", true)    \
ENTRY(IMG_ICON_TMPL_RADIAL_SLIDER, "Icons/Controls/radial_slider.png", true)    \
ENTRY(IMG_ICON_TMPL_RADIOBUTTON, "Icons/Controls/radio_button.png", true)    \
ENTRY(IMG_ICON_TMPL_RADIOBUTTONGROUP, "Icons/Controls/radio_button_group.png", true)    \
ENTRY(IMG_ICON_TMPL_RANGESLIDER, "Icons/Controls/range_slider.png", true)    \
ENTRY(IMG_ICON_TMPL_REPOSITIONCOMPOSITE, "Icons/Controls/reposition_composite.png", true)    \
ENTRY(IMG_ICON_TMPL_SCROLLINGTEXT, "Icons/Controls/scrolling_textfield.png", true)    \
ENTRY(IMG_ICON_TMPL_SCROLLVIEW, "Icons/Controls/scrollview.png", true)    \
ENTRY(IMG_ICON_TMPL_SEGMENTBAR, "Icons/Controls/segmentbar.png", true)    \
ENTRY(IMG_ICON_TMPL_SPLIT_CONTAINER, "Icons/Controls/split_container.png", true)    \
ENTRY(IMG_ICON_TMPL_TAB_CONTAINER, "Icons/Controls/tab_container.png", true)    \
ENTRY(IMG_ICON_TMPL_TAB_ITEM, "Icons/Controls/tab_item.png", true)    \
ENTRY(IMG_ICON_TMPL_TEXTFIELD, "Icons/Controls/textfield.png", true)    \
ENTRY(IMG_ICON_TMPL_TOUCHSCROLLVIEW, "Icons/Controls/touch_scrollview.png", true)    \
ENTRY(IMG_ICON_TMPL_VERSCROLLBAR, "Icons/Controls/vertical_scrollbar.png", true)    \
ENTRY(IMG_ICON_TMPL_VERSLIDER, "Icons/Controls/vertical_slider.png", true)    \
ENTRY(IMG_ICON_TMPL_WHEEL, "Icons/Controls/wheel.png", true)    \
ENTRY(IMG_ICON_TMPL_WHEEL_CONTAINER, "Icons/Controls/wheel_container.png", true)    \
/* about dialog */ \
ENTRY(IMG_GUILIANI_LOGO, "Common/guiliani_logo.png", true)    \
ENTRY(IMG_ABOUT_DIALOG_GUILIANI, "Common/guiliani_logo_large.png", true)    \
ENTRY(IMG_ABOUT_DIALOG_TES, "Common/TES_Logo.png", true)    \
ENTRY(IMG_ABOUT_DIALOG_SEPARATOR, "Common/Trennlinie.png", true)    \
/* animations view */\
ENTRY(IMG_TIMELINE_BAR_GRAB, "Icons/Animation/TimeBarGrabArea.png", true)    \
ENTRY(IMG_TIMELINE_BAR_GRAB_PRESSED, "Icons/Animation/TimeBarGrabArea_p.png", true)    \
ENTRY(IMG_TIMELINE_BAR_GRAB_HIGHLIGHTED, "Icons/Animation/TimeBarGrabArea_h.png", true)    \
ENTRY(IMG_TIMELINE_BAR_GRAB_GRAYEDOUT, "Icons/Animation/TimeBarGrabArea_g.png", true)    \
ENTRY(IMG_TIMELINE_CONNECT, "Icons/Animation/ConnectButton.png", true)    \
ENTRY(IMG_TIMELINE_CONNECT_PRESSED, "Icons/Animation/ConnectButton_p.png", true)    \
ENTRY(IMG_TIMELINE_CONNECT_HIGHLIGHTED, "Icons/Animation/ConnectButton_h.png", true)    \
ENTRY(IMG_TIMELINE_CONNECT_GRAYEDOUT, "Icons/Animation/ConnectButton_g.png", true)    \
ENTRY(IMG_TIMELINE_DISCONNECT, "Icons/Animation/DisconnectButton.png", true)    \
ENTRY(IMG_TIMELINE_DISCONNECT_PRESSED, "Icons/Animation/DisconnectButton_p.png", true)    \
ENTRY(IMG_TIMELINE_DISCONNECT_HIGHLIGHTED, "Icons/Animation/DisconnectButton_h.png", true)    \
ENTRY(IMG_TIMELINE_DISCONNECT_GRAYEDOUT, "Icons/Animation/DisconnectButton_g.png", true)    \
ENTRY(IMG_TIMELINE_DROPDOWN, "Icons/Animation/DropDownButton.png", true)    \
ENTRY(IMG_TIMELINE_DROPDOWN_PRESSED, "Icons/Animation/DropDownButton_p.png", true)    \
ENTRY(IMG_TIMELINE_DROPDOWN_HIGHLIGHTED, "Icons/Animation/DropDownButton_h.png", true)    \
ENTRY(IMG_TIMELINE_DROPDOWN_GRAYEDOUT, "Icons/Animation/DropDownButton_g.png", true)    \
ENTRY(IMG_TIMELINE_DROPUP, "Icons/Animation/DropUpButton.png", true)    \
ENTRY(IMG_TIMELINE_DROPUP_PRESSED, "Icons/Animation/DropUpButton_p.png", true)    \
ENTRY(IMG_TIMELINE_DROPUP_HIGHLIGHTED, "Icons/Animation/DropUpButton_h.png", true)    \
ENTRY(IMG_TIMELINE_DROPUP_GRAYEDOUT, "Icons/Animation/DropUpButton_g.png", true)    \
ENTRY(IMG_TIMELINE_APPLYSTART, "Icons/Animation/ApplyStart.png", true)    \
ENTRY(IMG_TIMELINE_APPLYSTART_PRESSED, "Icons/Animation/ApplyStart_p.png", true)    \
ENTRY(IMG_TIMELINE_APPLYSTART_HIGHLIGHTED, "Icons/Animation/ApplyStart_h.png", true)    \
ENTRY(IMG_TIMELINE_APPLYSTART_GRAYEDOUT, "Icons/Animation/ApplyStart_g.png", true)    \
ENTRY(IMG_TIMELINE_APPLYTARGET, "Icons/Animation/ApplyTarget.png", true)    \
ENTRY(IMG_TIMELINE_APPLYTARGET_PRESSED, "Icons/Animation/ApplyTarget_p.png", true)    \
ENTRY(IMG_TIMELINE_APPLYTARGET_HIGHLIGHTED, "Icons/Animation/ApplyTarget_h.png", true)    \
ENTRY(IMG_TIMELINE_APPLYTARGET_GRAYEDOUT, "Icons/Animation/ApplyTarget_g.png", true)    \
ENTRY(IMG_TIMELINE_BAR_START, "Icons/Animation/TimeBarStartArea.png", true)    \
ENTRY(IMG_TIMELINE_CURSOR_DRAG, "Icons/Animation/TimelineDragCursor.png", true)    \
ENTRY(IMG_TIMELINE_CURSOR_LEFT, "Icons/Animation/TimelineLeftCursor.png", true)    \
ENTRY(IMG_TIMELINE_CURSOR_RIGHT, "Icons/Animation/TimelineRightCursor.png", true)    \
ENTRY(IMG_TIMELINE_CURSOR_RECORD, "Icons/Animation/TimelineRecordCursor.png", true)    \
ENTRY(IMG_TIMELINE_CURSOR_PLAY, "Icons/Animation/TimelinePlayCursor.png", true)    \
ENTRY(IMG_TIMELINE_PLAY, "Icons/Animation/PlayButton.png", true)    \
ENTRY(IMG_TIMELINE_PLAY_PRESSED, "Icons/Animation/PlayButton_p.png", true)    \
ENTRY(IMG_TIMELINE_PLAY_HIGHLIGHTED, "Icons/Animation/PlayButton_h.png", true)    \
ENTRY(IMG_TIMELINE_PLAY_GRAYEDOUT, "Icons/Animation/PlayButton_g.png", true)    \
ENTRY(IMG_TIMELINE_SNAPPING, "Icons/Animation/SnappingButton.png", true)    \
ENTRY(IMG_TIMELINE_SNAPPING_PRESSED, "Icons/Animation/SnappingButton_p.png", true)    \
ENTRY(IMG_TIMELINE_SNAPPING_HIGHLIGHTED, "Icons/Animation/SnappingButton_h.png", true)    \
ENTRY(IMG_TIMELINE_SNAPPING_GRAYEDOUT, "Icons/Animation/SnappingButton_g.png", true)    \
ENTRY(IMG_TIMELINE_PAUSE, "Icons/Animation/PauseButton.png", true)    \
ENTRY(IMG_TIMELINE_PAUSE_PRESSED, "Icons/Animation/PauseButton_p.png", true)    \
ENTRY(IMG_TIMELINE_PAUSE_HIGHLIGHTED, "Icons/Animation/PauseButton_h.png", true)    \
ENTRY(IMG_TIMELINE_PAUSE_GRAYEDOUT, "Icons/Animation/PauseButton_g.png", true)    \
ENTRY(IMG_TIMELINE_RECORD, "Icons/Animation/RecordButton.png", true)    \
ENTRY(IMG_TIMELINE_RECORD_ACTIVE, "Icons/Animation/RecordButton_a.png", true)    \
ENTRY(IMG_TIMELINE_RECORD_PRESSED, "Icons/Animation/RecordButton_p.png", true)    \
ENTRY(IMG_TIMELINE_RECORD_HIGHLIGHTED, "Icons/Animation/RecordButton_h.png", true)    \
ENTRY(IMG_TIMELINE_RECORD_GRAYEDOUT, "Icons/Animation/RecordButton_g.png", true)    \
ENTRY(IMG_TIMELINE_STOP, "Icons/Animation/StopButton.png", true)    \
ENTRY(IMG_TIMELINE_STOP_PRESSED, "Icons/Animation/StopButton_p.png", true)    \
ENTRY(IMG_TIMELINE_STOP_HIGHLIGHTED, "Icons/Animation/StopButton_h.png", true)    \
ENTRY(IMG_TIMELINE_STOP_GRAYEDOUT, "Icons/Animation/StopButton_g.png", true)    \
ENTRY(IMG_TIMELINE_JUMP_TO_START, "Icons/Animation/JumpToStart.png", true)    \
ENTRY(IMG_TIMELINE_JUMP_TO_START_PRESSED, "Icons/Animation/JumpToStart_p.png", true)    \
ENTRY(IMG_TIMELINE_JUMP_TO_START_HIGHLIGHTED, "Icons/Animation/JumpToStart_h.png", true)    \
ENTRY(IMG_TIMELINE_JUMP_TO_START_GRAYEDOUT, "Icons/Animation/JumpToStart_g.png", true)    \
ENTRY(IMG_TIMELINE_ZOOM_IN, "Icons/Animation/zoom_in.png", true)    \
ENTRY(IMG_TIMELINE_ZOOM_IN_PRESSED, "Icons/Animation/zoom_in_p.png", true)    \
ENTRY(IMG_TIMELINE_ZOOM_IN_HIGHLIGHTED, "Icons/Animation/zoom_in_h.png", true)    \
ENTRY(IMG_TIMELINE_ZOOM_IN_GRAYEDOUT, "Icons/Animation/zoom_in_g.png", true)    \
ENTRY(IMG_TIMELINE_ZOOM_OUT, "Icons/Animation/zoom_out.png", true)    \
ENTRY(IMG_TIMELINE_ZOOM_OUT_PRESSED, "Icons/Animation/zoom_out_p.png", true)    \
ENTRY(IMG_TIMELINE_ZOOM_OUT_HIGHLIGHTED, "Icons/Animation/zoom_out_h.png", true)    \
ENTRY(IMG_TIMELINE_ZOOM_OUT_GRAYEDOUT, "Icons/Animation/zoom_out_g.png", true)    \
ENTRY(IMG_ANIMATION_COPY, "Icons/Animation/CopyButton.png", true)    \
ENTRY(IMG_ANIMATION_COPY_PRESSED, "Icons/Animation/CopyButton_p.png", true)    \
ENTRY(IMG_ANIMATION_COPY_HIGHLIGHTED, "Icons/Animation/CopyButton_h.png", true)    \
ENTRY(IMG_ANIMATION_COPY_GRAYEDOUT, "Icons/Animation/CopyButton_g.png", true)    \
ENTRY(IMG_ANIMATION_CHAIN_REPEAT_TOGGLE, "Icons/Animation/RepeatButton.png", true)    \
ENTRY(IMG_ANIMATION_CHAIN_REPEAT_TOGGLE_PRESSED, "Icons/Animation/RepeatButton_p.png", true)    \
ENTRY(IMG_ANIMATION_CHAIN_REPEAT_TOGGLE_HIGHLIGHTED, "Icons/Animation/RepeatButton_h.png", true)    \
ENTRY(IMG_ANIMATION_CHAIN_REPEAT_TOGGLE_GRAYEDOUT, "Icons/Animation/RepeatButton_g.png", true)    \
/* Error console window */\
ENTRY(IMG_CONSOLE_CLEAR_ICON_STANDARD, "Icons/Console/clear_button.png", true)    \
ENTRY(IMG_CONSOLE_CLEAR_ICON_GRAYEDOUT, "Icons/Console/clear_button.png", true)    \
ENTRY(IMG_CONSOLE_CLEAR_ICON_HIGHLIGHTED, "Icons/Console/clear_button_h.png", true)    \
ENTRY(IMG_CONSOLE_CLEAR_ICON_FOCUSSED, "Icons/Console/clear_button.png", true)    \
ENTRY(IMG_CONSOLE_CLEAR_ICON_PRESSED, "Icons/Console/clear_button_p.png", true)    \
/* miscellaneous */ \
ENTRY(IMG_WORKSPACE_GRID, "Common/grid.png", true)    \
ENTRY(IMG_BACKGROUND_CHECKERBOARD, "Common/BackgroundAlpha.png", true)   \
ENTRY(IMG_RESOURCE_LOCK, "Common/Lock.png", true) \
/* Insert all GSE image IDs _in front of_ IMG_USER_START_TAG.*/ \
/* Will be used to mark the start of user tags*/    \
ENTRY(IMG_USER_START_TAG, "", true)
