/**
User-defined General-Resources.
Each of these IDs maps to a resource within the GUI.
You may freely add and remove entries here.

Each entry has to look like:

ENTRY(RES_ID, "Path/Name.dat", true)    \

Last parameter specifies if the resource is permanent.
Where the first parameter specifies the name of the resource id and the
second parameter is the path including the filename starting from
its resource directory.
*/

#define USER_GENERAL_RESOURCES_TABLE            \
    \
/* GSE general resource files */   \
/* Custom extension template files. */  \
ENTRY(RES_TEMPLATE_CMD_H, "CustomTemplates/TemplateCommand.h.tpl", true)   \
ENTRY(RES_TEMPLATE_CMD_CPP, "CustomTemplates/TemplateCommand.cpp.tpl", true)   \
ENTRY(RES_TEMPLATE_LYT_H, "CustomTemplates/TemplateLayouter.h.tpl", true)   \
ENTRY(RES_TEMPLATE_LYT_CPP, "CustomTemplates/TemplateLayouter.cpp.tpl", true)   \
ENTRY(RES_TEMPLATE_BEH_H, "CustomTemplates/TemplateBehaviour.h.tpl", true)   \
ENTRY(RES_TEMPLATE_BEH_CPP, "CustomTemplates/TemplateBehaviour.cpp.tpl", true)   \
ENTRY(RES_TEMPLATE_CTL_H, "CustomTemplates/TemplateControl.h.tpl", true)   \
ENTRY(RES_TEMPLATE_CTL_CPP, "CustomTemplates/TemplateControl.cpp.tpl", true)   \
ENTRY(RES_TEMPLATE_TXT_H, "CustomTemplates/TemplateTextType.h.tpl", true)   \
ENTRY(RES_TEMPLATE_TXT_CPP, "CustomTemplates/TemplateTextType.cpp.tpl", true)   \
ENTRY(RES_TEMPLATE_FAC_H, "CustomTemplates/TemplateFactory.h.tpl", true)   \
ENTRY(RES_TEMPLATE_FAC_CPP, "CustomTemplates/TemplateFactory.cpp.tpl", true) \
 \
/* Insert all GSE general resource IDs _in front of_ GENRES_USER_START_TAG. */ \
ENTRY(GENRES_USER_START_TAG, "", true)
