#
# Windows-MSVC-x86 specific settings
#

# Set output dirs
SET_TARGET_PROPERTIES(${PROJECT_NAME} PROPERTIES RUNTIME_OUTPUT_DIRECTORY "${PROJECT_SOURCE_DIR}/Binary/${CMAKE_SYSTEM_NAME}-${CMAKE_SYSTEM_ARCH}/${CMAKE_CXX_COMPILER_ID}")

TARGET_LINK_DIRECTORIES(${PROJECT_NAME}
  PRIVATE "${PROJECT_SOURCE_DIR}/Libraries/${CMAKE_SYSTEM_NAME}-${CMAKE_SYSTEM_ARCH}/${CMAKE_CXX_COMPILER_ID}"
  PRIVATE "${PATH_EGAC}/Libraries/${CMAKE_SYSTEM_NAME}-${CMAKE_SYSTEM_ARCH}/${CMAKE_CXX_COMPILER_ID}"
  PRIVATE "${PATH_GUILIANI}/Libraries/${CMAKE_SYSTEM_NAME}-${CMAKE_SYSTEM_ARCH}/${CMAKE_CXX_COMPILER_ID}"
)

IF(NOT GSE_SDK_PROJECT)
SET_TARGET_PROPERTIES(GSElib PROPERTIES LIBRARY_OUTPUT_DIRECTORY "${PROJECT_SOURCE_DIR}/Libraries/${CMAKE_SYSTEM_NAME}-${CMAKE_SYSTEM_ARCH}/${CMAKE_CXX_COMPILER_ID}")
SET_TARGET_PROPERTIES(GSElib PROPERTIES ARCHIVE_OUTPUT_DIRECTORY "${PROJECT_SOURCE_DIR}/Libraries/${CMAKE_SYSTEM_NAME}-${CMAKE_SYSTEM_ARCH}/${CMAKE_CXX_COMPILER_ID}")

#eGML
IF(GUILIANI_ADD_EGML_PLATFORM)
  TARGET_INCLUDE_DIRECTORIES(GSElib
    PRIVATE "${PATH_GUILIANI}/Include/Platform/eGML/win"
    PRIVATE "${PATH_GUILIANI}/Include/Platform/eGML"
  )
ENDIF(GUILIANI_ADD_EGML_PLATFORM)

# ogl
IF("${GUILIANI_OGL_PLATFORM}" STREQUAL "OpenGL")
  TARGET_INCLUDE_DIRECTORIES(GSElib
    PRIVATE "${PATH_GUILIANI}/Include/Platform/GL"
    PRIVATE "${PATH_GUILIANI}/Include/Platform/GL/OGL"
    PRIVATE "${PATH_GUILIANI}/Include/Platform/GL/OGL/win"
    PRIVATE "${PATH_LIBS}/opengl/include"
  )
ENDIF("${GUILIANI_OGL_PLATFORM}" STREQUAL "OpenGL")

#DAVE
IF(GUILIANI_ADD_DAVE_PLATFORM)
  TARGET_INCLUDE_DIRECTORIES(GSElib
    PRIVATE "${PATH_GUILIANI}/Include/Platform/DAVE/win"
  )

  TARGET_LINK_DIRECTORIES(GSElib
    PRIVATE "${PATH_LIBS}/DAVE/win32/debug"
  )
ENDIF(GUILIANI_ADD_DAVE_PLATFORM)

#BLU
IF(GUILIANI_ADD_BLU_PLATFORM)
  TARGET_INCLUDE_DIRECTORIES(GSElib
    PRIVATE "${PATH_GUILIANI}/Include/Platform/BLU"
    PRIVATE "${PATH_GUILIANI}/Include/Platform/BLU/win"
    PRIVATE "${PATH_BLU}/Include"
  )
ENDIF(GUILIANI_ADD_BLU_PLATFORM)

TARGET_INCLUDE_DIRECTORIES(GSElib
  PRIVATE "${PATH_GUILIANI}/Include/Platform/win"
  PRIVATE "${PROJECT_SOURCE_DIR}/Include/Platform/win/pc"
  PRIVATE "${PROJECT_SOURCE_DIR}/Resources/win/pc"
  PRIVATE "${PATH_LIBS}/json"
  PRIVATE "${PATH_LIBS}/xlsxio/include"
)

IF(LIBS_BUILD_ZLIB)
	TARGET_INCLUDE_DIRECTORIES(GSElib
      PRIVATE "${PATH_ZLIB}"
      PRIVATE "${CMAKE_CURRENT_BINARY_DIR}/zlib_build"
  )
ENDIF(LIBS_BUILD_ZLIB)

# Some platform dependant include directories.
TARGET_INCLUDE_DIRECTORIES(GSElib
    PRIVATE "${PATH_EGAC}/comps/eC/code/x86_win32"
  )
ENDIF(NOT GSE_SDK_PROJECT)

# Adds platform dependant sources to project.
SET(PLATFORM_WIN_PC_CPP "${PROJECT_SOURCE_DIR}/Source/Platform/win/pc/GSE_Win.cpp" )
LIST(APPEND PLATFORM_WIN_PC_CPP "${PROJECT_SOURCE_DIR}/Source/Platform/win/pc/UserSettingsWin.cpp" )
SOURCE_GROUP("Source Files\\Platform\\Windows\\PC" FILES ${PLATFORM_WIN_PC_CPP})

FILE(GLOB PLATFORM_WIN_PC_H "${PROJECT_SOURCE_DIR}/Include/Platform/win/pc/*.h" )
LIST(APPEND PLATFORM_WIN_PC_H "${PROJECT_SOURCE_DIR}/Resources/win/pc/Resource.h")
SOURCE_GROUP("Header Files\\Platform\\Windows\\PC" FILES ${PLATFORM_WIN_PC_H})

SET(RESOURCE_FILE "${PROJECT_SOURCE_DIR}/Resources/win/pc/GSE.rc")
SOURCE_GROUP("Resource Files" FILES ${RESOURCE_FILE})

SET(PLATFORM_FILES_GSELIB
  ${PLATFORM_WIN_PC_CPP}
  ${PLATFORM_WIN_PC_H}
)

TARGET_LINK_DIRECTORIES(${PROJECT_NAME}
  PRIVATE "${PATH_LIBS}/xlsxio/lib"
  PRIVATE "${PATH_LIBS}/libexpat/lib"
  PRIVATE "${PATH_LIBS}/libzip/lib"
  PRIVATE "${PATH_LIBS}/webp/lib"
)

# common libs
LIST(APPEND PLATFORM_LIBS
  shlwapi.lib
  htmlhelp.lib
  opengl32.lib
  glu32.lib
  expat.lib
  zip.lib
  xlsxio_read_static.lib
  libwebp.lib
  Ws2_32.lib
)

IF(NOT GSE_SDK_PROJECT)
IF(LIBS_BUILD_FREETYPE)
  TARGET_INCLUDE_DIRECTORIES(GSElib
    PRIVATE "${PATH_FREETYPE}/include" 
  )
ELSE(LIBS_BUILD_FREETYPE)
  TARGET_INCLUDE_DIRECTORIES(GSElib
    PRIVATE "${PATH_LIBS}/freetype/include" 
    PRIVATE "${PATH_LIBS}/freetype/include/freetype" 
  )
ENDIF(LIBS_BUILD_FREETYPE)

IF(GUILIANI_ADD_IMAGE_DECODER)
  TARGET_INCLUDE_DIRECTORIES(GSElib
    PRIVATE "${PATH_LIBS}/gif"
    PRIVATE "${PATH_LIBS}/nanosvg/include"
  )
ENDIF(GUILIANI_ADD_IMAGE_DECODER)

IF(EGAC_BUILD_IMAGELIBS)
  TARGET_INCLUDE_DIRECTORIES(GSElib
    PRIVATE "${PATH_EGAC}/intfs/ImageLibs/Gif"
    PRIVATE "${PATH_EGAC}/intfs/ImageLibs/Jpeg"
    PRIVATE "${PATH_EGAC}/intfs/ImageLibs/Jpeg/decompression"
    PRIVATE "${PATH_EGAC}/intfs/ImageLibs/png"
    PRIVATE "${PATH_EGAC}/intfs/ImageLibs/zlib"
  )
ELSE(EGAC_BUILD_IMAGELIBS)
  IF(LIBS_BUILD_LIBJPEG)
    TARGET_INCLUDE_DIRECTORIES(GSElib
      PRIVATE "${PATH_LIBJPEG}"
    )
  ELSE(LIBS_BUILD_LIBJPEG)
    TARGET_INCLUDE_DIRECTORIES(GSElib
      PRIVATE "${PATH_LIBS}/jpeg"
)
  ENDIF(LIBS_BUILD_LIBJPEG)

  IF(LIBS_BUILD_LIBPNG)
    TARGET_INCLUDE_DIRECTORIES(GSElib
      PRIVATE "${PATH_LIBPNG}"
    )
  ELSE(LIBS_BUILD_LIBPNG)
    TARGET_INCLUDE_DIRECTORIES(GSElib
      PRIVATE "${PATH_LIBS}/png/lpng1636"
    )
  ENDIF(LIBS_BUILD_LIBPNG)

  # if zlib if built include-file is located in build-folder
  IF(NOT LIBS_BUILD_ZLIB)
    TARGET_INCLUDE_DIRECTORIES(GSElib
      PRIVATE "${PATH_LIBS}/zlib/include"
)
  ENDIF(NOT LIBS_BUILD_ZLIB)
ENDIF(EGAC_BUILD_IMAGELIBS)
ENDIF(NOT GSE_SDK_PROJECT)
