#
# Windows-MSVC-x86 specific settings
#

#------------------------------------------------------------------------------
# 1. define compiler and linker settings
# Set compiler parameters for VS
SET(CMAKE_CXX_FLAGS_DEBUG "${CMAKE_CXX_FLAGS_DEBUG} /MP /MTd")
SET(CMAKE_CXX_FLAGS_RELEASE "${CMAKE_CXX_FLAGS_RELEASE} /MP /MT")
SET(CMAKE_CXX_FLAGS_DEBUGFIXPOINT "${CMAKE_CXX_FLAGS_DEBUG}")
SET(CMAKE_CXX_FLAGS_RELEASEFIXPOINT "${CMAKE_CXX_FLAGS_RELEASE}")

# Same as for C++
SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_CXX_FLAGS_DEBUG}")
SET(CMAKE_C_FLAGS_RELEASE "${CMAKE_CXX_FLAGS_RELEASE}")
SET(CMAKE_C_FLAGS_DEBUGFIXPOINT "${CMAKE_CXX_FLAGS_DEBUGFIXPOINT}")
SET(CMAKE_C_FLAGS_RELEASEFIXPOINT "${CMAKE_CXX_FLAGS_RELEASEFIXPOINT}")

# Set linker flags
SET(CMAKE_EXE_LINKER_FLAGS_DEBUG "${CMAKE_EXE_LINKER_FLAGS_DEBUG} /NODEFAULTLIB:LIBCMT")
SET(CMAKE_EXE_LINKER_FLAGS_RELEASE "${CMAKE_EXE_LINKER_FLAGS_RELEASE}")
SET(CMAKE_EXE_LINKER_FLAGS_DEBUGFIXPOINT "${CMAKE_EXE_LINKER_FLAGS_DEBUG}")
SET(CMAKE_EXE_LINKER_FLAGS_RELEASEFIXPOINT "${CMAKE_EXE_LINKER_FLAGS_RELEASE}")

# Set parameters for ADD_EXECUTABLE()
SET_TARGET_PROPERTIES(${PROJECT_NAME} PROPERTIES WIN32_EXECUTABLE TRUE)

#------------------------------------------------------------------------------
# 2. define preprocessor defines
LIST(APPEND PREPROCESSOR_DEFINES
  "eC_TARGET_COMPILER_MSVC;UNICODE;eC_TARGET_ENV_WIN32;eC_TARGET_GFX_GDI;WIN32;_CRT_SECURE_NO_DEPRECATE;WINVER=0x0501;_WIN32_WINNT=0x0501;WIN32_LEAN_AND_MEAN"
)

IF("${CMAKE_SIZEOF_VOID_P}" STREQUAL "4")
  LIST(APPEND PREPROCESSOR_DEFINES "eC_TARGET_CPU_X86")
ELSE("${CMAKE_SIZEOF_VOID_P}" STREQUAL "4")
  LIST(APPEND PREPROCESSOR_DEFINES "eC_TARGET_CPU_X64")
ENDIF("${CMAKE_SIZEOF_VOID_P}" STREQUAL "4")

#------------------------------------------------------------------------------
# 3. define global stuff
# Platform dependant include directories.
SET(PLATFORM_LIBS
  "winmm.lib"
)

IF(NOT LIBS_BUILD_FREETYPE)
  TARGET_LINK_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_LIBS}/freetype/lib"
  )
  IF("${CMAKE_SIZEOF_VOID_P}" STREQUAL "4")
    LIST(APPEND PLATFORM_LIBS
      "freetype_win.lib"
    )
  ELSE("${CMAKE_SIZEOF_VOID_P}" STREQUAL "4")
    LIST(APPEND PLATFORM_LIBS
      "freetype248_x64_MT.lib"
    )
  ENDIF("${CMAKE_SIZEOF_VOID_P}" STREQUAL "4")
ENDIF(NOT LIBS_BUILD_FREETYPE)

IF(NOT EGAC_BUILD_IMAGELIBS)
  IF(NOT LIBS_BUILD_LIBPNG)
    TARGET_LINK_DIRECTORIES(${PROJECT_NAME}
	  PRIVATE "${PATH_LIBS}/png/lib"
    )

    IF("${CMAKE_SIZEOF_VOID_P}" STREQUAL "4")
      LIST(APPEND PLATFORM_LIBS
        "libpng16MT_pc.lib"
      )
    ELSE("${CMAKE_SIZEOF_VOID_P}" STREQUAL "4")
      LIST(APPEND PLATFORM_LIBS
        "libpng16MT_x64.lib"
      )
    ENDIF("${CMAKE_SIZEOF_VOID_P}" STREQUAL "4")
  ENDIF(NOT LIBS_BUILD_LIBPNG)

  IF(NOT LIBS_BUILD_LIBJPEG)
    TARGET_LINK_DIRECTORIES(${PROJECT_NAME}
	  PRIVATE "${PATH_LIBS}/jpeg/lib"
    )

    IF("${CMAKE_SIZEOF_VOID_P}" STREQUAL "4")
      LIST(APPEND PLATFORM_LIBS
        "libjpeg6bMT_pc.lib"
      )
    ELSE("${CMAKE_SIZEOF_VOID_P}" STREQUAL "4")
      LIST(APPEND PLATFORM_LIBS
        "libjpeg6b_x64_MT.lib"
      )
    ENDIF("${CMAKE_SIZEOF_VOID_P}" STREQUAL "4")
  ENDIF(NOT LIBS_BUILD_LIBJPEG)

  IF(NOT LIBS_BUILD_ZLIB)
    TARGET_LINK_DIRECTORIES(${PROJECT_NAME}
	  PRIVATE "${PATH_LIBS}/zlib/lib"
    )

    IF("${CMAKE_SIZEOF_VOID_P}" STREQUAL "4")
      LIST(APPEND PLATFORM_LIBS
        "zlib1211MT_pc.lib"
      )
    ELSE("${CMAKE_SIZEOF_VOID_P}" STREQUAL "4")
      LIST(APPEND PLATFORM_LIBS
        "zlib1211MT_x64.lib"
      )
    ENDIF("${CMAKE_SIZEOF_VOID_P}" STREQUAL "4")
  ENDIF(NOT LIBS_BUILD_ZLIB)
ENDIF(NOT EGAC_BUILD_IMAGELIBS)

#------------------------------------------------------------------------------
# 4. define selection dependant packages
# Image decoder libs
# ogl
IF("${GUILIANI_OGL_PLATFORM}" STREQUAL "OpenGL")
  LIST(APPEND PLATFORM_LIBS 
    "opengl32.lib"
    "glu32.lib"
  )
ENDIF("${GUILIANI_OGL_PLATFORM}" STREQUAL "OpenGL")

#DAVE
IF(GUILIANI_ADD_DAVE_PLATFORM)
  TARGET_LINK_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_LIBS}/DAVE/win32/debug"
  )
  LIST(APPEND PLATFORM_LIBS
    #"drivercore_d.lib"
    "davedll_debug.lib"
    "libtcc.lib"
  )
ENDIF(GUILIANI_ADD_DAVE_PLATFORM)
