
#
# Generic-GNU-arm-rsk_rza1_FreeRTOS specific settings
#

#------------------------------------------------------------------------------
# 0. Force project settings

# 1. Force existing settings
SET(GUILIANI_ADD_DUMMY_FILESYSTEM_WRAPPER 1 CACHE BOOL "Add dummy file system wrapper" FORCE)
SET(GUILIANI_ADD_DUMMY_THREAD_WRAPPER 1 CACHE BOOL "Add dummy thread wrapper" FORCE)
SET(EGAC_BUILD_IMAGELIBS 1 CACHE BOOL "Add Imagelibs" FORCE)
SET(EGML_BUILD_NEONLOOPS 1 CACHE BOOL "Include neonloops as source in binary?")
SET(EGML_NEON_OPTIMIZATION 1 CACHE BOOL "Add neon optimization" FORCE)

#------------------------------------------------------------------------------
# 2. Include board specific cmake file
SET(BOARD_CONFIG_CMAKE_FILE "$ENV{BOARD_CONFIG_CMAKE_FILE}" CACHE FILEPATH "Name of the cmake file to configure board settings")
INCLUDE(${BOARD_CONFIG_CMAKE_FILE})

#------------------------------------------------------------------------------
# 3. define preprocessor defines
LIST(APPEND PREPROCESSOR_DEFINES
    "eC_TARGET_COMPILER_GCC;eC_TARGET_ENV_FREERTOS;eC_TARGET_ENV_RZA1H;${PLATFORM_NAME}"
)

#------------------------------------------------------------------------------
# 4. define global stuff
TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
  PRIVATE "${PATH_EGAC}/comps/eC/code/RZA1H"
  PRIVATE "${PATH_EGAC}/comps/eC/code/FreeRTOS"
  PRIVATE "${PATH_EGAC}/comps/eGML/code/eGML_RZA1H"
  PRIVATE "${PATH_GUILIANI}/Include/Platform/eGML"
  PRIVATE "${PATH_GUILIANI}/Include/Platform/general"
  PRIVATE "${PATH_GUILIANI}/Include/Platform/RZA1H"
)

IF(LIBS_BUILD_FREETYPE)
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_FREETYPE}/include" 
  )
ELSE(LIBS_BUILD_FREETYPE)
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_LIBS}/freetype/include" 
    PRIVATE "${PATH_LIBS}/freetype/include/freetype" 
  )
 
  TARGET_LINK_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_LIBS}/freetype/lib"
  )
ENDIF(LIBS_BUILD_FREETYPE)
  
IF(STREAMRUNTIME_SDK_PROJECT)
ELSE(STREAMRUNTIME_SDK_PROJECT)
  IF(EGML_NEON_OPTIMIZATION)
  #------------------------------------------------------------------------------
  # 3. define preprocessor defines
  LIST(APPEND PREPROCESSOR_DEFINES
       "eC_TARGET_CPU_ARM_NEON"
      )
  #------------------------------------------------------------------------------
  # 4. define global stuff
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
  PRIVATE "${PATH_EGAC}/comps/eGML/code/eGML_NEON"
  PRIVATE "${PATH_EGAC}/comps/eGML/code/eGML_NEON/easy_crc"
  )
  ENDIF(EGML_NEON_OPTIMIZATION)
ENDIF(STREAMRUNTIME_SDK_PROJECT)

#------------------------------------------------------------------------------
# 5. define executable file extension
set(CMAKE_EXECUTABLE_SUFFIX ".x")
