# CMake file for configuration of Renesas StreamIt V2 specific settings

# Board description
SET(CMAKE_BOARD_MANUFACTURER Renesas)
SET(CMAKE_BOARD_NAME StreamIt)
SET(CMAKE_BOARD_VERSION V2)
SET(CMAKE_BOARD_OS FreeRTOS10)

ENABLE_LANGUAGE(ASM)

# BSP Path
IF(NOT STREAMRUNTIME_SDK_PROJECT)
SET(PATH_BSP "$ENV{BSP_PATH}" CACHE PATH "Renesas BSP directory path. Hint: RenesasSupplement/trunk/BSP")
ENDIF(NOT STREAMRUNTIME_SDK_PROJECT)

# Build types
IF((NOT CMAKE_BUILD_TYPE STREQUAL "Debug_StreamIt_eGML") AND (NOT CMAKE_BUILD_TYPE STREQUAL "Release_StreamIt_eGML"))
    MESSAGE(STATUS "Incorrect Build Type: " ${CMAKE_BUILD_TYPE})
    MESSAGE(FATAL_ERROR "Incorrect Build Type. \
Possible build types for StreamIt are: Debug_StreamIt_eGML, Release_StreamIt_eGML")
ENDIF((NOT CMAKE_BUILD_TYPE STREQUAL "Debug_StreamIt_eGML") AND (NOT CMAKE_BUILD_TYPE STREQUAL "Release_StreamIt_eGML"))

# Compiler flags (common)
    SET(CMAKE_CXX_FLAGS_DEBUG_STREAMIT_EGML
"-mcpu=cortex-a9 -march=armv7-a -marm -mthumb-interwork -mlittle-endian -mfloat-abi=hard -Og -fmessage-length=0 -fsigned-char -ffunction-sections -fdata-sections -g3 -D_DEBUG"
    )
    SET(CMAKE_CXX_FLAGS_RELEASE_STREAMIT_EGML
"-mcpu=cortex-a9 -march=armv7-a -marm -mthumb-interwork -mlittle-endian -mfloat-abi=hard -Os -fmessage-length=0 -fsigned-char -ffunction-sections -fdata-sections"
    )
IF (EGML_NEON_OPTIMIZATION)
    SET(CMAKE_CXX_FLAGS_DEBUG_STREAMIT_EGML "${CMAKE_CXX_FLAGS_DEBUG_STREAMIT_EGML} -mfpu=neon-fp16")
    SET(CMAKE_CXX_FLAGS_RELEASE_STREAMIT_EGML "${CMAKE_CXX_FLAGS_RELEASE_STREAMIT_EGML} -mfpu=neon-fp16")
ELSE(EGML_NEON_OPTIMIZATION)
    SET(CMAKE_CXX_FLAGS_DEBUG_STREAMIT_EGML "${CMAKE_CXX_FLAGS_DEBUG_STREAMIT_EGML} -mfpu=vfpv3-d16")
    SET(CMAKE_CXX_FLAGS_RELEASE_STREAMIT_EGML "${CMAKE_CXX_FLAGS_RELEASE_STREAMIT_EGML} -mfpu=vfpv3-d16")
ENDIF(EGML_NEON_OPTIMIZATION)

SET(CMAKE_C_FLAGS_DEBUG_STREAMIT_EGML "-std=c99 -fPIC ${CMAKE_CXX_FLAGS_DEBUG_STREAMIT_EGML}")
SET(CMAKE_C_FLAGS_RELEASE_STREAMIT_EGML "-std=c99 -fPIC ${CMAKE_CXX_FLAGS_RELEASE_STREAMIT_EGML}")

SET(CMAKE_ASM_FLAGS_DEBUG_STREAMIT_EGML "-x assembler-with-cpp -MMD -MP ${CMAKE_CXX_FLAGS_DEBUG_STREAMIT_EGML}")
SET(CMAKE_ASM_FLAGS_RELEASE_STREAMIT_EGML "-x assembler-with-cpp -MMD -MP ${CMAKE_CXX_FLAGS_RELEASE_STREAMIT_EGML}")
SET(CMAKE_EXE_LINKER_FLAGS "${CMAKE_EXE_LINKER_FLAGS} -Wl,-Map,SR_GuilianiDemo.map -Wl,--start-group -Wl,--end-group -Xlinker --gc-sections -Xlinker -EL -Xlinker -q -Xlinker -lm -lc -lgcc -Wl,-estart")

# Add subdirectory for BSP
IF(STREAMRUNTIME_SDK_PROJECT)
    SET(CMAKE_BSP_SUBDIRECTORY "${PROJECT_SOURCE_DIR}/../Renesas/BSP")
ELSE(STREAMRUNTIME_SDK_PROJECT)
    SET(CMAKE_BSP_SUBDIRECTORY "${PATH_BSP}/BSP")
ENDIF(STREAMRUNTIME_SDK_PROJECT)

# Preprocessor defines
SET(PLATFORM_NAME "PLATFORM_RENESAS_STREAMIT_V2" CACHE STRING "Name of the platform")

ADD_DEFINITIONS(
-DUSE_STREAM_IT_RZ
-D_WINSOCKAPI_
-DCORTEX_A
-DRSK
-DFRAME_BUFFER_WIDTH=480
-DFRAME_BUFFER_HEIGHT=272
-DGUILIANI_TASK_STACK_SIZE=32768
)

# Linker Script
SET(LINKER_SCRIPT "-T ${CMAKE_BSP_SUBDIRECTORY}/src/renesas/compiler/linker_settings.ld")

# Include directories
TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/arm/cmsis"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/arm/cmsis/inc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/arm/cmsis/src"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/application"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/application/app_sound/inc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/application/app_sdk_camera"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/application/app_touchscreen"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/application/console"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/application/graphics"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/application/inc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/application/system"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/application/app_eeprom/inc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/application/app_sdk_camera/inc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/application/app_touchscreen/inc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/application/console/cmd"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/application/console/inc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/application/graphics/inc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/application/graphics/inc/camera"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/application/graphics/inc/lcd"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/application/system/inc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/application/system/iobitmasks"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/application/system/iodefines"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/application/system/reference"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/compiler"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/compiler/asm"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/compiler/inc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/compiler/init"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/configuration"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/configuration/os_abstraction"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/configuration/os_abstraction/inc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/configuration/os_abstraction/src"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/configuration/sc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/configuration/sc/inc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/intc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/ostm"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_ceu"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_cmos_cam"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_dma"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_i2c"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_led"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_rtc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_ssif/inc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_sci"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_vdc_vdec"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_wdt"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/intc/inc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/ostm/doc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/ostm/inc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/ostm/src"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/ostm/src/hld"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/ostm/src/lld"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/ostm/src/sc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_ceu/inc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_ceu/porting"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_ceu/src"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_cmos_cam/inc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_cmos_cam/src"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_dma/inc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_dma/src"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_i2c/doc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_i2c/inc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_i2c/src"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_i2c/src/hld"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_i2c/src/lld"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_led/inc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_led/src"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_rtc/inc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_rtc/src"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_rtc/src/hld"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_rtc/src/lld"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_sci/doc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_sci/inc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_sci/src"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_sci/src/hld"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_sci/src/lld"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_vdc_vdec/inc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_vdc_vdec/porting"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_vdc_vdec/vdc_h"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_vdc_vdec/vdc_l"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_vdc_vdec/vdec"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_vdc_vdec/vdc_h/src"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_vdc_vdec/vdc_l/src"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_vdc_vdec/vdec/src"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_wdt/inc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_wdt/src"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_wdt/src/hld"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/drivers/r_wdt/src/lld"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/middleware"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/middleware/cmos"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/middleware/touch"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/middleware/usb_host_controller"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/middleware/video"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/middleware/cmos/inc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/middleware/cmos/src"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/middleware/riic_max9856/inc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/middleware/sound/inc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/middleware/touch/inc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/middleware/touch/src"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/middleware/touch/src/lcd_controller"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/middleware/touch/src/touch"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/middleware/touch/src/lcd_controller/FT5x06"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/middleware/usb_host_controller/HardwareDriver"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/middleware/usb_host_controller/HardwareDriver/src"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/middleware/usb_host_controller/inc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/middleware/usb_host_controller/ProtocolDriver"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/middleware/usb_host_controller/ProtocolDriver/src"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/middleware/video/inc"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/middleware/video/src"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/freertos/include"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/freertos/portable/gcc/arm_ca9_rza1lu"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/freertos/portable/memmang"
)

IF(NOT STREAMRUNTIME_SDK_PROJECT)
    IF(EGML_NEON_OPTIMIZATION)
        TARGET_LINK_DIRECTORIES(${PROJECT_NAME}
            PRIVATE "${PATH_EGAC}/intfs/NEON"
        )
    ENDIF(EGML_NEON_OPTIMIZATION)
ENDIF(NOT STREAMRUNTIME_SDK_PROJECT)

# System calls
SET(SYSCALLS_C
  "${CMAKE_BSP_SUBDIRECTORY}/src/renesas/compiler/init/syscalls.c"
  )

# Link directories
TARGET_LINK_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${CMAKE_BINARY_DIR}/BSP"
)

# Link Libraries
IF(NOT LIBS_BUILD_FREETYPE)
  SET(PLATFORM_LIBS
    "freetype_rznew"
    "${PLATFORM_LIBS}"
  )
ENDIF(NOT LIBS_BUILD_FREETYPE)
