
#
# This is the Platform.cmake file.
#

# ========== Some more cache variables which must be set here do be predefined ==========
SET(GUILIANI_ADD_DUMMY_FILESYSTEM_WRAPPER CACHE BOOL "Adds dummy filesystem wrapper to project (Required for platforms without native filesystem support)")
SET(GUILIANI_ADD_DUMMY_THREAD_WRAPPER CACHE BOOL "Adds dummy thread wrapper to project (Required for platforms without threading support)")
SET(GUILIANI_ADD_EGML_PLATFORM 1 CACHE BOOL "Adds eGML platform to project")
SET(GUILIANI_ADD_DAVE_PLATFORM 0 CACHE BOOL "Adds DAVE platform to project")
SET(GUILIANI_ADD_DIRECTFB_PLATFORM 0 CACHE BOOL "Adds directfb platform to project")
SET(GUILIANI_ADD_BLU_PLATFORM 0 CACHE BOOL "Adds BLU platform to project")
SET(GUILIANI_ADD_GLYPHLIB_PLATFORM 0 CACHE BOOL "Adds GlyphLib platform to project")
SET(GUILIANI_ADD_OPENVG_PLATFORM 0 CACHE BOOL "Adds OpenVG platform to project")
SET(GUILIANI_ADD_DCWRAP_PLATFORM 0 CACHE BOOL "include DC-Wrapper")
SET(GUILIANI_ADD_GL_PLATFORM CACHE BOOL "Adds GL-platform to project")
SET(GUILIANI_USE_SDL2_PLATFORM 0 CACHE BOOL "use SDL2 instead of SDL")

# add packages by default
SET(GUILIANI_PACKAGE_ADD_ANIMATION 1 CACHE BOOL "Add Animation-package")
SET(GUILIANI_PACKAGE_ADD_CONNECTION 1 CACHE BOOL "Add Connection-package")
SET(GUILIANI_PACKAGE_ADD_STREAMING 1 CACHE BOOL "Add Streaming-package")
SET(GUILIANI_PACKAGE_ADD_MJPEG 1 CACHE BOOL "Add MJPEG-package")

# internal complexes
SET(LIBS_BUILD_BLU 0 CACHE BOOL "Build BLU from sources")
SET(LIBS_BUILD_GLYPHLIB 0 CACHE BOOL "Build GlyphLib from sources")
SET(LIBS_BUILD_DAVE 0 CACHE BOOL "Build D/AVE from sources")

# external libraries
SET(LIBS_BUILD_FREETYPE 0 CACHE BOOL "Build Freetype from sources (>= 2.6.5)")
SET(LIBS_BUILD_LIBJPEG 0 CACHE BOOL "Build libjpeg from sources (>= v8)")
SET(LIBS_BUILD_LIBPNG 0 CACHE BOOL "Build libpng from sources (>= 1.6.36)")
SET(LIBS_BUILD_ZLIB 0 CACHE BOOL "Build zlib from sources (>= 1.2.11)")

#package-configuration
IF(GUILIANI_PACKAGE_ADD_ANIMATION)
  LIST(APPEND PREPROCESSOR_DEFINES "GUILIANI_ANIMATION_ACTIVE")
ENDIF(GUILIANI_PACKAGE_ADD_ANIMATION)

IF(GUILIANI_PACKAGE_ADD_CONNECTION)
  LIST(APPEND PREPROCESSOR_DEFINES "GUILIANI_CONNECTION_ACTIVE")
ENDIF(GUILIANI_PACKAGE_ADD_CONNECTION)

IF(GUILIANI_PACKAGE_ADD_STREAMING)
  LIST(APPEND PREPROCESSOR_DEFINES "GUILIANI_STREAM_GUI;GUILIANI_WRITE_GUI")
ENDIF(GUILIANI_PACKAGE_ADD_STREAMING)

IF(GUILIANI_PACKAGE_ADD_MJPEG)
  LIST(APPEND PREPROCESSOR_DEFINES "GUILIANI_MJPEG_ACTIVE")
ENDIF(GUILIANI_PACKAGE_ADD_MJPEG)

#We need image decoder if DAVE is active! 
IF(GUILIANI_ADD_DAVE_PLATFORM)
  IF(NOT GUILIANI_ADD_IMAGE_DECODER)
    SET(GUILIANI_ADD_IMAGE_DECODER 1 CACHE BOOL "Must be activated if DAVE is active!" FORCE)
    MESSAGE("GUILIANI_ADD_IMAGE_DECODER has been activated due to GUILIANI_ADD_DAVE_PLATFORM is set!")
  ENDIF(NOT GUILIANI_ADD_IMAGE_DECODER)
ELSE(GUILIANI_ADD_DAVE_PLATFORM)  
    SET(GUILIANI_ADD_IMAGE_DECODER CACHE BOOL "Adds image decoders to project (e.g. for DAVE)")
ENDIF(GUILIANI_ADD_DAVE_PLATFORM)  

IF(FORCE_ADD_OGL_PLATFORM)
  SET(GUILIANI_ADD_GL_PLATFORM 1 CACHE BOOL "Use GL-platform" FORCE)
ENDIF(FORCE_ADD_OGL_PLATFORM)

IF(GUILIANI_ADD_GL_PLATFORM)
  SET(GUILIANI_OGL_PLATFORM "OpenGL" CACHE STRING "use which OpenGL-version?")
  set_property(CACHE GUILIANI_OGL_PLATFORM PROPERTY STRINGS "OpenGL" "OpenGL ES 1.1" "OpenGL ES 2.0")

  IF("${GUILIANI_OGL_PLATFORM}" STREQUAL "OpenGL")
    SET(GUILIANI_OGL_VERSION "GUILIANI_USE_OGL")
  ELSEIF("${GUILIANI_OGL_PLATFORM}" STREQUAL "OpenGL ES 1.1")
    SET(GUILIANI_OGL_VERSION "GUILIANI_USE_OGLES11")
  ELSEIF("${GUILIANI_OGL_PLATFORM}" STREQUAL "OpenGL ES 2.0")
    SET(GUILIANI_OGL_VERSION "GUILIANI_USE_OGLES2")
  ENDIF("${GUILIANI_OGL_PLATFORM}" STREQUAL "OpenGL")
ELSE(GUILIANI_ADD_GL_PLATFORM)
  UNSET(GUILIANI_OGL_PLATFORM CACHE)
  SET(GUILIANI_OGL_VERSION "")
ENDIF(GUILIANI_ADD_GL_PLATFORM)

#We need image decoder if GL is active!
IF(GUILIANI_ADD_GL_PLATFORM)
  IF(NOT GUILIANI_ADD_IMAGE_DECODER)
    SET(GUILIANI_ADD_IMAGE_DECODER 1 CACHE BOOL "Must be activated if GL is used!" FORCE)
    MESSAGE(STATUS "GUILIANI_ADD_IMAGE_DECODER has been activated due to GUILIANI_ADD_GL_PLATFORM is set!")
  ENDIF(NOT GUILIANI_ADD_IMAGE_DECODER)
ELSE(GUILIANI_ADD_GL_PLATFORM)
    SET(GUILIANI_ADD_IMAGE_DECODER CACHE BOOL "Adds image decoders to project (e.g. for GL)")
ENDIF(GUILIANI_ADD_GL_PLATFORM)

#We need to set RTTI in Guiliani when it is needed by the application.
IF(FORCE_USE_RTTI)
    SET(GUILIANI_USE_RTTI 1 CACHE BOOL "Was activated since it is required by the application" FORCE)
    MESSAGE(STATUS "GUILIANI_USE_RTTI has been activated by the application cmake project!")
ELSE(FORCE_USE_RTTI)
    SET(GUILIANI_USE_RTTI CACHE BOOL "Activates 'run-time type information'")
ENDIF(FORCE_USE_RTTI) 

# ========== Common preprocessor defines ==========
LIST(APPEND PREPROCESSOR_DEFINES "${ADDITIONAL_PREPROCESSOR_DEFINES};${GUILIANI_OGL_VERSION};eC_USE_TRIG_TABLE;eGML_USE_LITTLE_HELPERS")

IF(GUILIANI_ADD_IMAGE_DECODER)
  LIST(APPEND PREPROCESSOR_DEFINES GUILIANI_ADD_IMAGE_DECODER)
ENDIF(GUILIANI_ADD_IMAGE_DECODER)

IF(STREAMRUNTIME_USE_DCWRAP AND NOT GUILIANI_ADD_DCWRAP_PLATFORM)
    SET(GUILIANI_ADD_DCWRAP_PLATFORM 1 CACHE BOOL "include DC-Wrapper)" FORCE)
    MESSAGE(STATUS "GUILIANI_ADD_DCWRAP_PLATFORM has been activated by the application cmake project!")
ENDIF(STREAMRUNTIME_USE_DCWRAP AND NOT GUILIANI_ADD_DCWRAP_PLATFORM)

IF("${CMAKE_PLATFORM_NAME}" STREQUAL "")
    SET(CMAKE_INCLUDE_FILE "${CMAKE_SYSTEM_NAME}-${CMAKE_CXX_COMPILER_ID}-${CMAKE_SYSTEM_PROCESSOR}.cmake")
ELSE("${CMAKE_PLATFORM_NAME}" STREQUAL "")
    SET(CMAKE_INCLUDE_FILE "${CMAKE_SYSTEM_NAME}-${CMAKE_CXX_COMPILER_ID}-${CMAKE_SYSTEM_PROCESSOR}-${CMAKE_PLATFORM_NAME}.cmake")
ENDIF("${CMAKE_PLATFORM_NAME}" STREQUAL "")

IF(EXISTS "${PATH_COMMON}/Platform/${CMAKE_INCLUDE_FILE}")
    INCLUDE("${PATH_COMMON}/Platform/${CMAKE_INCLUDE_FILE}")
ELSE(EXISTS "${PATH_COMMON}/Platform/${CMAKE_INCLUDE_FILE}")
    MESSAGE(FATAL_ERROR "common platform-file not found: ${PATH_COMMON}/Platform/${CMAKE_INCLUDE_FILE}")
ENDIF(EXISTS "${PATH_COMMON}/Platform/${CMAKE_INCLUDE_FILE}")

IF(EXISTS "${PROJECT_SOURCE_DIR}/CMake/Platform/${CMAKE_INCLUDE_FILE}")
    INCLUDE("${PROJECT_SOURCE_DIR}/CMake/Platform/${CMAKE_INCLUDE_FILE}")
ELSE(EXISTS "${PROJECT_SOURCE_DIR}/CMake/Platform/${CMAKE_INCLUDE_FILE}")
    MESSAGE(FATAL_ERROR "platform-file not found: ${PROJECT_SOURCE_DIR}/CMake/Platform/${CMAKE_INCLUDE_FILE}")
ENDIF(EXISTS "${PROJECT_SOURCE_DIR}/CMake/Platform/${CMAKE_INCLUDE_FILE}")
