
#
# This file sets the include directories
#

# common folders
TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
  PRIVATE "${PATH_GUILIANI}/Include/Core"
  PRIVATE "${PATH_GUILIANI}/Include/Core/Behaviour"
  PRIVATE "${PATH_GUILIANI}/Include/Core/Command"
  PRIVATE "${PATH_GUILIANI}/Include/Core/Control"
  PRIVATE "${PATH_GUILIANI}/Include/Core/Exception"
  PRIVATE "${PATH_GUILIANI}/Include/Core/Layouter"
  PRIVATE "${PATH_GUILIANI}/Include/Core/Transition"
  PRIVATE "${PATH_GUILIANI}/Include/Core/Utils"
  PRIVATE "${PATH_GUILIANI}/Include/Core/Video"
  PRIVATE "${PATH_GUILIANI}/Include/CustomExtension"
  PRIVATE "${PATH_GUILIANI}/Include/GUIConfig"
  PRIVATE "${PATH_GUILIANI}/Include/Platform/general"
)

IF(GUILIANI_PACKAGE_ADD_ANIMATION)
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_GUILIANI}/Include/Core/Animation"
  )
ENDIF(GUILIANI_PACKAGE_ADD_ANIMATION)

IF(GUILIANI_PACKAGE_ADD_CONNECTION)
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_GUILIANI}/Include/Connection"
  )
ENDIF(GUILIANI_PACKAGE_ADD_CONNECTION)

IF(GUILIANI_PACKAGE_ADD_STREAMING)
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_GUILIANI}/Include/Core/Streaming"
  )
ENDIF(GUILIANI_PACKAGE_ADD_STREAMING)

IF(STREAMRUNTIME_SDK_PROJECT OR GSE_SDK_PROJECT)
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_EGAC}/Include/eC"
    PRIVATE "${PATH_EGAC}/Include/eDBG"
    PRIVATE "${PATH_EGAC}/Include/eFnt"
    PRIVATE "${PATH_EGAC}/Include/eImg"
    PRIVATE "${PATH_EGAC}/Include/eGML"
    PRIVATE "${PATH_EGAC}/Include/eMem"
  )
ELSE(STREAMRUNTIME_SDK_PROJECT OR GSE_SDK_PROJECT)
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_EGAC}/comps/eC/code"
    PRIVATE "${PATH_EGAC}/comps/eDBG/code"
    PRIVATE "${PATH_EGAC}/comps/eFnt/code"
    PRIVATE "${PATH_EGAC}/comps/eImg/code"
    PRIVATE "${PATH_EGAC}/comps/eGML/code"
    PRIVATE "${PATH_EGAC}/comps/eMem/code"
  )
ENDIF(STREAMRUNTIME_SDK_PROJECT OR GSE_SDK_PROJECT)

IF(GUILIANI_ADD_EGML_PLATFORM)
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_GUILIANI}/Include/Platform/eGML"
  )
ENDIF(GUILIANI_ADD_EGML_PLATFORM)

IF(LIBS_BUILD_GLYPHLIB)
  IF(STREAMRUNTIME_SDK_PROJECT)
    TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
      PRIVATE "${PROJECT_SOURCE_DIR}/../GlyphLib/Include"
    )
  ELSE(STREAMRUNTIME_SDK_PROJECT)
    TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
      PRIVATE "${PATH_GLYPHLIB}/Include"
    )
  ENDIF(STREAMRUNTIME_SDK_PROJECT)
ENDIF(LIBS_BUILD_GLYPHLIB)

IF(GUILIANI_ADD_DAVE_PLATFORM)
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_GUILIANI}/Include/Platform/DAVE"
  )
ENDIF(GUILIANI_ADD_DAVE_PLATFORM)

IF(LIBS_BUILD_DAVE)
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_DAVE}/Include"
    PRIVATE "${PATH_DAVE}/Include/d0lib"
    PRIVATE "${PATH_DAVE}/Include/softdave"
  )
ENDIF(LIBS_BUILD_DAVE)

IF(GUILIANI_ADD_BLU_PLATFORM)
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_GUILIANI}/Include/Platform/BLU"
  )
ENDIF(GUILIANI_ADD_BLU_PLATFORM)

IF(LIBS_BUILD_BLU)
  IF(STREAMRUNTIME_SDK_PROJECT)
    TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
      PRIVATE "${PROJECT_SOURCE_DIR}/../BLU/Include/BLU"
    )
  ELSE(STREAMRUNTIME_SDK_PROJECT)
    TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
      PRIVATE "${PATH_BLU}/Include"
    )
  ENDIF(STREAMRUNTIME_SDK_PROJECT)
ENDIF(LIBS_BUILD_BLU)

IF(GUILIANI_ADD_IMAGE_DECODER)
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_GUILIANI}/Include/ImageDecoder"
    PRIVATE "${PATH_LIBS}/nanosvg/include"
    PRIVATE "${PATH_LIBS}/webp/include"
    )
ENDIF(GUILIANI_ADD_IMAGE_DECODER)

IF(EGAC_BUILD_IMAGELIBS)
  IF(NOT STREAMRUNTIME_SDK_PROJECT)
    TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
      PRIVATE "${PATH_EGAC}/intfs/ImageLibs/Gif"
      PRIVATE "${PATH_EGAC}/intfs/ImageLibs/Jpeg"
      PRIVATE "${PATH_EGAC}/intfs/ImageLibs/Jpeg/decompression"
      PRIVATE "${PATH_EGAC}/intfs/ImageLibs/png"
      PRIVATE "${PATH_EGAC}/intfs/ImageLibs/zlib"
    )
  ENDIF(NOT STREAMRUNTIME_SDK_PROJECT)
ENDIF(EGAC_BUILD_IMAGELIBS)
