
#
# This is the Common_settings.cmake file.
#

# ========== Setup existing build configurations (e.g. for Visual Studio) ==========
IF(NOT REPLACE_CMAKE_CONFIGURATION_TYPES)  # Set REPLACE_CMAKE_CONFIGURATION_TYPES if you want to add CMAKE_CONFIGURATION_TYPES manually using the cmake command line tool.
  IF(CMAKE_CONFIGURATION_TYPES)
     LIST(REMOVE_ITEM CMAKE_CONFIGURATION_TYPES MinSizeRel)
     LIST(REMOVE_ITEM CMAKE_CONFIGURATION_TYPES RelWithDebInfo)
     LIST(REMOVE_DUPLICATES CMAKE_CONFIGURATION_TYPES)
     SET(CMAKE_CONFIGURATION_TYPES "${CMAKE_CONFIGURATION_TYPES}" CACHE STRING "Reset the configurations to what we need" FORCE)
  ENDIF(CMAKE_CONFIGURATION_TYPES)
ENDIF(NOT REPLACE_CMAKE_CONFIGURATION_TYPES)

# ========== Setup existing build type (e.g. for make) ==========
# If the user specifies -DCMAKE_BUILD_TYPE on the command line, take their definition
# and dump it in the cache along with proper documentation, otherwise set CMAKE_BUILD_TYPE
# to Debug prior to calling PROJECT()
IF(DEFINED CMAKE_BUILD_TYPE)
   SET(CMAKE_BUILD_TYPE ${CMAKE_BUILD_TYPE} CACHE STRING "Please choose build type. Possible values are: Debug Release (DebugFixpoint ReleaseFixpoint)")
ELSE(DEFINED CMAKE_BUILD_TYPE)
   SET(CMAKE_BUILD_TYPE "Debug" CACHE STRING "Please choose build type. Possible values are: Debug Release (DebugFixpoint ReleaseFixpoint)")
ENDIF(DEFINED CMAKE_BUILD_TYPE)

# Set Debug as default build-type if none is set
IF("${CMAKE_BUILD_TYPE}" STREQUAL "")
    MESSAGE("Setting Debug as default build-type")
    SET(CMAKE_BUILD_TYPE "Debug" CACHE STRING "" FORCE)
ENDIF("${CMAKE_BUILD_TYPE}" STREQUAL "")
    
# ========== Some cache variables ==========
SET(PATH_GUILIANI "$ENV{GUILIANI_PATH}" CACHE PATH "Guiliani directory path")
SET(PATH_EGAC "$ENV{EGAC_PATH}" CACHE PATH "eGaC directory path")
SET(PATH_LIBS "$ENV{LIBS_PATH}" CACHE PATH "Libs directory path")
SET(SHOW_BUILD_INFORMATION 0 CACHE BOOL "Displays some information about the configuration")

#if BLU is used the BLU path must be specified
IF(LIBS_BUILD_BLU)
  SET(PATH_BLU "$ENV{BLU_PATH}" CACHE PATH "BLU directory path")
ENDIF(LIBS_BUILD_BLU)

#if GlyphLib is used the GlyphLib path must be specified
IF(LIBS_BUILD_GLYPHLIB)
  SET(PATH_GLYPHLIB "$ENV{GLYPHLIB_PATH}" CACHE PATH "GlyphLib directory path")
ENDIF(LIBS_BUILD_GLYPHLIB)

#if DAVE is used path must be specified
IF(LIBS_BUILD_DAVE)
  SET(PATH_DAVE "$ENV{DAVE_PATH}" CACHE PATH "DAVE directory path")
ENDIF(LIBS_BUILD_DAVE)

#if FreeType shall be built from sources path must be specified
IF(LIBS_BUILD_FREETYPE)
  SET(PATH_FREETYPE "$ENV{FREETYPE_PATH}" CACHE PATH "FreeType sources path")
ENDIF(LIBS_BUILD_FREETYPE)

#if libjpeg shall be built from sources path must be specified
IF(LIBS_BUILD_LIBJPEG)
  SET(PATH_LIBJPEG "$ENV{LIBJPEG_PATH}" CACHE PATH "libjpeg sources path")
ENDIF(LIBS_BUILD_LIBJPEG)

#if libpng shall be built from sources path must be specified
IF(LIBS_BUILD_LIBPNG)
  SET(PATH_LIBPNG "$ENV{LIBPNG_PATH}" CACHE PATH "libpng sources path")
ENDIF(LIBS_BUILD_LIBPNG)

#if zlib shall be built from sources path must be specified
IF(LIBS_BUILD_ZLIB)
  SET(PATH_ZLIB "$ENV{ZLIB_PATH}" CACHE PATH "zlib sources path")
ENDIF(LIBS_BUILD_ZLIB)

SET(ADDITIONAL_PREPROCESSOR_DEFINES "" CACHE STRING "Appends given defines to the platform defines list. Separate defines by using a semicolon")

