
#
# This is the Common_Apple_settings.txt file. These are common settings for setting up the 
# MacOSX application bundle.
#

# Variable for the application bundle name including the full path (e.g. /home/user/TES/GSE.app)
SET(APPLICATION_NAME \${TARGET_BUILD_DIR}/\${FULL_PRODUCT_NAME})

# Set properties for the application bundle
SET_TARGET_PROPERTIES(${PROJECT_NAME} PROPERTIES
# Entries may be redundant as they are used to generate info.plist, and info.plist is kept as a prepared file in resources/ios
MACOSX_BUNDLE_INFO_STRING "${PROJECT_NAME} Version ${PROJECT_VERSION}, Copyright 2014 TES Electronic Solutions GmbH."
MACOSX_BUNDLE_ICON_FILE ${PROJECT_NAME}.icns
MACOSX_BUNDLE_GUI_IDENTIFIER "com.tes-dst.\${PRODUCT_NAME:identifier}"
MACOSX_BUNDLE_LONG_VERSION_STRING "${PROJECT_NAME} Version ${PROJECT_VERSION}"
MACOSX_BUNDLE_BUNDLE_NAME ${PROJECT_NAME}
MACOSX_BUNDLE_SHORT_VERSION_STRING ${PROJECT_VERSION}
MACOSX_BUNDLE_BUNDLE_VERSION ${PROJECT_VERSION}
MACOSX_BUNDLE_COPYRIGHT "Copyright 2015 TES Electronic Solutions GmbH. All Rights Reserved."

XCODE_ATTRIBUTE_INSTALL_PATH "/Applications"
# This sets xcode project as universal
XCODE_ATTRIBUTE_TARGETED_DEVICE_FAMILY "1,2"
)

IF(CMAKE_PLATFORM_NAME STREQUAL "iphonesimulator" OR CMAKE_PLATFORM_NAME STREQUAL "iphoneos")

# Add code signing for iOS applications
SET_TARGET_PROPERTIES(${PROJECT_NAME} PROPERTIES XCODE_ATTRIBUTE_CODE_SIGN_IDENTITY "iPhone Developer")

ENDIF(CMAKE_PLATFORM_NAME STREQUAL "iphonesimulator" OR CMAKE_PLATFORM_NAME STREQUAL "iphoneos")
  
