
#
# This file shows some build information about the current project
#

IF(SHOW_BUILD_INFORMATION)

MESSAGE("")
MESSAGE("================================================================================")
MESSAGE("                                 ${PROJECT_NAME} ${PROJECT_VERSION}")
MESSAGE("================================================================================")
MESSAGE("")
MESSAGE("TARGET SYSTEM INFORMATION")
MESSAGE("=========================")
MESSAGE("System: ${CMAKE_SYSTEM}")
MESSAGE("System name: ${CMAKE_SYSTEM_NAME}")
MESSAGE("System processor: ${CMAKE_SYSTEM_PROCESSOR}")
MESSAGE("System version: ${CMAKE_SYSTEM_VERSION}")
MESSAGE("")
MESSAGE("HOST SYSTEM INFORMATION")
MESSAGE("=======================")
MESSAGE("System: ${CMAKE_HOST_SYSTEM}")
MESSAGE("System name: ${CMAKE_HOST_SYSTEM_NAME}")
MESSAGE("System processor: ${CMAKE_HOST_SYSTEM_PROCESSOR}")
MESSAGE("System version: ${CMAKE_HOST_SYSTEM_VERSION}")
MESSAGE("")
MESSAGE("DETECTED SYSTEM VARIABLES")
MESSAGE("=========================")
IF (APPLE)
  MESSAGE("APPLE")
  MESSAGE("XCode version: ${XCODE_VERSION}")
ENDIF (APPLE)
IF (UNIX)
  MESSAGE("UNIX")
ENDIF (UNIX)
IF (WIN32)
  MESSAGE("WIN32")
ENDIF (WIN32)
IF (CYGWIN)
  MESSAGE("CYGWIN")
ENDIF (CYGWIN)
IF (MSVC)
  MESSAGE("MSVC")
  MESSAGE("MSVC Version: ${MSVC_VERSION}")
ENDIF (MSVC)
IF (MSVC80)
  MESSAGE("MSVC80")
ENDIF (MSVC80)
IF (MSVC_IDE)
  MESSAGE("MSVC_IDE")
ENDIF (MSVC_IDE)
MESSAGE("")
MESSAGE("COMPILER INFORMATION")
MESSAGE("====================")
MESSAGE("C compiler: ${CMAKE_C_COMPILER}")
MESSAGE("CXX compiler: ${CMAKE_CXX_COMPILER}")
MESSAGE("")
MESSAGE("")
MESSAGE("C flags: ${CMAKE_C_FLAGS}")
MESSAGE("C flags Debug: ${CMAKE_C_FLAGS_DEBUG}")
MESSAGE("C flags Release: ${CMAKE_C_FLAGS_RELEASE}")
MESSAGE("")
MESSAGE("CXX flags: ${CMAKE_CXX_FLAGS}")
MESSAGE("CXX flags Debug: ${CMAKE_CXX_FLAGS_DEBUG}")
MESSAGE("CXX flags Release: ${CMAKE_CXX_FLAGS_RELEASE}")
MESSAGE("")
MESSAGE("BUILD INFORMATION")
MESSAGE("=================")
MESSAGE("Build type: ${CMAKE_BUILD_TYPE}")
MESSAGE("Library output directory: ${CMAKE_LIBRARY_OUTPUT_DIRECTORY}")
MESSAGE("")
IF(NOT PATH_GUILIANI)
  MESSAGE("Please set path to Guiliani directory")
ENDIF(NOT PATH_GUILIANI)
IF(NOT PATH_EGAC)
  MESSAGE("Please set path to eGaC directory")
ENDIF(NOT PATH_EGAC)
IF(NOT PATH_LIBS)
  MESSAGE("Please set path to Libs directory")
ENDIF(NOT PATH_LIBS)
MESSAGE("")
IF(CMAKE_CROSSCOMPILING)
  MESSAGE("Cross compile!")
  MESSAGE("")
ENDIF(CMAKE_CROSSCOMPILING)
MESSAGE("Common preprocessor defines: ${PREPROCESSOR_DEFINES}")
MESSAGE("================================================================================")
MESSAGE("")

ENDIF(SHOW_BUILD_INFORMATION)
