
#
# This file is used to include specific complexes as sources
#

# ========== Add eGaC ==========
IF(EXISTS "${PATH_EGAC}/CMakeLists.txt")
    ADD_SUBDIRECTORY("${PATH_EGAC}" ./eGaC)
ELSE(EXISTS "${PATH_EGAC}/CMakeLists.txt")
    MESSAGE(FATAL_ERROR "Path not set or wrong to eGaC directory.")
ENDIF(EXISTS "${PATH_EGAC}/CMakeLists.txt")

# ========== Add Guiliani ==========
IF(EXISTS "${PATH_GUILIANI}/CMakeLists.txt")
    ADD_SUBDIRECTORY("${PATH_GUILIANI}" ./Guiliani)
ELSE(EXISTS "${PATH_GUILIANI}/CMakeLists.txt")
    MESSAGE(FATAL_ERROR "Path not set or wrong to Guiliani directory.")
ENDIF(EXISTS "${PATH_GUILIANI}/CMakeLists.txt")

# ========== Add GlyphLib ==========
IF(LIBS_BUILD_GLYPHLIB)
    IF(EXISTS "${PATH_GLYPHLIB}/CMakeLists.txt")
        ADD_SUBDIRECTORY("${PATH_GLYPHLIB}" ./GlyphLib)
    ELSE(EXISTS "${PATH_GLYPHLIB}/CMakeLists.txt")
        MESSAGE(FATAL_ERROR "Path not set or wrong to GlyphLib directory.")
    ENDIF(EXISTS "${PATH_GLYPHLIB}/CMakeLists.txt")
ENDIF(LIBS_BUILD_GLYPHLIB)

# ========== Add D/AVE ==========
IF(LIBS_BUILD_DAVE)
    IF(EXISTS "${PATH_DAVE}/CMakeLists.txt")
        ADD_SUBDIRECTORY("${PATH_DAVE}" ./DAVE)
    ELSE(EXISTS "${PATH_DAVE}/CMakeLists.txt")
        MESSAGE(FATAL_ERROR "Path not set or wrong to DAVE directory.")
    ENDIF(EXISTS "${PATH_DAVE}/CMakeLists.txt")
ENDIF(LIBS_BUILD_DAVE)

# ========== Add BLU ==========
IF(LIBS_BUILD_BLU)
    IF(EXISTS "${PATH_BLU}/CMakeLists.txt")
        ADD_SUBDIRECTORY("${PATH_BLU}" ./BLU)
    ELSE(EXISTS "${PATH_BLU}/CMakeLists.txt")
        MESSAGE(FATAL_ERROR "Path not set or wrong to BLU directory.")
    ENDIF(EXISTS "${PATH_BLU}/CMakeLists.txt")
ENDIF(LIBS_BUILD_BLU)

IF(LIBS_BUILD_FREETYPE)
    IF(EXISTS "${PATH_FREETYPE}/CMakeLists.txt")
        ADD_SUBDIRECTORY("${PATH_FREETYPE}" ./freetype_build)
    ELSE(EXISTS "${PATH_FREETYPE}/CMakeLists.txt")
        MESSAGE(FATAL_ERROR "freetype CMakeLists.txt not found!")
    ENDIF(EXISTS "${PATH_FREETYPE}/CMakeLists.txt")
ENDIF(LIBS_BUILD_FREETYPE)

IF(LIBS_BUILD_LIBPNG)
    IF(EXISTS "${PATH_LIBPNG}/CMakeLists.txt")
        ADD_SUBDIRECTORY("${PATH_LIBPNG}" ./libpng_build)
    ELSE(EXISTS "${PATH_LIBPNG}/CMakeLists.txt")
        MESSAGE(FATAL_ERROR "libpng CMakeLists.txt not found!")
    ENDIF(EXISTS "${PATH_LIBPNG}/CMakeLists.txt")
ENDIF(LIBS_BUILD_LIBPNG)

IF(LIBS_BUILD_LIBJPEG)
    IF(EXISTS "${PATH_LIBJPEG}/CMakeLists.txt")
        ADD_SUBDIRECTORY("${PATH_LIBJPEG}" ./libjpeg_build)
    ELSE(EXISTS "${PATH_LIBJPEG}/CMakeLists.txt")
        MESSAGE(FATAL_ERROR "libjpeg CMakeLists.txt not found!")
    ENDIF(EXISTS "${PATH_LIBJPEG}/CMakeLists.txt")
ENDIF(LIBS_BUILD_LIBJPEG)

IF(LIBS_BUILD_ZLIB)
    IF(EXISTS "${PATH_ZLIB}/CMakeLists.txt")
        ADD_SUBDIRECTORY("${PATH_ZLIB}" ./zlib_build)
    ELSE(EXISTS "${PATH_ZLIB}/CMakeLists.txt")
        MESSAGE(FATAL_ERROR "zlib CMakeLists.txt not found!")
    ENDIF(EXISTS "${PATH_ZLIB}/CMakeLists.txt")
ENDIF(LIBS_BUILD_ZLIB)
