#!/bin/sh

for ONCE in once; do

	if [ $# -eq 1 ]; then
		if [ "$1" == "-h" ] || [ "$1" == "-H" ] || [ "$1" == "help" ]; then
			echo ""
			echo "No parameters: The script will use the example files."
			echo ""
			break		
		fi
	fi

	if [ $# -eq 0 ]; then	
		PASS=YES
	fi
	
	if [ "$PASS" != "YES" ]; then
		echo "Incorrect number of parameters"
		break
    fi
	
	
	RES_FLASH_FILE=VEEK/Files/Resources.flash
	ELF_FLASH_FILE=VEEK/Files/StreamRuntime.flash
	
	if [ -f $RES_FLASH_FILE ]; then
	    if [ -f $ELF_FLASH_FILE ]; then
		if [ -f $SOF_FLASH_FILE ]; then
                    nios2-flash-programmer --base=0x12000000 $RES_FLASH_FILE
                    nios2-flash-programmer --base=0x12000000 $ELF_FLASH_FILE
		else
		    echo "The configuration flash file does not exist."
		    break
		fi
	    else
		echo "The executable flash file could not be found."
		echo "The configuration, resources and executable files should be under ther folder <Path where the evalkit is>/VEEK/Files/"
		break
	    fi
	else
	    echo "The resources flash file could not be found."
	    echo "The configuration, resources and executable files should be under ther folder <Path where the evalkit is>/VEEK/Files/"
	    break
	fi

	exit 0
done

exit 1
