#include "<*>BEHAVIOUR_CLASS_NAME<*>.h"
#include "GUIStreamReader.h"
#include "GUIStreamWriter.h"
#include "GUIStreamingException.h"
#include "GUIBehaviourResource.h"

#include "GUIMemLeakWatcher.h" // <-- has to be the last include

#define <*>BEHAVIOUR_CLASS_VERSION_NAME<*> <*>BEHAVIOUR_CLASS_VERSION<*>

<*>BEHAVIOUR_CLASS_NAME<*>::<*>BEHAVIOUR_CLASS_NAME<*>(CGUIObject* const pObject)
    : CGUIBehaviourDecorator(pObject)
{
#if defined(GUILIANI_WRITE_GUI)
    SetXMLTag("<*>BEHAVIOUR_CLASS_NAME<*>");
#endif
}

<*>BEHAVIOUR_CLASS_NAME<*>::<*>BEHAVIOUR_CLASS_NAME<*>()
    : CGUIBehaviourDecorator()
{
#if defined(GUILIANI_WRITE_GUI)
    SetXMLTag("<*>BEHAVIOUR_CLASS_NAME<*>");
#endif
}

#if defined(GUILIANI_STREAM_GUI)
void <*>BEHAVIOUR_CLASS_NAME<*>::ReadFromStream()
{
    eC_Int iVersion = GETINPUTSTREAM.READ_INT(XMLTAG_CLASSVERSION); 

    switch (iVersion)
    {
    case <*>BEHAVIOUR_CLASS_VERSION<*>:
        // Insert custom content here.
        break;
    default:
        GUILOG_THROW_EXCEPTION(
            CGUIStreamingException("", GETINPUTSTREAM.GetCurLine()),
            "<*>BEHAVIOUR_CLASS_NAME<*>::ReadFromStream: Incompatible class "
            "version! Current version is "
            + eC_String(<*>BEHAVIOUR_CLASS_VERSION_NAME<*>)
            + ", read version is " + eC_String(iVersion) + ".\n");
        break;
    }

    CGUIBehaviourDecorator::ReadFromStream();
}
#endif

#if defined(GUILIANI_WRITE_GUI)
void <*>BEHAVIOUR_CLASS_NAME<*>::WriteToStream(const eC_Bool bWriteClassID)
{
    if(bWriteClassID)
    {
        GETOUTPUTSTREAM.WriteCommentTag(GetXMLTag());
        GETOUTPUTSTREAM.WriteInt(<*>BEHAVIOUR_CLASS_ID_NAME<*>,
            XMLTAG_BEHAVIOURCLASSID);
    }
    GETOUTPUTSTREAM.WriteInt(<*>BEHAVIOUR_CLASS_VERSION_NAME<*>,
        XMLTAG_CLASSVERSION);
    // Insert custom content here.
    CGUIBehaviourDecorator::WriteToStream();
    if(bWriteClassID)
    {
        GETOUTPUTSTREAM.WriteCommentTag(eC_String("/") + GetXMLTag());
    }
}
#endif
