#!/bin/sh

for ONCE in once; do

    if [ $# -eq 1 ]; then
	if [ "$1" == "-h" ] || [ "$1" == "-H" ] || [ "$1" == "help" ]; then
	    echo ""
	    echo "No parameters."
	    echo ""
	    break		
	fi
    fi

    if [ $# -eq 0 ]; then	
	PASS=YES
    fi
    
    if [ "$PASS" != "YES" ]; then
	echo "Incorrect number of parameters"
	break
    fi
    
    SOF_FILE=VEEK/Files/altera_de2_115_veek.sof
    COF_FILE=VEEK/Files/altera_de2_115_veek_mt.cof
    CDF_FILE=VEEK/Files/altera_de2_115_veek_mt_flash_pof.cdf
    
    if [ -f $SOF_FILE ]; then
	if [ -f $COF_FILE ]; then
	    if [ -f $CDF_FILE ]; then
                quartus_cpf -c $COF_FILE
                quartus_pgm -c 1 --mode=JTAG $CDF_FILE
                if [ $? -ne 0 ]; then
                    echo ""
                    echo " ***********************************************************************"
                    echo " *** Please check if SW19 at the back of the board is set to 'PROG'! ***"
                    echo " ***********************************************************************"
                    echo ""
                fi
	    else
		echo "The .cdf file could not be found."
		break
	    fi
	else
	    echo "The .cof file could not be found."
	    break
	fi
    else
	echo "The configuration (.sof) file could not be found."
	break
    fi

    exit 0
done

exit 1
