#!/bin/sh

for ONCE in once; do

	if [ $# -eq 1 ]; then
		if [ "$1" == "-h" ] || [ "$1" == "-H" ] || [ "$1" == "help" ]; then
			echo ""
			echo "One parameter, the Export folder's path."
			echo ""
			break		
		else
			EXPORT_PATH=$1
			PASS=YES
		fi
	fi

	if [ "$PASS" != "YES" ]; then
		echo "Incorrect number of parameters"
		break
    fi
	
	RES_DAT_FILE="$EXPORT_PATH"/Resources.dat
	RES_FLASH_FILE="$EXPORT_PATH"/Resources.flash
	
	if [ -f "$RES_DAT_FILE" ]; then
	
		bin2flash --base=0x04000000 --location=0x00a00000 --input="$RES_DAT_FILE" --output="$RES_FLASH_FILE"
	
		if [ -f "$RES_FLASH_FILE" ]; then
			nios2-flash-programmer --base=0x04000000 "$RES_FLASH_FILE"
		else
			echo "The resources flash file could not be generated."
			break
		fi
	else
		echo "The resources binary file doesn't exist."
		break
	fi	
	
	exit 0
done

exit
