#!/bin/sh

for ONCE in once; do

	if [ $# -eq 1 ]; then
		if [ "$1" == "-h" ] || [ "$1" == "-H" ] || [ "$1" == "help" ]; then
			echo ""
			echo "No parameters."
			echo ""
			break		
		fi
	fi

	if [ $# -eq 0 ]; then	
		PASS=YES
	fi
	
	if [ "$PASS" != "YES" ]; then
		echo "Incorrect number of parameters"
		break
    fi
	
	
	SOF_FILE=NEEK/Files/altera_3c25_neek.sof
	SOF_FLASH_FILE=NEEK/Files/altera_3c25_neek.flash
	ELF_FLASH_FILE=NEEK/Files/StreamRuntime.flash
	
	if [ -f $SOF_FILE ]; then
		if [ -f $ELF_FLASH_FILE ]; then

			nios2-configure-sof $SOF_FILE
		
			sof2flash --input=$SOF_FILE --output=$SOF_FLASH_FILE --offset=0x20000 --activeparallel 
			
			if [ -f $SOF_FLASH_FILE ]; then
				nios2-flash-programmer --base=0x04000000 $SOF_FLASH_FILE
				nios2-flash-programmer --base=0x04000000 $ELF_FLASH_FILE
			else
				echo "The configuration flash file could not be created."
				break
			fi
		else
			echo "The executable flash file could not be found."
			break
		fi
	else
		echo "The configuration (.sof) file could not be found."
		break
	fi	

	exit 0
done

exit 1
