#include "<*>CONTROL_CLASS_NAME<*>.h"
#include "GUIStreamReader.h"
#include "GUIStreamWriter.h"
#include "GUIStreamingException.h"
#include "GUIControlResource.h"

#include "GUIMemLeakWatcher.h" // <-- has to be the last include

#define <*>CONTROL_CLASS_VERSION_NAME<*> <*>CONTROL_CLASS_VERSION<*>

<*>CONTROL_CLASS_NAME<*>::<*>CONTROL_CLASS_NAME<*>(
    CGUICompositeObject *const pParent,
    const eC_Value &vX, const eC_Value &vY,
    const eC_Value &vWidth, const eC_Value &vHeight,
    const ObjectHandle_t &eID)
    : CGUIObject(pParent, vX, vY, vWidth, vHeight, eID)
{
#if defined(GUILIANI_WRITE_GUI)
    SetXMLTag("<*>CONTROL_CLASS_NAME<*>");
#endif
}

<*>CONTROL_CLASS_NAME<*>::<*>CONTROL_CLASS_NAME<*>()
    : CGUIObject()
{
#if defined(GUILIANI_WRITE_GUI)
    SetXMLTag("<*>CONTROL_CLASS_NAME<*>");
#endif
}

#if defined(GUILIANI_STREAM_GUI)
void <*>CONTROL_CLASS_NAME<*>::ReadFromStream()
{
    eC_Int iVersion = GETINPUTSTREAM.READ_INT(XMLTAG_CLASSVERSION); 

    switch (iVersion)
    {
    case <*>CONTROL_CLASS_VERSION<*>:
        // Insert custom attribute read calls here.
        break;
    default:
        GUILOG_THROW_EXCEPTION(
            CGUIStreamingException("", GETINPUTSTREAM.GetCurLine()),
            "<*>CONTROL_CLASS_NAME<*>::ReadFromStream: Incompatible class "
            "version! Current version is "
            + eC_String(<*>CONTROL_CLASS_VERSION_NAME<*>)
            + ", read version is " + eC_String(iVersion) + ".\n");
        break;
    }
    CGUIObject::ReadFromStream();
}
#endif

#if defined(GUILIANI_WRITE_GUI)
void <*>CONTROL_CLASS_NAME<*>::WriteToStream(const eC_Bool bWriteClassID)
{
    if(bWriteClassID)
    {
        GETOUTPUTSTREAM.WriteCommentTag(GetXMLTag());
        GETOUTPUTSTREAM.WriteInt(<*>CONTROL_CLASS_ID_NAME<*>,
            XMLTAG_CONTROLCLASSID);
    }
    GETOUTPUTSTREAM.WriteInt(<*>CONTROL_CLASS_VERSION_NAME<*>,
        XMLTAG_CLASSVERSION);
    // Insert custom attribute write calls here.
    CGUIObject::WriteToStream();
    if(bWriteClassID)
    {
        GETOUTPUTSTREAM.WriteCommentTag(eC_String("/") + GetXMLTag());
    }
}
#endif
